function [params, view] = rmDefineParameters(view,wStim);
% rmDefineParameters - define parameters for retinotopic model fit
%
% [params, view] = rmDefineParameters([view],[wStim]);
% 

% 2005/12 SOD: wrote it.

% note: this would be the case where we could ask the person
% analyzing the data to provide certain params.

if ieNotDefined('view'),
  % default vista stuff
  mrGlobals;
  loadSession;
  view=initHiddenInplane;
  %view=initHiddenGray;
  view.curDataType = 2;
else,
  global dataTYPES;
end;

if ieNotDefined('wStim'), wStim = [];end;

% now define the parameters for each scan 
nScans = viewGet(view,'nScans');
%-------------------------
%--- please select design
%-------------------------
stimulusTypes = {'wedge/ring',
                 'wedge/ring on/off'};
if isempty(wStim),
  tmp = menu('Select stimulus type: ', stimulusTypes);
  params.stimulusType = stimulusTypes{tmp};
else,
  params.stimulusType = stimulusTypes{wStim};
end;
disp(sprintf('[%s]: stimulus: %s.',mfilename,params.stimulusType));

for n=1:nScans,
  
  %-------------------------
  %--- fMRI params
  %-------------------------
  params.stim(n).framePeriod = viewGet(view,'framePeriod');
  params.stim(n).nFrames     = viewGet(view,'nFrames');
  params.stim(n).nSlices     = viewGet(view,'nSlices');


  %-------------------------
  %--- stimulus params 
  %-------------------------
  switch params.stimulusType,
   case 'wedge/ring on/off',
    % note mrSESSION's nCycles may not be reliable since there are two
    % stimulus frequencies
    if n==1,        params.stim(n).type = 'wedge'; 
    elseif n==2,    params.stim(n).type = 'ring';
    else, 
      disp(sprintf(['[%s]: Not more than two types incorporated yet.']));
      return;
    end;
    params.stim(n).wedgeIndex  = 1;
    params.stim(n).ringIndes   = 2;
    params.stim(n).nCycles     = 6;
    params.stim(n).stimWidth   = 45;   % degrees & %
    params.stim(n).stimSize    = 3;         % degrees
    % This parameter defines number of stimuli before recording
    % (due to the time-lag these may still influence the initial scans)
    params.stim(n).prescanDuration = 8;     % timeframes
    % This parameter tells how long any infinite small point would see
    % the stimulus. Defined in # timeframes.
    params.stim(n).minStimulation = (params.stim(n).nFrames./...
                                     params.stim(n).nCycles)./...
                                    (360./params.stim(n).stimWidth);
    params.stim(n).nStimOnOff     = 4;    % #
    params.stim(n).stimOnOffSeq   = [repmat([ones(16,1); zeros(8,1)], ...
                                            params.stim(n).nStimOnOff(1),1)];
    % temporal averaging is based on nUniqueRep, to speed things up
    params.stim(n).nUniqueRep     = 2;
   case 'wedge/ring',
    % note mrSESSION's nCycles may not be reliable since there are two
    % stimulus frequencies
    if n==1,        params.stim(n).type = 'wedge'; 
    elseif n==2,    params.stim(n).type = 'ring';
    else, 
      disp(sprintf(['[%s]: Not more than two types incorporated yet.']));
      return;
    end;
    params.stim(n).wedgeIndex  = 1;
    params.stim(n).ringIndes   = 2;
    params.stim(n).nCycles     = 6;
    params.stim(n).stimWidth   = 45;   % degrees & %
    params.stim(n).stimSize    = 3;         % degrees
    % This parameter defines number of stimuli before recording
    % (due to the time-lag these may still influence the initial scans)
    params.stim(n).prescanDuration = 8;     % timeframes
    % This parameter tells how long any infinite small point would see
    % the stimulus. Defined in # timeframes.
    params.stim(n).minStimulation = (params.stim(n).nFrames./...
                                     params.stim(n).nCycles)./...
                                    (360./params.stim(n).stimWidth);
    params.stim(n).nUniqueRep     = 2;
   otherwise,
    disp(sprintf('[%s]:Unknown stimulus type: %s.',...
                 mfilename,params.stimulusType));
    return;
  end;
  
end;


%-------------------------
%--- analysis params
%-------------------------
params.analysis.fieldSize   = min(params.stim.stimSize);
params.analysis.sampleRate  = .25;         % degrees
mygrid = [-params.analysis.fieldSize:...
          params.analysis.sampleRate:...
          params.analysis.fieldSize];
% To speed things up, change square matrix x,y to 1D matrix. This
% will allow to remove points that are not used. This otherwise
% needs to be done inside the analysis loop for every RF. This
% should be done here but will be done later after it is known
% which point are being used (rmMakeStimulus)
[params.analysis.X,params.analysis.Y]       = meshgrid(mygrid,mygrid);
params.analysis.calcPC      = 1;           % convert to % signal change
params.analysis.nSinDetr    = 2;           % remove sinusoids
params.analysis.nDCT        = 5;           % remove # DCTs
params.analysis.whiten      = 0;           % whiten data (boolean)
params.analysis.output      = 'log10p';    % output units
params.analysis.wHrf        = 'boynton';   %'twogammas'; % hrf type
[tmp params.analysis.Hrf]   = rfConvolveTC([1 zeros(1,params.stim(1).nFrames-1)],...
                                           params.stim(1).framePeriod,...
                                           params.analysis.wHrf);
params.analysis.Hrf         = params.analysis.Hrf(:);

% we need to convolve any predefined sequences as well!
% and time-average if we do so
if isfield(params.stim(1),'stimOnOffSeq'),
  % make stim on/off sequence
  for ii = 1:length(params.stim),
    params.stim(ii).stimOnOffSeqNoHrf = params.stim(ii).stimOnOffSeq;
                                        
    params.stim(ii).stimOnOffSeq = rfConvolveTC(params.stim(ii).stimOnOffSeq,...
                                                params.stim(1).framePeriod,...
                                                params.analysis.wHrf);
    params.stim(ii).stimOnOffSeq = rmAverageTime(params.stim(ii).stimOnOffSeq,...
                                                 params.stim(ii).nUniqueRep);
  end;
end;
    



% parameters for the first brute force fitting (looping over a set
% of equally spaced rfs, varying in x,y,rfsize). 

% define max and step
maxRF   = params.analysis.fieldSize;
maxXY   = params.analysis.fieldSize+maxRF;
step    = params.analysis.sampleRate;
% actual grid
sigma   = step:step:maxRF;
x0      = [-maxXY:step:maxXY];
y0      = [-maxXY:step:maxXY];

% Now make all possible combinations, with certain rules (a) rf
% center should be maxRF away from center, this makes our search
% field circular like our stimulus (b) xy-sigma should
% fall in fieldSize preventing estimation of 'too' small rf centers 
% 'too' far out our field of view. Somewhat arbitrary rules but will
% limit the search to rfs that are most plausible and speed it up.

% make all possible combinations first
[x, y, z] = meshgrid(x0,y0,sigma); 
x = x(:); y = y(:); z = z(:);
% keep those that fit our rules
dist = sqrt(x.^2+y.^2);
keep = find(dist<=maxXY & dist-z<=maxRF);
% put in structure
params.analysis.x0 = x(keep);
params.analysis.y0 = y(keep);
params.analysis.sigmaMajor = z(keep);
% the next two parameters reflect the size of more diffuse rf 1)
% relative to the center rf (factor), step and maximal relative to
% fieldsize (degrees).
params.analysis.sigmaRatio       = [2 3 4 5 6 8 10]';
params.analysis.sigmaRatioMaxVal = 2*params.analysis.fieldSize;


%--- parameters for search fit (fminsearch)
% p threshold below which to do search
%params.analysis.pthresh = 0.001;
% maximum iterations, precision of output (degrees), precision on
% evaluation function (RSS)
%params.analysis.MaxIter = 50;
%params.analysis.TolX    = params.analysis.sampleRate; % degrees
%params.analysis.TolFun  = .10; % relative improvement (RSS.*TolFun)

