function [prediction, weight, rf] = rfMakePrediction(params,id);
% rfMakePrediction - makes time-series based on rf-profile
% 
% [prediction, weight, rf] = rfMakePrediction(params,id);
% 
% input:
%  params  : parameter struct
%  id      : id for grid search [n] or rf-parameters
%            [sigmaMajor, sigmaMinor, sigmaTheta, x0,0]
%
%

% 2006/01 SOD: wrote it.
% 2006/03 SOD: vectorized.

% Programming note: This function is at the hart of the retinotopy
% model program and will be called lots.It is now vectorized so we
% can make all RFs in advance.

% ugly input check allowing different kinds of inputs
if length(id)==1,
    % if id == 0 then we make all the RFs 
    if id == 0,
        RF =  rfGaussian2d(params.analysis.X,params.analysis.Y,...
                           params.analysis.sigmaMajor,...
                           params.analysis.sigmaMajor,...
                           0,...
                           params.analysis.x0, ...
                           params.analysis.y0);
    else, % we make just a particular one
        RF =  rfGaussian2d(params.analysis.X,params.analysis.Y,...
                           params.analysis.sigmaMajor(id),...
                           params.analysis.sigmaMajor(id),...
                           0,...
                           params.analysis.x0(id), ...
                           params.analysis.y0(id));
    end;
else,
  % if 5 params make only 1 RF
  if prod(size(id))==5,
    RF =  rfGaussian2d(params.analysis.X,params.analysis.Y,...
                       id(1),id(2),id(3),id(4),id(5));
  else, % make lots
    RF =  rfGaussian2d(params.analysis.X,params.analysis.Y,...
                       id(:,1),id(:,2),id(:,3),id(:,4),id(:,5));
  end;
end;


% same size as the stimulus so we can dot-product, we don't dot
% product any more. Instead do a matrix computation.
% RF     = repmat(RF,[1 size(params.stim(1).images,2)]);


% make stim sequence by RF.*stim and convolve with hrf
tmp = zeros(size(params.stim(1).images,2),...
            length(params.stim),...
            size(RF,2));
sp  = params.stim(1).prescanDuration+1;
se  = size(params.stim(1).images,2);

for ii = 1:length(params.stim),
  % the next step is the slow part in the program!!
  %tmp   = sum(RF.*params.stim(ii).images); % following is faster!
  tmp(:,ii,:)   = params.stim(ii).images'*RF;
end;
% convolve right here instead of in rfConvolveTC with some more
% checks etc.
tmp        = filter(params.analysis.Hrf,1,tmp);
sz         = size(tmp);

% put predictions behind each other and average non-unique epochs
if length(sz)==2,
   prediction = tmp(sp:se,:);
   prediction = rmAverageTime(prediction,params.stim(1).nUniqueRep);
   prediction = prediction(:);
else,
   prediction = tmp(sp:se,:,:);
   prediction = rmAverageTime(prediction,params.stim(1).nUniqueRep);
   sz         = size(prediction);
   prediction = reshape(prediction,sz(1).*sz(2),sz(3));
end;

% compute the amount within the stimulus window to weight the
% fit 
if nargout > 1,
  weight = sum(RF);
  if nargout > 2,
    rf     = RF;
  end;
end;

return;
