function vol2talairachVolume(view)

global mrSESSION;

[talairach, spatialNorm] = loadTalairachXform(mrSESSION.subject);

roiNum = viewGet(view, 'curROI');
coords = view.ROIs(roiNum).coords';
name = view.ROIs(roiNum).name;
talairach = volToTalairach(coords,talairach.vol2Tal);

t = round(mean(talairach));
msg = sprintf('ROI name:\t%s\nTalairach:\t%d, %d, %d',name,t(1),t(2),t(3));

if(~isempty(spatialNorm))
    sz = size(squeeze(spatialNorm.voxToTemplateLUT(1,:,:,:)));
    inds = sub2ind(sz, coords(:,1), coords(:,2), coords(:,3));
    snc = round(mean(spatialNorm.voxToTemplateLUT(:,inds)'));
    tName = spatialNorm.sn.VG.fname;
    
    msg = [msg sprintf('\nSpatial Norm:\t%d, %d, %d\n', snc)];
    msg = [msg sprintf('MNI2Tal on SN:\t%d, %d, %d', round(mni2tal(snc)))];
    %msg = [msg tName];
end

msgbox(msg, 'Talairach');
fprintf('\n%s\n',msg);

return;
