function [talairach, spatialNorm] = loadTalairachXform(subject, tFile)
% [talairach, spatialNorm] = loadTalairachXform(subject, [fileName])
%
% SEE ALSO:
%   mrLoadRet-3+ code tree: findTalairachVolume
%   Anatomy code tree: computeTalairach, volToTalairach, talairachToVol
%
% HISTORY:
%   2002.07.17 RFD (bob@white.stanford.edu) Added comments and support for
%   the new naming convention.

talairach = [];
if(~exist('tFile','var') | isempty(tFile))
    global vANATOMYPATH;
    if(~isempty(vANATOMYPATH))
        [p,f] = fileparts(vANATOMYPATH);
        tFile = fullfile(p, [f '_talairach.mat']);
    else
        tFile = fullfile(getAnatomyPath(subject),'vAnatomy_talairach.mat');
    end
    if(~exist(tFile,'file'))
        % try the old-style name
        tFile = fullfile(fileparts(tFile), 'talairach.mat');
    end
end

while(~exist(tFile,'file'))
    ansButton = questdlg(['talairach.mat file not found in',getAnatomyPath(subject),...
            ' What would you like to do?'], ...
        'Talairach file not found', 'Abort', 'Find It', 'Create It', 'Find It');
    if(strcmp(ansButton,'Abort'))
        return;
    elseif(strcmp(ansButton,'Create It'))
        uiwait(computeTalairach(fullfile(getAnatomyPath(subject),'vAnatomy.dat')));
    else
        [f,p] = uigetfile('*.mat', ['Find talairach.mat file for ',subject,'...']);
        tFile = fullfile(p,f);
    end
end
talairach = load(tFile);
if isempty(talairach)
    myErrorDlg('No talairach transform. Aborting...');
end

% Also try to load the spatial normalization file, if it exists
snFile = fullfile(fileparts(tFile),'vAnatomy_sn.mat');
if(exist(snFile,'file'))
    spatialNorm = load(snFile);
else
    spatialNorm = [];
end

return;