function tMat = tSeries4D(view,scan,verbose);
% tMat = tSeries4D(view,[scan],[verbose]);
%
% Produce a 4D matrix of size rows x cols x slices x time
% for the current view/scan.
%
% verbose: flag to put up a waitbar. Defaults to 0, off.
%
% 12/04 ras.
% 03/05 ras: trying to save memory by using uint16's.
if ieNotDefined('scan')
    scan = getCurScan(view);
end

if ieNotDefined('verbose')
    verbose = 0;
end

switch view.viewType
    case {'Inplane'},
        dims = dataSize(view,scan);
        nFrames = numFrames(view,scan);
    
        for f = 1:nFrames            
            tMat(:,:,:,f) = uint16(zeros(dims));
        end
        
        if verbose
            hwait = waitbar(0,'Loading tSeries...');
        end
        
        for slice = 1:numSlices(view)
            tSeries = loadtSeries(view,scan,slice);
            tSeries = reshape(tSeries',[dims(1) dims(2) 1 nFrames]);
            tMat(:,:,slice,:) = int16(tSeries);
            
            if verbose
                waitbar(slice/numSlices(view),hwait);
            end
        end
        
        if verbose, close(hwait); end
    case {'Flat'},
        tMat = flatLevelTSeries(view,scan);
    otherwise,
        error(sprintf('%s view not supported yet.',view.viewType));
end

return
