function copyOrigPhaseTseries(view, scanNum, sliceNum);
%
% copyOrigPhaseTseries(view, scanNum, sliceNum);
%
% Copies tSeries[scanNum].dat to origTseries[scanNum].dat.
% Error if origTseries already exists.
%
% djh, 4/29/99

global mrSESSION

% Path to tSeries files
pathStr = fullfile(mrSESSION.viewDir, view.subdir,'phaseTSeries', ['Scan',num2str(scanNum)]);

% fileNames
fileName = fullfile(pathStr, ['tSeries',num2str(sliceNum),'.dat']);
origFileName = fullfile(pathStr, ['origTSeries',num2str(sliceNum),'.dat']);

% Error if tSeries is in old format (.mat)
if ~exist([fileName],'file')
   myErrorDlg(['TSeries file ' fileName ...
      'does not exist.  Perhaps tSeries is in .mat format (use convertMatToDat)']);
end

% Error if origTSeries file already exists.
if exist(origFileName,'file')
   myErrorDlg([origFileName 'already exists.  ' ...
         'Motion compensation has already been performed.  '...
         'Use revert tSeries to undo motion compensation.  Then try again.']);
end

% Copy original tSeries in origTSeries.dat
% status = copyfile(fileName,origFileName);
% IF THIS BOMBS, GET BILL -- copyfile does not run on NT with UNC paths
warning off;
command(['cp ' fileName ' ' origFileName]);
status=1;
warning backtrace;

if (~status) | (~exist(origFileName,'file'))
   myErrorDlg([fileName ' could not be copied to ' origFileName]);
end

return
