%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% TRANSFORMATION SCRIPT
%
%    gb 05/09/05
%
% This script runs 4 motion compensation algorithms and computes glms for each dataType. 
% All these transformations have Scan1 has
% a reference. The transformations are:
%       - Rigid Body 
%       - Rigid Body around the occipital lobes
%       - Non Linear
%       - Rigid Body + Non Linear
%
% The current inplane has to be stored into the variable vw
% example :
%
%   close all
%   clear all
%   mrVista
%   vw = getSelectedInplane;
%   transformAll
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all
close all
pack 
mrVista
vw = getSelectedInplane;
scans = 1:6;
%compute glm for original dataType
er_runSelxavgBlock(vw,scans,1);
% compute meanMaps for original
if ~exist(fullfile(HOMEDIR,'Inplane','Original','meanMap.mat'),'file')
    vw = computeMeanMap(vw,0);
end
motionCompMeanMovie(vw);
%run mc rigid, compute glm, mean maps are computed on the way and saved
clear all
close all
pack
mrVista
vw = getSelectedInplane;
scans = 1:6;
runMotionCompensation(vw,scans,'',1,'Rigid_Scan1','Original',1,0,1,1);
%run mc non linear, compute glm, mean maps are computed on the way and saved
clear all
close all
pack
mrVista;
vw = getSelectedInplane;
scans = 1:6;
runMotionCompensation(vw,scans,'',1,'NL_Scan1','Original',0,1,1,1);
% on already NL corrected data, run mc rigid on Occ ROI, compute glm, mean maps are computed on the way and saved
% 
% close all
% 
% clear all
% 
% pack
% 
% mrVista
% 
% vw = getSelectedInplane;
% scans = 1:6;
% ROI = zeros([sliceDims(vw,1) numberSlices(vw)]);
% 
% ROI((end - 50):(end - 20),30:(end - 30),15:19) = ones(size(ROI((end - 50):(end - 20),30:(end - 30),15:19)));
% 
% runMotionCompensation(vw,scans,ROI,1,'NL+RigidOcc_Scan1','NL_Scan1',1,0,1,1);

%run rigid and then non linear, compute glm, mean maps are computed on the way and saved
clear all
close all
pack
mrVista;
vw = getSelectedInplane;
scans = 1:6;
runMotionCompensation(vw,scans,'',1,'Rigid+NL_Scan1','Original',1,1,1,1);