function view = computeCorAnal(view,scanList,forceSave)
%
% view = computeCorAnal(view,[scanList],[forceSave])
% 
% Loops throughs scans and slices, loads corresponding tSeries,
% computes correlation analysis from tSeries, and saves the
% resulting co, amp, and ph to the corAnal.mat file.
%
% scanList: 
%   0 - do all scans
%   number or list of numbers - do only those scans
%   default - prompt user via selectScans dialog
%
% If you change this function make parallel changes in:
%    computeResStdMap, computeStdMap, computeMeanMap
% 
% djh, 2/21/2001, updated to mrLoadRet-3.0
if ieNotDefined('forceSave'),   forceSave = 0;        end

nScans = numScans(view);

% load the corAnal file if it's not already loaded
corAnalFile = fullfile(dataDir(view), 'corAnal.mat');
if exist(corAnalFile,'file')
    view = loadCorAnal(view);
end

% If corAnal file doesn't exist, initialize to empty cell array
if isempty(view.co)
    co = cell(1, nScans);
    amp = cell(1, nScans);
    ph = cell(1, nScans);
else
    co = view.co;
    amp = view.amp;
    ph = view.ph;
end

% (Re-)set scanList
if ~exist('scanList','var')
    scanList = er_selectScans(view);
elseif scanList == 0
    scanList = 1:nScans;
end

if isempty(scanList)
  error('Analysis aborted');
end

disp('Computing corAnal...');
waitHandle = waitbar(0,'Computing corAnal matrices from the tSeries.  Please wait...');
for scanIndex=1:length(scanList)
    scanNum = scanList(scanIndex);
    disp(['Processing scan ', int2str(scanNum),'...']);
    dims = sliceDims(view,scanNum);
    nCycles = numCycles(view,scanNum);
    
    co{scanNum} = NaN*ones(dataSize(view,scanNum));
    amp{scanNum} = NaN*ones(dataSize(view,scanNum));
    ph{scanNum} = NaN*ones(dataSize(view,scanNum));
    
    for sliceNum = sliceList(view, scanNum)
        [coSeries, ampSeries, phSeries] = ...
            computeCorAnalSeries(view, scanNum, sliceNum, nCycles);
        switch view.viewType
        case 'Inplane'
            co{scanNum}(:,:,sliceNum) = reshape(coSeries, dims);
            amp{scanNum}(:,:,sliceNum) = reshape(ampSeries, dims);
            ph{scanNum}(:,:,sliceNum) = reshape(phSeries, dims);
        case 'Gray'
            co{scanNum} = coSeries;
            amp{scanNum} = ampSeries;
            ph{scanNum} = phSeries;
        case 'Flat'
            co{scanNum}(:,:,sliceNum) = reshape(coSeries, dims);
            amp{scanNum}(:,:,sliceNum) = reshape(ampSeries, dims);
            ph{scanNum}(:,:,sliceNum) = reshape(phSeries, dims);
        end
    end
    waitbar(scanIndex/length(scanList), waitHandle);
end
close(waitHandle);

% Set coranal fields in the view
view.co = co;
view.amp = amp;
view.ph = ph;

% Save results
saveCorAnal(view,forceSave);

return;

