function noiseBand = GetNoiseBand(view, scan)
%
% noiseBand = GetNoiseBand(view, scan)
%
% Purpose:
% Gets the noise band, the frequency-domain indices of that
% portion of the power spectrum to be used to estimate the
% noise power. 
% Returns value of zero indicates default behavior: use ALL power-spectral samples.
%
% Ress, 8/30/02
global dataTYPES;
if ~exist('scan', 'var')
    if isfield(view, 'ui')
        scan = getCurScan(view);
    else
        scan = 1;
    end
end

noiseBand = 0; 
if isfield(dataTYPES(view.curDataType).blockedAnalysisParams(scan), 'noiseBand')
  noiseBand = dataTYPES(view.curDataType).blockedAnalysisParams(scan).noiseBand;
  sprintf('Using noise band of %.0f\n',noiseBand);
end

return;
