function view = atlasError(view)
%
% view = atlasErrorMap(view)
% 
% Author:
% Purpose:
%   2003.01.14 RFD (bob@white.stanford.edu): wrote it.

ringWedgeScans = readRingWedgeScans;
wedgeScanNum =ringWedgeScans(2);
ringScanNum = ringWedgeScans(1);
atlasView = getAtlasView;
if(isempty(atlasView)), myErrorDlg('Open a FLAT window in Atlas view.'); end
curDataType = dtGetCurNum(view);
curSlice = getCurSlice(view);

% Create a map for every scan num.  This is the parameter map field.
for(ii=1:numScans(view)),  view.map{ii} = []; end

d = view.ph{wedgeScanNum}(:,:,curSlice);
a = atlasView.ph{wedgeScanNum}(:,:,curSlice);
view.map{wedgeScanNum}(:,:,curSlice) = abs(exp(sqrt(-1)*d) - exp(sqrt(-1)*a));

d = view.ph{ringScanNum}(:,:,curSlice);
a = atlasView.ph{ringScanNum}(:,:,curSlice);
view.map{ringScanNum}(:,:,curSlice) = abs(exp(sqrt(-1)*d) - exp(sqrt(-1)*a));

view.ui.mapMode.clipMode = [0,pi];

view.map{wedgeScanNum}(isnan(view.map{wedgeScanNum})) = -0.01;
view.map{ringScanNum}(isnan(view.map{ringScanNum})) = -0.01;

view.ui.mapMode = setColormap(view.ui.mapMode,'hotCmap');

return;

% figure; 
% plot(d(:),a(:),'.')

