function [visualField,corners,areaROI,retPhases,view] = atlasDefinition(atlasName,ringWedgeScans,view)
%   [visualField,corners,areaROI,retPhases,view] = atlasDefinition(atlasName,ringWedgeScans,view)
%
% Author: Wandell, Brewer
% Purpose:
%    Define the properties of a group of retinotopic visual areas that
%    will serve as an atlas for template matching.
%
%   ringWedgeScans are the scanNums of the ring (ringWedgeScans(1)) and
%   wedge (ringWedgeScans(2)) data.
%
% [visualField,corners,areaROI,retPhases,view] = atlasDefinition('ventralV2V3V4',[2,1],FLAT{2});
%
% History: 
% 15/11/04  marking V1/V2/V3 changed by MMS (mark@ski.org) so that you no
% longer mark V1 then V2 then V3 but just mark V1 and V3. V2 is then assumed
% to lie between.  
% see line 282, I think this deal with the problems adressed in 272 by
% Wandell or Brewer
%



view.ui.showROIs=-2;
view = refreshView(view);

if sum(abs([view.rotateImageDegrees,view.flipLR]))~=0
    error('The fields ''.rotateImageDegrees'' and ''.flipLR'' of the FLAT structure must be zero.');
end

switch lower(atlasName)
    
    case {'hemifield','hf'}
        clear msg
        
        msg{1}  = sprintf('Select:\n');           
        newText = sprintf('Point 1: low eccentricity and angle phases.\n');  msg{1} = addText(msg{1},newText);
        newText = sprintf('Point 2: low eccentricity phase and high angle phase.\n');msg{1} = addText(msg{1},newText);
        newText = sprintf('Continue to complete the quadrilateral');      msg{1} = addText(msg{1},newText);
        
        % This becomes, say, the V1/V2 function.
        % It gets its own message box and is a template for the creation of other
        % atlas creation routines.
        visualField{1} = 'hemifield';   %V1
        
        corners = {};
        msgHndl = mrMessage(msg{1},'left',[0.8000    0.1000    0.1800    0.1000]);
        
        [locs, areaROI{1},view] = atlasGraphicDefinition('quadrilateral',view);
        corners{1} = locs.corners;
        delete(msgHndl);
        
        % Use the data to estimate the phases
        c{1} = corners{1};
        retPhases = atlasEstimatePhases(view,c,ringWedgeScans);
        
        % Show the user what just happened.
        view = refreshView(view);
        
    case {'lqf','lowerquarterfield'}
        
        clear msg
        
        msg{1}  = sprintf('Select:\n');           
        newText = sprintf('Point 1: low eccentricity and angle phases.\n');  
        msg{1} = addText(msg{1},newText);
        newText = sprintf('Point 2: low eccentricity phase and high angle phase.\n');
        msg{1} = addText(msg{1},newText);
        newText = sprintf('Continue to complete the quadrilateral');      
        msg{1} = addText(msg{1},newText);
        
        % This becomes, say, the V1/V2 function.
        % It gets its own message box and is a template for the creation of other
        % atlas creation routines.
        visualField{1} = 'lowerquarterfield';   % Dorsal V3, for example
        
        corners = {};
        msgHndl = mrMessage(msg{1},'left',[0.8000    0.1000    0.1800    0.1000]);
        
        [locs, areaROI{1},view] = atlasGraphicDefinition('quadrilateral',view);
        corners{1} = locs.corners;
        delete(msgHndl);
        
        % Use the data to estimate the phases
        c{1} = corners{1};
        retPhases = atlasEstimatePhases(view,c,ringWedgeScans);
        
        % Show the user what just happened.
        view = refreshView(view);
        
    case {'uqf','upperquarterfield'}
        clear msg
        
        msg{1}  = sprintf('Select:\n');           
        newText = sprintf('Point 1: low eccentricity and angle phases.\n');  msg{1} = addText(msg{1},newText);
        newText = sprintf('Point 2: low eccentricity phase and high angle phase.\n');msg{1} = addText(msg{1},newText);
        newText = sprintf('Continue to complete the quadrilateral');      msg{1} = addText(msg{1},newText);
        
        % This becomes, say, the V1/V2 function.
        % It gets its own message box and is a template for the creation of other
        % atlas creation routines.
        visualField{1} = 'upperquarterfield';   % Dorsal V3, for example
        
        corners = {};
        msgHndl = mrMessage(msg{1},'left',[0.8000    0.1000    0.1800    0.1000]);
        
        [locs, areaROI{1},view] = atlasGraphicDefinition('quadrilateral',view);
        corners{1} = locs.corners;
        delete(msgHndl);
        
        % Use the data to estimate the phases
        c{1} = corners{1};
        retPhases = atlasEstimatePhases(view,c,ringWedgeScans);
        
        % Show the user what just happened.
        view = refreshView(view);
        
    case {'hemiuppervf','hV4V3'}
        
        clear msg
        
        msg{1}  = sprintf('Select hemifield (e.g., hV4)\n');           
        newText = sprintf('Point 1: low eccentricity and angle phases.\n');  msg{1} = addText(msg{1},newText);
        newText = sprintf('Point 2: low eccentricity phase and high angle phase.\n');msg{1} = addText(msg{1},newText);
        newText = sprintf('Continue to complete the quadrilateral');      msg{1} = addText(msg{1},newText);
        
        msg{2}  = sprintf('Select quarterfield (e.g., V3v)\n');           
        newText = sprintf('Point 1: low eccentricity and angle phases.\n');msg{2} = addText(msg{2},newText);
        newText = sprintf('Point 2: low eccentricity phase and high angle phase.\n');msg{2} = addText(msg{2},newText);
        newText = sprintf('Continue to complete the quadrilateral');  msg{2} = addText(msg{2},newText);
        
        % This becomes, say, the V1/V2 function.
        % It gets its own message box and is a template for the creation of other
        % atlas creation routines.
        visualField{1} = 'hemifield';           %hV4
        visualField{2} = 'upperquarterfield';   %V3 Ventral
        
        corners = {};
        for ii=1:2
            
            msgHndl = mrMessage(msg{ii},'left',[0.8000    0.1000    0.1800    0.1000]);
            
            [locs, areaROI{ii},view] = atlasGraphicDefinition('quadrilateral',view);
            corners{ii} = locs.corners;
            
            delete(msgHndl);
            
        end
        
        % We need a GUI for deciding who goes with what.  This ordering of the code
        % assumes that visualArea{1} is in the middle and 2 and 3 are surrounding it.
        % We might make sure that we always get a certain corner match.  Sometimes,
        % two corners end up being matched to the same one ...
        corners{2} = atlasMergeAdjacentCorners(corners{1},corners{2});
        
        % Now replace the ROIs with the new ROIs with appropriately adjusted corners.
        view = selectROI(view,areaROI{2});
        view = replaceROIQuadrilateralCoords(view,corners{2});
        
        % Use the data to estimate the phases
        c{1} = corners{1};
        retPhases = atlasEstimatePhases(view,c,ringWedgeScans);
        
        % Show the user what just happened.
        view = refreshView(view);
        
        
    case {'2hemifields','VO1VO2'}
        
        clear msg
        
        msg{1}  = sprintf('Select hemifield (e.g., VO1)\n');           
        newText = sprintf('Point 1: low eccentricity and angle phases.\n');  msg{1} = addText(msg{1},newText);
        newText = sprintf('Point 2: low eccentricity phase and high angle phase.\n');msg{1} = addText(msg{1},newText);
        newText = sprintf('Continue to complete the quadrilateral');      msg{1} = addText(msg{1},newText);
        
        msg{2}  = sprintf('Select hemifield (e.g., VO2)\n');           
        newText = sprintf('Point 1: low eccentricity and angle phases.\n');msg{2} = addText(msg{2},newText);
        newText = sprintf('Point 2: low eccentricity phase and high angle phase.\n');msg{2} = addText(msg{2},newText);
        newText = sprintf('Continue to complete the quadrilateral');  msg{2} = addText(msg{2},newText);
        
        % This becomes, say, the V1/V2 function.
        % It gets its own message box and is a template for the creation of other
        % atlas creation routines.
        visualField{1} = 'hemifield';    %VO-1
        visualField{2} = 'hemifield';    %VO-2
        
        corners = {};
        for ii=1:2
            
            msgHndl = mrMessage(msg{ii},'left',[0.8000    0.1000    0.1800    0.1000]);
            
            [locs, areaROI{ii},view] = atlasGraphicDefinition('quadrilateral',view);
            corners{ii} = locs.corners;
            
            delete(msgHndl);
            
        end
        
        % We need a GUI for deciding who goes with what.  This ordering of the code
        % assumes that visualArea{1} is in the middle and 2 and 3 are surrounding it.
        % We might make sure that we always get a certain corner match.  Sometimes,
        % two corners end up being matched to the same one ...
        corners{2} = atlasMergeAdjacentCorners(corners{1},corners{2});
        
        % Now replace the ROIs with the new ROIs with appropriately adjusted corners.
        view = selectROI(view,areaROI{2});
        view = replaceROIQuadrilateralCoords(view,corners{2});
        
        % Use the data to estimate the phases
        c{1} = corners{1};
        retPhases = atlasEstimatePhases(view,c,ringWedgeScans);
        
        % Show the user what just happened.
        view = refreshView(view);
        
    case 'v1/v2'
        clear msg
        
        msg{1}  = sprintf('Select V1.\n');           
        newText = sprintf('Point 1: low eccentricity and angle phases.\n');  msg{1} = addText(msg{1},newText);
        newText = sprintf('Point 2: low eccentricity phase and high angle phase.\n');msg{1} = addText(msg{1},newText);
        newText = sprintf('Continue to complete the quadrilateral');      msg{1} = addText(msg{1},newText);
        
        msg{2}  = sprintf('Select lower quarter field of V2.\n');           
        newText = sprintf('Point 1: low eccentricity and angle phases.\n');msg{2} = addText(msg{2},newText);
        newText = sprintf('Point 2: low eccentricity phase and high angle phase.\n');msg{2} = addText(msg{2},newText);
        newText = sprintf('Continue to complete the quadrilateral');  msg{2} = addText(msg{2},newText);
        
        msg{3}  = sprintf('Select upper quarter field of V2.\n');           
        newText = sprintf('Point 1: low eccentricity and angle phases.\n');msg{3} = addText(msg{3},newText);
        newText = sprintf('Point 2: low eccentricity phase and high angle phase.\n');msg{3} = addText(msg{3},newText);
        newText = sprintf('Continue to complete the quadrilateral');   msg{3} = addText(msg{3},newText);
        
        
        % This becomes, say, the V1/V2 function.
        % It gets its own message box and is a template for the creation of other
        % atlas creation routines.
        visualField{1} = 'hemifield';   %V1
        visualField{2} = 'lowerquarterfield'; %Dorsal V2
        visualField{3} = 'upperquarterfield'; %Ventral V2
        
        corners = {};
        for ii=1:3
            
            msgHndl = mrMessage(msg{ii},'left',[0.8000    0.1000    0.1800    0.1000]);
            
            [locs, areaROI{ii},view] = atlasGraphicDefinition('quadrilateral',view);
            corners{ii} = locs.corners;
            
            delete(msgHndl);
            
            % Set view to show all ROI perimeters
            view.ui.showROIs=-2;
            view = refreshView(view);
            
        end
        
        % We need a GUI for deciding who goes with what.  This ordering of the code
        % assumes that visualArea{1} is in the middle and 2 and 3 are surrounding it.
        % We might make sure that we always get a certain corner match.  Sometimes,
        % two corners end up being matched to the same one ...
        corners{2} = atlasMergeAdjacentCorners(corners{1},corners{2});
        corners{3} = atlasMergeAdjacentCorners(corners{1},corners{3});
        
        % Now replace the ROIs with the new ROIs with appropriately adjusted corners.
        view = selectROI(view,areaROI{2});
        view = replaceROIQuadrilateralCoords(view,corners{2});
        view = selectROI(view,areaROI{3});
        view = replaceROIQuadrilateralCoords(view,corners{3});
        
        % Use the data to estimate the phases
        c{1} = corners{1};
        retPhases = atlasEstimatePhases(view,c,ringWedgeScans);
        
        % Show the user what just happened.
        view = refreshView(view);
        
        
    case 'v4/v8'
        error('Not yet implemented: v4/v8');
        
        
    case 'v1/v2/v3'
        clear msg
        
        msg{1}  = sprintf('Select V1.\n');           
        newText = sprintf('Point 1: low eccentricity and angle phases.\n');  msg{1} = addText(msg{1},newText);
        newText = sprintf('Point 2: low eccentricity phase and high angle phase.\n');msg{1} = addText(msg{1},newText);
        newText = sprintf('Continue to complete the quadrilateral.\n');      msg{1} = addText(msg{1},newText);     
        newText = sprintf('NEW: After marking V1, continue with marking V3v, just with the same scheme.\n');msg{1} = addText(msg{1},newText);
        
        
        msg{2}  = sprintf('Select lower quarter field of V3.\n');           
        newText = sprintf('Point 1: low eccentricity and angle phases.\n');msg{2} = addText(msg{2},newText);
        newText = sprintf('Point 2: low eccentricity phase and high angle phase.\n');msg{2} = addText(msg{2},newText);
        newText = sprintf('Continue to complete the quadrilateral');  msg{2} = addText(msg{2},newText);
        
        msg{3}  = sprintf('Select upper quarter field of V3.\n');           
        newText = sprintf('Point 1: low eccentricity and angle phases.\n');msg{3} = addText(msg{3},newText);
        newText = sprintf('Point 2: low eccentricity phase and high angle phase.\n');msg{3} = addText(msg{3},newText);
        newText = sprintf('Continue to complete the quadrilateral');   msg{3} = addText(msg{3},newText);
        
        % This becomes, say, the V1/V2 function.
        % It gets its own message box and is a template for the creation of other
        % atlas creation routines.
        visualField{1} = 'hemifield';   %V1
        visualField{2} = 'lowerquarterfield'; %Dorsal V2
        visualField{3} = 'upperquarterfield'; %Ventral V2
        visualField{4} = 'lowerquarterfield'; %Dorsal V3
        visualField{5} = 'upperquarterfield'; %Ventral V3
        
        corners = {};
        for ii=1:3
            
            msgHndl = mrMessage(msg{ii},'left',[0.8000    0.1000    0.200    0.1200]);
            
            [locs, areaROI{ii},view] = atlasGraphicDefinition('quadrilateral',view);
            corners{ii} = locs.corners;
            
            delete(msgHndl);
            
            % Set view to show all ROI perimeters
            view.ui.showROIs=-2;
            view = refreshView(view);
            
        end
        
        % We need a GUI for deciding who goes with what.  This ordering of the code
        % assumes that visualArea{1} is in the middle and 2 and 3 are surrounding it.
        % We might make sure that we always get a certain corner match.  Sometimes,
        % two corners end up being matched to the same one ...
        
        % this old merging of corner  becomes obsolet
        % corners{2} = atlasMergeAdjacentCorners(corners{1},corners{2});
        % corners{3} = atlasMergeAdjacentCorners(corners{1},corners{3});
        % corners{4} = atlasMergeAdjacentCorners(corners{2},corners{4});
        % corners{5} = atlasMergeAdjacentCorners(corners{3},corners{5});
        
        %instead get V2 corners from V1 and V3
        %first copy corners of V3ventral and dorsal to pos 4 ad 5
        corners{4}=corners{2};
        corners{5}=corners{3};
        
        %V2v
        corners{2}(1,1:2)=corners{4}(1,1:2); %from V3v
        corners{2}(2:3,1:2)=corners{1}(2:3,1:2); %from V1
        corners{2}(4,1:2)=corners{4}(4,1:2); %from V3v
        
        %V2d
        corners{3}(1,1:2)=corners{1}(1,1:2); %from V1
        corners{3}(2:3,1:2)=corners{5}(2:3,1:2); %from V1
        corners{3}(4,1:2)=corners{1}(4,1:2);%from V1 
        
        %add the ROIS 4 and 5 to the ROI-List and to the "areaROI"-variable
        %---- maybe there is a more elegante way t perform this....
        
        found = roiExistName(view,'Quad',0)
        if found == 0, num = 1; else num = length(found)+1; end
        roiName = sprintf('Quad-%.0f',num);
        view=newROI(view,roiName,1,[0 0 0]);
        areaROI=cat(2,areaROI,{roiName});
        roiName = sprintf('Quad-%.0f',num+1);
        view=newROI(view,roiName,1,[0 0 0]);
        areaROI=cat(2,areaROI,{roiName});
        
        % Now replace the ROIs with the new ROIs with appropriately
        % adjusted corners.  Simplyfied...
        for jup=2:5
            view = selectROI(view,areaROI{jup});
            view = replaceROIQuadrilateralCoords(view,corners{jup});
        end
        
        
        % Use the data to estimate the phases
        c{1} = corners{1};
        retPhases = atlasEstimatePhases(view,c,ringWedgeScans);
        
        % Show the user what just happened.
        view = refreshView(view);
        
    case 'ventralv2v3v4'
        [view,visualField,corners,retPhases,areaROI] = ventralV2V3V4(atlasName,ringWedgeScans,view);
        
    otherwise
        error(sprintf('Unknown atlas name: %s',atlasName));
    end
    
    return;
    
    
    function [view,visualField,corners,retPhases,areaROI] = ventralV2V3V4(atlasName,ringWedgeScans,view)
    %
    
    msg{1}  = sprintf('Select ventral V2.\n');           
    newText = sprintf('Point 1: low eccentricity and angle phases.\n');  msg{1} = addText(msg{1},newText);
    newText = sprintf('Point 2: low eccentricity phase and high angle phase.\n');msg{1} = addText(msg{1},newText);
    newText = sprintf('Continue to complete the quadrilateral');      msg{1} = addText(msg{1},newText);
    
    msg{2}  = sprintf('Select ventral V3.\n');           
    newText = sprintf('Point 1: low eccentricity and angle phases.\n');msg{2} = addText(msg{2},newText);
    newText = sprintf('Point 2: low eccentricity phase and high angle phase.\n');msg{2} = addText(msg{2},newText);
    newText = sprintf('Continue to complete the quadrilateral');  msg{2} = addText(msg{2},newText);
    
    msg{3}  = sprintf('Select ventral V4.\n');           
    newText = sprintf('Point 1: low eccentricity and angle phases.\n');msg{3} = addText(msg{3},newText);
    newText = sprintf('Point 2: low eccentricity phase and high angle phase.\n');msg{3} = addText(msg{3},newText);
    newText = sprintf('Continue to complete the quadrilateral');   msg{3} = addText(msg{3},newText);
    
    visualField{1} = 'upperquarterfield';   % Ventral V2
    visualField{2} = 'upperquarterfield';   %Ventral V3
    visualField{3} = 'upperquarterfield';   %Ventral V4
    
    corners = {};
    
    % Set view to show all ROI perimeters
    view.ui.showROIs=-2;
    view = refreshView(view);
    for ii=1:3
        
        msgHndl = mrMessage(msg{ii},'left',[0.8000    0.1000    0.1800    0.1000]);
        
        [locs, areaROI{ii},view] = atlasGraphicDefinition('quadrilateral',view);
        corners{ii} = locs.corners;
        
        delete(msgHndl);
        view = refreshView(view);
        
    end
    
    % We need a GUI for deciding who goes with what.  This ordering of the code
    % assumes that visualArea{1} is in the middle and 2 and 3 are surrounding it.
    % We might make sure that we always get a certain corner match.  Sometimes,
    % two corners end up being matched to the same one ...
    corners{2} = atlasMergeAdjacentCorners(corners{1},corners{2});
    corners{3} = atlasMergeAdjacentCorners(corners{2},corners{3});
    
    % Now replace the ROIs with the new ROIs with appropriately adjusted corners.
    view = selectROI(view,areaROI{2});
    view = replaceROIQuadrilateralCoords(view,corners{2});
    view = selectROI(view,areaROI{3});
    view = replaceROIQuadrilateralCoords(view,corners{3});
    
    % Use the data in the first one to estimate the phases
    c{1} = corners{1};
    retPhases = atlasEstimatePhases(view,c,ringWedgeScans);
    
    % Show the user what just happened.
    view = refreshView(view);
    
    return;
    