function rxSaveVolume(rx,volPath,format);
%
% rxSaveVolume([rx],[savePath],[format]):
%
% Take the current transformation specified
% by a mrRx rx struct, apply it to the current
% volume, and save it in the specified save path
% and format.
%
% If savePath is omitted, brings up a dialog.
%
% 
% ras 03/05
if ieNotDefined('rx')
    cfig = findobj('Tag','rxControlFig');
    rx = get(cfig,'UserData');
end


if ieNotDefined('savePath')
    % put up a dialog
    opts = {...
            '*.dat' 'mrVista vAnatomy files' ...
            '*.img' 'ANALYZE fies' ...
            '*.dcm' 'DICOM files' ...
            'I*'  'I files' ...
        };
    [fname pth] = uiputfile(opts,'Save Xformed Volume...');
    savePath = fullfile(pth,fname);
end

% much more to do!

[newImg,xform,deformField] = mrAnatResliceSpm(img, xform, bb, mmPerVox, bSplineParams)

return

