function rxSaveMrVistaAlignment(rx,mrSessPath);
%
% rx = rxSaveMrVistaAlignment([rx],[mrSessPath]);
%
% Save a mrRx alignment to a mrSESSION.mat file 
% in the specified path. 
%
% If an existing alignment has already been
% saved, prompts the user and, if the old alignment
% is saved over, cleans all gray, volume, and 
% flat directories.
%
% ras 03/05.
if ieNotDefined('rx')
    cfig = findobj('Tag','rxControlFig');
    rx = get(cfig,'UserData');
end

if ieNotDefined('mrSessPath')
    mrSessPath = fullfile(pwd,'mrSESSION.mat');
end

if ~exist(mrSessPath,'file')
    msg = sprintf('%s not found.',mrSessPath);
    myErrorDlg(msg);
end

mrGlobals;
loadSession;

% check if an alignment already exists
if isfield(mrSESSION, 'alignment')
    msg = ['An existing alignment has been loaded into this '...
          'mrVista session. If you proceed, you will permanently ' ...
          'delete this alignment, and need to rebuild any Volume, ' ...
          'Gray, and Flat views you''ve made with the old alignment.'];
      
    response = questdlg(msg,'Existing Alignment Found', 'Yes', 'No', 'Yes');
    
    if ~isequal(response,'Yes')
        % abort
        disp('Did not save new alignment.')
        return
    end
    
	% delete (after confirmation) old files that were built 
    % using previous alignment.
	cleanAllFlats
	cleanGray
	cleanVolume
end

% If we've made it this far, go ahead and replace mrSESSION.alignment field.   
% first account for x,y -> y,x change
newXform = rx.xform;
newXform([1 2],:) = newXform([2 1],:);
newXform(:,[1 2]) = newXform(:,[2 1]);

% now add to mrSESSION struct and save
mrSESSION.alignment = newXform; 
saveSession


disp('mrSESSION.alignment has been updated and saved.');


return
