function rx = rxOpenInterpFig(rx);
%
%  rx = rxOpenInterpFig(rx);
%
% Open a window for the transformed, interpolated volume.
%
% ras 02/05.
javaFigs=feature('javafigures');
feature('javafigures', 0);

rx.ui.interpFig = figure('Color','w',...
                      'Name','mrRx Prescribed Slice',...
                      'Units','Normalized',...
                      'ButtonDownFcn','zoom',...
                      'NumberTitle','off',...
                      'Position',[.35 .25 .3 .4]);

rx.ui.interpAxes = axes('Position',[0 .15 1 .75]);

% make brightness and contrast sliders
rx.ui.interpBright = rxMakeSlider('Brightness',[0 1],...
                             [.35 .02 .3 .1],0,0.5);
rx.ui.interpContrast = rxMakeSlider('Contrast',[0 1],...
                             [.68 .02 .3 .1],0,0.5);  

% make a contrast auto-threshold checkbox as well
rx.ui.interpHistoThresh = uicontrol('Style', 'checkbox', ...
                        'String', 'Auto-contrast', ...
                        'Units', 'normalized', ...
                        'Position', [.05 .05 .25 .05], ...
                        'FontSize', 10, 'BackgroundColor', 'w', ...
                        'Value', 0, 'Callback', 'rxRefresh;');                         
                         

feature('javafigures',javaFigs);

return
