function rx = rxLoadSettings(rx,loadPath);
%
% rx = rxLoadSettings(rx,loadPath);
%
% Load settings fields in a mrRx struct.
%
%
% ras 03/05.
if ieNotDefined('rx')
    cfig = findobj('Tag','rxControlFig');
    rx = get(cfig,'UserData');
end

if ieNotDefined('loadPath')
    loadPath = 'mrRxSettings';
end

fprintf('Loading settings from %s ...\n',loadPath);
tmp = load(loadPath);


% whatever params were saved,
% load into rx struct
fields = fieldnames(tmp);

for i = 1:length(fields)
    rx.(fields{i}) = tmp.(fields{i});
end

% set the list of settings to match
% the loaded settings
names = {rx.settings.name};
names = [{'(Default)'} names];
set(rx.ui.storedList,'String',names,'Value',length(names));
rxReset(rx,length(names));


return
