function [interpImg, interpImg3D] = rxInterpSlice(rx,rxSlice);
%
% [interpImg, interpImg3D] = rxInterpSlice(rx,rxSlice);
%
% Given the transform matrix and slice specified by
% the mrRx GUI, compute an interpolated slice.
%
% Returns two images: interpImg is a 2D matrix
% with the raw interpolated values; interpImg3D
% is a 3D TrueColor image, with the brightness
% and contrast settings of the GUI taken into
% account.
%
% ras 03/05.
if ~exist('rx', 'var') | isempty(rx), rx = get(gcf, 'UserData'); end
if ~exist('rxSlice', 'var') | isempty(rxSlice)
    rxSlice = get(rx.ui.rxSlice.sliderHandle, 'Value'); 
end

xsz = rx.rxDims(1);
ysz = rx.rxDims(2);
zsz = rx.rxDims(3);

% build up coords for interp vol slice
% here we flip: x->cols, y->rows
[Y X Z] = meshgrid(1:ysz,1:xsz,rxSlice); 
coords = [Y(:) X(:) Z(:) ones(size(Z(:)))]';
coords = double(coords);

% get new coords for the interp slice
newCoords = rx.xform * coords;

% interpolate
interpVals = myCinterp3(rx.vol,rx.volDims(1:2),rx.volDims(3),newCoords(1:3,:)',0);
interpImg = reshape(interpVals,[xsz ysz]);

% convert to truecolor if requested
if nargout >= 2
    interpImg3D = rxClip(interpImg, [], rx.ui.interpBright, ...
                         rx.ui.interpContrast, rx.ui.interpHistoThresh);
end

return
