function rx = rxFineMutualInf(rx);
%
% rx = rxFineMutualInf(rx);
%
% Perform a fine alignment using SPM2's 
% Mutual-Information based tools.
%
% ras 03/05
if ieNotDefined('rx')
    cfig = findobj('Tag','rxControlFig');
    rx = get(cfig,'UserData');
end

h = msgbox('Using Mutual Information to Compute Alignment...');

% build an interpolated volume to compare to
% the reference volume:
for slice = 1:rx.refDims(3)
    rxVol(:,:,slice) = rxInterpSlice(rx,slice);
end

% set coregistration flags for SPM code
% (See spm_defaults for a full set of default values;
% this has been adjusted some for mrVista prefs)
flags.estimate.cost_fun = 'nmi'; % normalized mutual information, see s
flags.estimate.sep      = [4 2]; % optimization sampling steps
flags.estimate.tol      = [0.02 0.02 0.02 0.001 0.001 0.001 0.01 0.01 0.01 0.001 0.001 0.001];
flags.estimate.fwhm     = [0 0]; % full-width half-max smoothing kernel -- turn off
flags.write.interp      = 1;
flags.write.wrap        = [0 0 0];
flags.write.mask        = 0;


% set parameters for each matrix
originA = (rx.rxDims+1)./2;
originB = (rx.refDims+1)./2;
paramsA.mat = inv([diag(1./rx.rxVoxelSize) originA'; 0 0 0 1]);
paramsB.mat = inv([diag(1./rx.refVoxelSize) originB'; 0 0 0 1]);
paramsA.scale = 0.0232;
paramsB.scale = 0.0232;

% compute a set of rotation parameters
rot = mrSPM_coregTwoFrames(rx.ref,rxVol,paramsA,paramsB,flags);

% convert into a 4x4 affine xform matrix
newXform = eye(4)\spm_matrix(rot(:)')*eye(4);

% apply on top of existing xform
newXform = newXform * rx.xform;

% set in rx struct and mark the settings
rx = rxSetXform(rx,newXform);

rxStore(rx,'Mutual Inf Align');

close(h)

return