function h = rxEditMenu(parent);
%
% h = rxEditMenu(parent);
%
% Make a menu for mrRx file commands,
% attached to parent object.
%
% ras 02/05.
if ieNotDefined('parent')
    parent = gcf;
end

h = uimenu(parent,'Label','Edit');

% undo menu
cb = ['rx = get(gcf, ''UserData''); ' ...
      'tmp = rx.xform; rxSetXform(rx, rx.prevXform); ' ...
      'rx.prevXform = tmp; set(gcf, ''UserData'', rx);'];
uimenu(h, 'Label', 'Undo', 'Accelerator', 'Z',...
       'Separator','on', 'Callback', cb);

% mid-sagittal alignment
uimenu(h, 'Label', 'Prescribe Mid-Sagittal',...
       'Separator', 'on', 'Callback', 'rxMidSagRx;');

% mid-coronal
uimenu(h, 'Label', 'Prescribe Mid-Coronal', 'Separator', 'on', ...
    'Callback','rxMidCorRx;');


% mid-coronal
uimenu(h, 'Label', 'Prescribe Oblique (~Perpendicular to Calcarine)', ...
    'Separator', 'on',  'Callback', 'rxObliqueRx;');

% % Compare Images submenu
% rxComparePrefsMenu(h);

% flip slice order 
uimenu(h, 'Label', 'Flip Slice Order', 'Separator', 'on', ...
    'Callback', 'rxFlipSliceOrder;');
   
%%%%%%%%%%%%%%%%%%%%
% Points submenu   %
%%%%%%%%%%%%%%%%%%%%
hpoints = uimenu(h,'Label','Points','Separator','on');

% add points
uimenu(hpoints,'Label','Add Points',...
       'Accelerator','P','Callback','rxAddPoints;');

% remove points
uimenu(hpoints,'Label','Delete Points',...
       'Accelerator','D','Callback','rxRemovePoints;');   

% toggle show/hide points
uimenu(hpoints,'Label','Show Points','Checked','on',...
       'Tag','showPointsMenu',...
       'Accelerator','S','Callback','umtoggle(gcbo); rxRefresh;');

return