function windowID = mrmStart(windowID,host)
%
%  windowID = mrmStart(windowID,host)
%
%Author: Wandell
%Purpose:
%   Start the mrMesh server on your platform.  
%   Runs for PCWIN and GLNX86. 
%
%  To start the server without opening a window, use
%       windowID = mrmStart(-1,'localhost')
%  or   mrmStart;
%
%  To start the server and open window 3, use
%       windowID = mrmStart(3,'localhost')
% or    windowID = mrmStart(3);
%
% History
% 
% AG, 2005/01/17 Added MAC srvPath

if ieNotDefined('windowID'), windowID = -1; end
if ieNotDefined('host'), host = 'localhost'; end

switch computer
    case 'PCWIN'
        srvPath = which('mrMeshSrv.exe');
        dos([srvPath ' &']);        
    case 'GLNX86'
        srvPath = which('mrMeshSrv.glx');
        unix(sprintf('%s &', srvPath));
	case 'MAC'
		srvPath = which('mrMeshServer.app');
		srvPath = [srvPath '/Contents/MacOS/mrMeshServer'];
		eval(['! ' srvPath ' &']);
    otherwise
        error(['Platform "' computer '" is not supported!']);
end

if windowID >= 0
    % Some annoying inter-process communication pause.  Do not remove.  Ask
    % Ress or Bob about this.
    pause(2); 
    windowID = mrMesh(host, windowID, 'refresh'); 
    pause(1);
else
    windowID = -1;
end

return