function [msh, meshDir] = mrmReadMeshFile(filename)
%
% [msh, meshDir] = mrmReadMeshFile([filename])
%
% Author: RFD
% Purpose:
%   Read a msh file (*.mat). If the filename is not specified or doesn't
%   exist, the user is prompted.  The msh filename is returned in
%   msh.fileName.  The msh.id is set to -1.
%   
%   The second output argument is the path to the directory containing
%   the mesh.
%
% ras, 10/2005.

% Define mesh so that even if we fail it will be returned (though empty).
msh = [];
meshDir = [];

if notDefined('filename')
    global vANATOMYPATH
    
    curDir = pwd;
    if notDefined('vANATOMYPATH')
        % stay in this directory
    else
        [p,n] = fileparts(vANATOMYPATH);
        chdir(p);
        
        % KGS-lab: we started keeping our stuff in a Meshes/ directory.
        if exist('Meshes', 'dir'), cd Meshes; end
    end
    
    filename = '';
    [f,p] = uigetfile({'*.mat';'*.*'}, 'Select a mesh file');
    chdir(curDir);
    
    if(isnumeric(f)) msh = []; return; end
    filename = fullfile(p,f);
    
elseif exist(filename,'file') == 7
    % The user sent in a directory, not a file
    dirName = filename;
    curDir = pwd; chdir(dirName);
    [f,p] = uigetfile({'*.mat';'*Mesh.*'}, 'Read mesh file');
    chdir(curDir);
    
    if(isnumeric(f)) msh = []; return; end
    filename = fullfile(p,f);
    
end

% Shouldn't be necessary, but ... maybe it doesn't exist
if ~exist(filename,'file'); msh = []; return; end

% Load the file.
load(filename);
msh = meshFormat(msh);

% Sometimes the file is in the local directory.  The which() returns a full
% path to the filename.
[meshDir,f,ext] = fileparts(fullpath(filename));
f = [f ext];

% Add the file name and current mesh id (none) to the mesh structure
msh = meshSet(msh, 'path', fullfile(meshDir, f));
msh = meshSet(msh, 'filename', filename);
msh = meshSet(msh, 'windowid', -1);

return;