function prefs = mrmPreferences
% Prompts user to adjust mrMesh preferences. Initializes defaults if ~exist.
% prefs = mrmPreferences
%
% The user will usually only be prompted if the preferences don't yet
% exist. However, if you call this function with no return arg, it will
% always prompt.
%
% HISTORY:
% 2005.08.11 RFD wrote it.
% 2006.02.06 RAS added pref for dimming cmap -- helps w/ phase maps.
%                also made the check for new prefs more robust.

if(nargout==0)
    promptUser = true;
else
    promptUser = false;
end

prefNames = {'overlayModulationDepth', 'dataSmoothIterations', ...
            'dimCmap', 'roiDilateIterations', 'clusterThreshold', ...
            'layerMapMode', 'overlayLayerMapMode'};
prefHelp = {'allows sulcal pattern to show through overlay', ...
            'try 1 or 2', ...
            'can make phase maps nicer, try 0.7', ...
            '1 or 2 may help fill splotchy ROIs', ...
            '1 or 2 may help hide specle noise', ...
            'options: ''all'' or ''layer1''', ...
            'options: ''mean'' or ''max'''};
        
% layerMapMode values: 'all', 'layer1'
defaultVals = {0.2, 2, 1, 0, 0, 'layer1', 'max'};
if (~ispref('mesh'))
    setpref('mesh', prefNames, defaultVals);
    promptUser = true;
    disp(['Initializing mesh rendering preferences- run ' mfilename ' to change them in the future.']);
else
    % check if any new preferences were added or old preferences removed
    prefs = getpref('mesh');
    existingPrefs = fieldnames(prefs)';
    newPrefs = setdiff(prefNames, existingPrefs);
    for i = find(ismember(prefNames, newPrefs))
        % new preferences were added- try to keep this user's old values.
        % keep old vals by only adding new prefs.
        setpref('mesh', prefNames{i}, defaultVals{i});
        promptUser = true;
        disp(['New mesh rendering preferences were added (remember- use ' ...
                mfilename ' to change prefs in the future).']);
    end
    
    if ~isempty(newPrefs)
        % need to shuffle order of fields in prefs struct to 
        % correspond to the order in prefNames. <sigh>
        prefs = getpref('mesh');
        rmpref mesh
        for i = 1:length(prefNames)
            setpref('mesh', prefNames{i}, prefs.(prefNames{i}));
        end
        prefs = getpref('mesh')
    end
    
    % these prefs may have been set before, but are no longer relevant.
    removedPrefs = setdiff(existingPrefs, prefNames);
    for name = removedPrefs(:)',  rmpref('mesh', name{1});  end
end

if(promptUser)
    prefs = getpref('mesh');
    for(ii=1:length(prefNames))
        prompt{ii} = [prefNames{ii} '- ' prefHelp{ii}];
    end
    defAns = struct2cell(prefs);
    wasNumeric = zeros(size(defAns));
    for(ii=1:length(defAns))
        if(~ischar(defAns{ii}))
            defAns{ii} = num2str(defAns{ii});
            wasNumeric(ii) = 1;
        end
    end
    resp = inputdlg(prompt, 'Adjust mesh rendering preferences', 1, defAns);
    if(~isempty(resp))
        for(ii=find(wasNumeric(:)'))
            resp{ii} = str2num(resp{ii});
        end
        setpref('mesh', prefNames, resp);
    end
end

prefs = getpref('mesh');

return;