function mrmInflate(meshFile,iter,inflatedMeshFile);
% mrmInflate - inflate (unfold) mesh
% mrmInflate([meshFile],[iterations=400],[inflatedMeshFile]);
%


if ieNotDefined('meshFile'),
  [filename, pathname] = uigetfile('*.mat','Select mrMesh file');
  meshFile             = fullfile(pathname,filename);
end;
if ieNotDefined('iter'),
    iter = 400;
end;
if ieNotDefined('inflatedMeshFile'),
  [p,f,e]          = fileparts(meshFile);
  inflatedMeshFile = fullfile(p, [f '_surfRelaxed_' num2str(iter) e]);
end;

surfrelaxFile = fullfile(fileparts(which('mrmInflate')), 'surfrelax');
load(meshFile);

% Save mesh in OOGL (.off) format
inFile = [tempdir 'tempOOGL.off'];
outFile = [tempdir 'tempOOGL_relaxed.off']

% Open file
fid = fopen(inFile, 'w');
if fid == -1 error('Could not open file'); end
    
% Header
fprintf(fid, 'OFF\n');
fprintf(fid, '%d %d %d\n', ...
size(msh.initVertices,2), size(msh.data.triangles,2), 0); 

% Vertices
newVerts = msh.initVertices;
for(ii=1:3) newVerts(ii,:) = newVerts(ii,:) + msh.data.origin(ii); end
fprintf(fid, '%f %f %f\n', newVerts);

% Faces
fprintf(fid, '3 %d %d %d\n', msh.data.triangles);

% Close file
fclose(fid);

%cmd = '/home/dumoulin/bin/surfrelax';
opt = ['-iter ' num2str(iter) ' -dist 0.1'];
system([surfrelaxFile ' ' opt ' ' inFile ' ' outFile]);

% Read new vertex locations
fid = fopen(outFile, 'r', 'ieee-be');
if fid == -1 error('Could not open file'); end
    
% Header
hdr = fgetl(fid);
n = fread(fid, 3, 'int32');

% Read the vertices
newVerts = fread(fid, [3 n(1)], 'float32');
newTriangles = fread(fid, [5 n(2)], 'int32');
fclose(fid);

for(ii=1:3) newVerts(ii,:) = newVerts(ii,:) - msh.data.origin(ii); end

newTriangles = newTriangles(2:4,:);
if(sum(newTriangles(:)-msh.data.triangles(:))>0)
    error('triangles do not match!');
end

%oldVerts = msh.data.vertices;
%oldNormals = msh.data.normals;
msh.lights = [];
% mrMesh will recompute the normals if we remove them
if(isfield(msh.data,'normals'))
    msh.data = rmfield(msh.data,'normals');
end
msh.id = -1;
msh.data.vertices = newVerts;
[p, msh.name] = fileparts(inflatedMeshFile);
%msh.name = [msh.name '_relaxed']
msh.fileName = inflatedMeshFile;
%mrmInitMesh(msh);

save(inflatedMeshFile, 'msh');
