function [mHires,figNum] = makeMontage3(r, g, b, slices, mmPerPix, upsampleFactor, sliceLabels, numAcross, figNum)
%
% [mHires,figNum] = makeMontage3(r, g, b, slices, [mmPerPix], [upsampleFactor], [sliceLabels], [numAcross], [figNum])
%
% Purpose: Calls makeMontage 3 times to build a montage of RGB
% images. You pass in the red (r), green (g) and blue (b) planes
% separately. This routine will also add a scale bar, if you tell
% it the mmPerVoxel for the sliced dimension (the third). It will
% also super-sample the resulting montage if upSapleFactor is >0.
%
%   
% Example:
%
% HISTORY:
% 2002.??.?? RFD wrote it.

if(~exist('slices','var') | isempty(slices))
  slices = [1:size(r,3)]; 
end
if(~exist('upsampleFactor','var') | isempty(upsampleFactor))
  upsampleFactor = 1; 
end
if(~exist('sliceLabels','var') | isempty(sliceLabels))
  sliceLabels = {}; 
end
if(~exist('numAcross','var') | isempty(numAcross))
  numAcross = ceil(sqrt(length(slices)));
end

% m(:,:,1) = makeMontage(abs(flipdim(permute(r,[3,1,2]),1)),slices,[],numAcross);
% m(:,:,2) = makeMontage(abs(flipdim(permute(g,[3,1,2]),1)),slices,[],numAcross);
% m(:,:,3) = makeMontage(abs(flipdim(permute(b,[3,1,2]),1)),slices,[],numAcross);
m(:,:,1) = makeMontage(r,slices,[],numAcross);
m(:,:,2) = makeMontage(g,slices,[],numAcross);
m(:,:,3) = makeMontage(b,slices,[],numAcross);

m = double(m);
mHires(:,:,1) = upSample(m(:,:,1), upsampleFactor);
mHires(:,:,2) = upSample(m(:,:,2), upsampleFactor);
mHires(:,:,3) = upSample(m(:,:,3), upsampleFactor);

if(strcmp(class(r),'uint8')),  maxVal = 255;
else   maxVal = 1.0;
end

mHires(mHires<0) = 0;
mHires(mHires>maxVal) = maxVal;
if(exist('mmPerPix','var') & ~isempty(mmPerPix))
  cmBarLen = round(1/mmPerPix * 10 * 2^upsampleFactor);
%% ERROR HERE because end-cmBarlen-5 may not be valid -- BW
  mHires(end-5, end-cmBarLen-5:end-5, :) = maxVal;
  mHires(end-4, end-cmBarLen-5:end-5, :) = maxVal;
end

% preserve the input class (eg. uint8, double)
eval(['mHires=' class(r) '(mHires);']);

if(~exist('figNum','var') | isempty(figNum)), figNum = figure; end
if(figNum>0), 
  figure(figNum);
  if(exist('imshow')==2)
    iptsetpref('ImshowBorder','tight')
    imshow(mHires);
  else
    image(mHires); axis equal; axis off;
    set(gca,'Position',[0,0,1,1]);
  end
  labelNum = 0;
  numDown = ceil(length(slices)/numAcross);
  numX = size(mHires,2)./numAcross;
  numY = size(mHires,1)./numDown;
  if(~isempty(sliceLabels))
    for(jj=0:numDown-1)
      for(ii=0:numAcross-1)    
        labelNum = labelNum+1;
        if(labelNum>length(sliceLabels))
          break;
        end
        yoff = 20;
        text(ii*numX+3+1,jj*numY+yoff+1, sliceLabels{labelNum}, 'FontName','Helvetica','FontSize',10,'Color',[.3 .3 .3]);
        text(ii*numX+3,jj*numY+yoff, sliceLabels{labelNum}, 'FontName','Helvetica','FontSize',10,'Color',[.9 .9 .9]);
      end
    end
  end
end
return
