function  img = makeCubeIfiles(baseFileName, imDim, imList, numDigits, byteFlag)
% img = makeCubeIfiles(baseFileName, imDim, [imList], [numDigits], [byteFlag])
%
% Reads in reconstructed Pfile images and compiles
% them into an image cube.  
%
% if imList unknown, can put empty.
% numDigits is the number of digits in the numerical 
% filename extension. Default is 3 (eg. I.001).
%
% see also makeMontageIfiles
%
% 2001.02.21 RFD: allowed error-recover if an image is missing. 
% 2004.01.23 Junjie: now call getIfileNames.m to auto get all I-files 

if ~exist('imList','var'); imList = []; end;
if exist('numDigits','var');
    allIfileNames = getIfileNames(baseFileName,imList,numDigits);
else
    allIfileNames = getIfileNames(baseFileName,imList);
end

if(~exist('imDim') | isempty(imDim))
    [su_hdr1,ex_hdr1,se_hdr1,im_hdr1] = readIfileHeader(allIfileNames{1});
    imDim = double([im_hdr1.imatrix_X im_hdr1.imatrix_Y]);
elseif length(imDim) == 1
   imDim = [imDim imDim];
end
    

header = 0;
if(~exist('byteFlag','var')|isempty(byteFlag))
   if (strcmp(computer,'PCWIN') | strcmp(computer,'GLNX86'))
      byteFlag = 'b';
   else
      byteFlag = 'n';
   end
end

nImages = length(allIfileNames);
img = zeros(imDim(2),imDim(1),nImages);
for ii = 1:nImages;
    tempImg = readRawImage(allIfileNames{ii}, header, imDim, byteFlag);
    if(~isempty(tempImg))
        img(:,:,ii) = tempImg;
    end
end

return;
