function [sn, Vtemplate] = mrAnatComputeSpmSpatialNorm(img, xform, templateFileName, params)
%
% [sn, Vtemplate] = mrAnatComputeSpmSpatialNorm(img, xform, templateFileName, params)
%
% Simple wrapper to the spm2 spatial normalization routine. Does a little
% pre-processing on the input img (a 3d array) and will prompt for a
% template file if none is provided. xform is the starting 4x4 affine guess-
% ideally, it should take the input image space to ac-pc space (ie. centered on
% the ac, in mm).
%
% HISTORY:
% 2004.12.07 RFD: wrote it.
% 2005.08.05 RFD: renamed (was dtiSpmNormalize).

if(~exist('templateFileName','var') | isempty(templateFileName))
    spmDir = fileparts(which('spm_defaults'));
    templateFileName = fullfile(spmDir, 'templates', 'T1.mnc');
    [f,p] = uigetfile({'*.mnc','MINC'; '*.img','Analyze';'*.nii.gz','NIFTI gz';'*.*','All'},...
                      'Select the template...', templateFileName);
    if(isnumeric(f)) disp('User cancelled.'); return; end
    templateFileName = fullfile(p,f);
end
if(~exist('params','var')|isempty(params))
  spm_defaults; global defaults;
  params = defaults.normalise.estimate;
end

Vtemplate = spm_vol(templateFileName);
if(~strcmp(class(img),'uint8'))
    img = double(img);
    img = img-min(img(:));
    img = uint8(img./max(img(:))*255);
end
if(length(Vtemplate.dim)==4)
    Vin.dim = [size(img) spm_type(class(img))];
else
    % The type number (dim(4) has been removed in spm5.
    Vin.dim = [size(img)];
end
Vin.dat = img;
Vin.mat = xform; 
Vin.pinfo = [1 0]';
sn = spm_normalise(Vtemplate, Vin, '', '', '', params);
sn.VF = rmfield(sn.VF, 'dat');
sn.VG.fname = Vtemplate.fname;
return;
