/*************************************************
*
* For more help type from a Matlab environment:
*   help grow_gray
*
* To compile it, type from a Matlab environment:
*   mex grow_gray.cpp
*
***************************************************/

#include "mex.h"
#include "matrix.h"

#include "mrGlobals.h"
#include "gray.cpp"

/*void CGray::checkConnexity(GrayMatter *gm)
{
    gm->connex = new int[gm->gm_size];
    gm->num_connex = 1;
     
    int i = 0;
    for (int i = 0; i < gm->gm_size; i++) {
        if (!gm->connex[i]) {
            assignConnexity(gm,i);
            (gm->num_connex)++;
        }
    }
    
}*/

void CGray::checkConnexity(GrayMatter *gm) {
	
	gm->connex = new int[gm->gm_size];
	for (int i = 0; i < gm->gm_size; i++) {
		gm->connex[i] = i;
	}

	while (assignConnexity(gm)) {}

	int current_connex;

	gm->num_connex = 0;
	for (int i = 0; i < gm->gm_size; i++) {
		if (gm->connex[i] > gm->num_connex) {
			current_connex = gm->connex[i];
			(gm->num_connex)++;
			for (int j = 0; j < gm->gm_size; j++) {
				if (gm->connex[j] == current_connex)
					gm->connex[j] = gm->num_connex;
			}
		}
	}
}

int CGray::assignConnexity(GrayMatter *gm) {

	int flag = 0;
	int i2;

	for (int i = 0; i < gm->gm_size; i++) {
		for (int j = 0; j < gm->gm_array[i].num_gm_nbhrs; j++) {
			i2 = gm->gm_array[i].gm_nbhrs[j];
			if (gm->connex[i] != gm->connex[i2]) {
				if (gm->connex[i] > gm->connex[i2]) gm->connex[i2] = gm->connex[i];
				else gm->connex[i] = gm->connex[i2];
				flag = 1;
			}
		}
	}

	return flag;
}

/*void CGray::assignConnexity(GrayMatter *gm, int index)
{
    int index2;
    gm->connex[index] = gm->num_connex;
    int j = 0;
    for (int j = 0; j < gm->gm_array[index].num_gm_nbhrs; j++) {
        index2 = gm->gm_array[index].gm_nbhrs[j];
        if (!gm->connex[index2]) {
            assignConnexity(gm,index2);
        }
    }
}*/

void CGray::keepStrongComponent(GrayMatter *gm) 
{
	
    int *count = new int[gm->num_connex];
    
    for (int i = 0; i < gm->num_connex; i++) count[i] = 0;
    for (int i = 0; i < gm->gm_size; i++) count[gm->connex[i]]++;
    
    int max = 0;
    int max_ind = 0;
    
    for (int i = 0; i < gm->num_connex; i++) {
        if (count[i] >= max) {
            max = count[i];
            max_ind = i;
        }
    }
   
    GrayVoxel *gm_array_single_comp = new GrayVoxel[max];
    int *connex_single_comp = new int[max];

    int counter = 0;
    int *conversion = new int[gm->gm_size];
    for (int i = 0; i < gm->gm_size; i++) {
		conversion[i] = -1;
        if (gm->connex[i] == max_ind) {
            gm_array_single_comp[counter] = gm->gm_array[i];
            connex_single_comp[counter] = gm->connex[i];
            
            conversion[i] = counter;
            counter++;
        }
    }
	 
    for (int i = 0; i < max; i++)
        for (int j = 0; j < gm_array_single_comp[i].num_gm_nbhrs; j++)
            gm_array_single_comp[i].gm_nbhrs[j] = 
                conversion[gm_array_single_comp[i].gm_nbhrs[j]];
            
    gm->gm_array = gm_array_single_comp;
    gm->connex = connex_single_comp;
    gm->gm_size = max;

	int	x, y, z, yskip, zskip, xsize, ysize, zsize, new_gm;
	int	voi_xmin, voi_xmax, voi_ymin, voi_ymax, voi_zmin, voi_zmax;
	unsigned char *cvol, *cvolx, *cvoly, *cvolz;

	voi_xmin = gm->voi_xmin; voi_xmax = gm->voi_xmax;
	voi_ymin = gm->voi_ymin; voi_ymax = gm->voi_ymax;
	voi_zmin = gm->voi_zmin; voi_zmax = gm->voi_zmax;
	yskip = gm->mrvol->yskip; zskip = gm->mrvol->zskip;
	cvol = gm->mrvol->cvol + voi_zmin*zskip + voi_ymin*yskip + voi_xmin;
	
	xsize = voi_xmax-voi_xmin+1;
	ysize = voi_ymax-voi_ymin+1;
	zsize = voi_zmax-voi_zmin+1;

	for (z=voi_zmin, cvolz=cvol; z<=voi_zmax; z++, cvolz+=zskip)
		for (y=voi_ymin, cvoly=cvolz; y<=voi_ymax; y++, cvoly+=yskip)
			for (x=voi_xmin, cvolx=cvoly; x<=voi_xmax; x++, cvolx++)
				gm->inv_gm_table[(z-voi_zmin)*xsize*ysize+(y-voi_ymin)*xsize+(x-voi_xmin)] = -1;

	for (int i = 0; i < gm->gm_size; i++) {
		x = gm->gm_array[i].x;
		y = gm->gm_array[i].y;
		z = gm->gm_array[i].z;
		gm->inv_gm_table[z*zskip+y*yskip+x] = i;
	}
 
	delete[] count;
	
}
    

void mexFunction(int nlhs, mxArray *plhs[], int nrhs, const mxArray *prhs[])
{
    
    // Parsing arguments
    const int *dim;
    
    if (nrhs < 2) mexErrMsgTxt("This function should take at least two argument");
    
    if (!mxIsNumeric(prhs[0]) || mxIsComplex(prhs[0]))
		mexErrMsgTxt("Wrong sort of data (1).");
	if (mxGetNumberOfDimensions(prhs[0]) != 3) 
        mexErrMsgTxt("Wrong number of dims (1).");
    
    dim  = mxGetDimensions(prhs[0]);
    
    if (!mxIsNumeric(prhs[1]) || mxIsComplex(prhs[1]))
		mexErrMsgTxt("Wrong sort of data (2).");
    if (mxGetM(prhs[1])*mxGetN(prhs[1]) != 1)
        mexErrMsgTxt("Wrong number of dims (2).");

    int NGrayLayers = (int) mxGetPr(prhs[1])[0];

    int layer0 = 0;
    
    int xVoi = 1, yVoi = 1, zVoi = 1;
    if (nrhs > 2) {
        xVoi = (int) mxGetPr(prhs[2])[0];
        yVoi = (int) mxGetPr(prhs[2])[2];
        zVoi = (int) mxGetPr(prhs[2])[4];
    }
    
    if (nrhs > 3) {
        if (mxGetM(prhs[3])*mxGetN(prhs[3]) != 1)
            mexErrMsgTxt("Wrong number of dims (4).");
        layer0 = ((int) mxGetPr(prhs[3])[0]);
        if (layer0 > 2) layer0 = 0;
    }

    MRVol mrvol;
    mrvol.xsize = dim[0];
    mrvol.ysize = dim[1];
    mrvol.zsize = dim[2];
    mrvol.yskip = dim[0];
    mrvol.zskip = dim[0]*dim[1];
    mrvol.cvol = (unsigned char *)mxGetPr(prhs[0]);
    mrvol.gm = NULL;
    
    int nvoxels = mrvol.xsize*mrvol.ysize*mrvol.zsize;
    
    VOItype *voi = new VOItype;
    voi->x1 = 0;
    voi->y1 = 0;
    voi->z1 = 0;
    voi->x2 = mrvol.xsize - 1;
    voi->y2 = mrvol.ysize - 1;
    voi->z2 = mrvol.zsize - 1;
    
    CGray *GrayFuncs = new CGray();
    GrayFuncs->m_ContendWhite = 1;
	GrayFuncs->m_ContendGray = 1;
    
    GrayMatter	*gm;
 
    // Delete gray matter in cvol.
	{
		int n=mrvol.zsize*mrvol.zskip;
		unsigned char *p=mrvol.cvol;
		while (n--) {
			if (((*p)&CLASS_MASK)==GRAY_CLASS) *p=UNKNOWN_CLASS;
			p++;
		}
	}
    
    // Delete existing gray matter structure.
    if (mrvol.gm) GrayFuncs->free_gray_matter(mrvol.gm);

    // Initialise a new one... 
    gm = mrvol.gm = GrayFuncs->init_gray_matter(&mrvol);
	
    if (!gm) mexErrMsgTxt("Error! Out of memory.");
    
    // Grow the gray matter.
	{

		ASSERT(mrvol.cvol);
		ASSERT(gm->mrvol->cvol);
		ASSERT(mrvol.cvol==gm->mrvol->cvol);

        gm->layer0 = layer0;
        
		bool ret=GrayFuncs->grow_gray_layers(gm,voi->x1, voi->x2,voi->y1, voi->y2,voi->z1, voi->z2,
					NGrayLayers);

		if (!ret)
        {
            GrayFuncs->free_gray_matter(gm);
			mrvol.gm = NULL;
            mexErrMsgTxt("Error! Out of memory.");
		}
	 }
     
	 // Keeps only the largest connex component 
     GrayFuncs->checkConnexity(gm);
     GrayFuncs->keepStrongComponent(gm);
     
	 if (gm->layer0 == 1)
        GrayFuncs->add_white_boundary(gm);
     
     if (gm->layer0 == 2)
         GrayFuncs->add_white_matter(gm);
     
     
     // Creating outputs
     plhs[0] = mxCreateDoubleMatrix(8,gm->gm_size,mxREAL);
     
     double *outNodes, *outEdges;
     outNodes = mxGetPr(plhs[0]);
     
     int total_neighbors = 0;
     int i, j;
     
     for (i = 0 ; i < gm->gm_size; i++) {
         outNodes[8*i] = gm->gm_array[i].x + xVoi;
         outNodes[8*i + 1] = gm->gm_array[i].y + yVoi;
         outNodes[8*i + 2] = gm->gm_array[i].z + zVoi;
         outNodes[8*i + 5] = gm->gm_array[i].layer;
         
         total_neighbors += gm->gm_array[i].num_gm_nbhrs;
     }
     
     plhs[1] = mxCreateDoubleMatrix(1,total_neighbors,mxREAL);
     outEdges = mxGetPr(plhs[1]);
     
     int indexNeighbors = 0, neigh;
     
     for (i = 0; i < gm->gm_size; i++) {
         neigh = gm->gm_array[i].num_gm_nbhrs;
        
         outNodes[8*i + 3] = gm->gm_array[i].num_gm_nbhrs;
         outNodes[8*i + 4] = indexNeighbors + 1;
         
         for (j = 0; j < neigh; j++)
             outEdges[indexNeighbors + j] = gm->gm_array[i].gm_nbhrs[j] + 1;
         indexNeighbors += neigh;
     }

	 return;

     // We used to delete variables but sometimes it crashes because of this 
	 // when running on a linux platform. I really don't know why
     
	 /*delete[] dim;
     delete voi;
     delete GrayFuncs;
     delete gm;
     delete outNodes;
     delete outEdges;
     */
}