#!/usr/bin/env python2
# -*- coding: utf-8 -*-
"""
This will run the stimuli defined in places1.xlsx - places8.xlsx
"""

from __future__ import division  # so that 1/3=0.333 instead of 1/3=0
from psychopy import visual, core, data, event, logging, sound, gui
from psychopy.constants import *  # things like STARTED, FINISHED
import numpy as np  # whole numpy lib is available, prepend 'np.'
from numpy import sin, cos, tan, log, log10, pi, average, sqrt, std, deg2rad, rad2deg, linspace, asarray
from numpy.random import random, randint, normal, shuffle
import os  # handy system and path functions

## custom imports
from numpy import *
import time

# Initialize components for Routine "getMRIMode"
getMRIModeClock = core.Clock()
##lets ask if we are in mri Mode? with a popup dialog
#mriInfo = {u'MRImode': u''}
#dlg2 = gui.DlgFromDict(dictionary=mriInfo, title='Are you using mri mode? - 1 for yes, 0 for no')
#if dlg2.OK == False: core.quit()

##are we in MRI or not - useful for testing
#fmri_mode = int(mriInfo['MRImode'])

fmri_mode = 0
FullScreenMode = True



##

# Ensure that relative paths start from the same directory as this script
_thisDir = os.path.dirname(os.path.abspath(__file__))
os.chdir(_thisDir)

# Store info about the experiment session
expName = 'FMRI_Experiment'  # from the Builder filename that created this script
expInfo = {u'participant': u''}
dlg = gui.DlgFromDict(dictionary=expInfo, title=expName)
if dlg.OK == False: core.quit()  # user pressed cancel
expInfo['date'] = data.getDateStr()  # add a simple timestamp
expInfo['expName'] = expName

# Data file name stem = absolute path + name; later add .psyexp, .csv, .log, etc
filename = _thisDir + os.sep + 'data/%s_%s_%s' %(expInfo['participant'], expName, expInfo['date'])

# An ExperimentHandler isn't essential but helps with data saving
thisExp = data.ExperimentHandler(name=expName, version='',
    extraInfo=expInfo, runtimeInfo=None,
    originPath=None,
    savePickle=True, saveWideText=True,
    dataFileName=filename)
#save a log file for detail verbose info
logFile = logging.LogFile(filename+'.log', level=logging.EXP)
logging.console.setLevel(logging.WARNING)  # this outputs to the screen, not a file

endExpNow = False  # flag for 'escape' or other condition => quit the exp

# Start Code - component code to be run before the window creation

# Setup the Window
win = visual.Window(size=(1024,768), fullscr=FullScreenMode, screen=0, allowGUI=False, allowStencil=False,
    monitor='testMonitor', color=[-0.216,-0.216,-0.216], colorSpace='rgb',
    blendMode='avg', useFBO=True,
    )
# store frame rate of monitor if we can measure it successfully
expInfo['frameRate']=win.getActualFrameRate()
if expInfo['frameRate']!=None:
    frameDur = 1.0/round(expInfo['frameRate'])
else:
    frameDur = 1.0/60.0 # couldn't get a reliable measure so guess



# Initialize components for Routine "instr"
instrClock = core.Clock()
text_2 = visual.TextStim(win=win, ori=0, name='text_2',
    text=u'You will be presented with a short series of images simultaneously flashing on the screen in 4 positions - top left, top right, bottom right and bottom left.\n\nBefore each block you will see a cue which will tell you which TARGET (FACE or PLACE) to look for.\n\nYou will need to indicate in which position a cued TARGET appeared. [RED]=top left; [GREEN]=top right; [BLUE]=bottom right; [YELLOW]=bottom left. If you do not see the cued TARGET, [LEAVE BLANK].\n\nAfter the images you will have a limited time to respond during which you will see a question mark.\nPlease try to be as accurate and fast as possible.\n\n\n[Press [ANY BUTTON] to start the practice block when you are ready.] <\u2014 PRACTICE BLOCK?',    font='Arial',
    pos=[0, 0], height=0.05, wrapWidth=None,
    color='white', colorSpace='rgb', opacity=1,
    depth=-1.0)

# Initialize components for Routine "beginning"
beginningClock = core.Clock()
text_4 = visual.TextStim(win=win, ori=0, name='text_4',
    text='You are about to begin the first block of the experiment.',    font='Arial',
    pos=[0, 0], height=0.1, wrapWidth=None,
    color='white', colorSpace='rgb', opacity=1,
    depth=0.0)

#set up a timer that we can reset at any time
myClock = core.Clock()

# .. also open the serial port so we can track the button box

if fmri_mode == 1:
    import serial # import the serial library
    ser = serial.Serial(0, 9600, timeout=0.001) # create a 'serial' object the whole script can see

string1 = expInfo['participant']
string2 = expInfo['date']
string3 = expInfo['expName']

#lets set up a custom logfile too
myLogFile = 'LogFile_%s%s%s.txt' %(string1,string2,string3)

# open the logfile so hte whole program can see it later
theFileObject = open(myLogFile,'a')

#keep track of where the last targetTrial occurred
lastTargetTrialPosition = 0



# Initialize components for Routine "CUE"
CUEClock = core.Clock()
text = visual.TextStim(win=win, ori=0, name='text',
    text='PLACE',    font='Arial',
    pos=[0, 0], height=0.2, wrapWidth=None,
    color='white', colorSpace='rgb', opacity=1,
    depth=0.0)

# Initialize components for Routine "trial"
trialClock = core.Clock()
fixationcross = visual.ImageStim(win=win, name='fixationcross',
    image='sin', mask=None,
    ori=0, pos=[0, 0], size=[0.5, 0.5],
    color=[1,1,1], colorSpace='rgb', opacity=1,
    flipHoriz=False, flipVert=False,
    texRes=128, interpolate=False, depth=0.0)
ISI = core.StaticPeriod(win=win, screenHz=expInfo['frameRate'], name='ISI')
MASK1 = visual.ImageStim(win=win, name='MASK1',
    image='sin', mask=None,
    ori=0, pos=[-0.4, 0.4], size=[0.5, 0.5],
    color=[1,1,1], colorSpace='rgb', opacity=1,
    flipHoriz=False, flipVert=False,
    texRes=128, interpolate=False, depth=-2.0)
MASK2 = visual.ImageStim(win=win, name='MASK2',
    image='sin', mask=None,
    ori=0, pos=[0.4, 0.4], size=[0.5, 0.5],
    color=[1,1,1], colorSpace='rgb', opacity=1,
    flipHoriz=False, flipVert=False,
    texRes=128, interpolate=False, depth=-3.0)
MASK3 = visual.ImageStim(win=win, name='MASK3',
    image='sin', mask=None,
    ori=0, pos=[0.4, -0.4], size=[0.5, 0.5],
    color=[1,1,1], colorSpace='rgb', opacity=1,
    flipHoriz=False, flipVert=False,
    texRes=128, interpolate=False, depth=-4.0)
MASK4 = visual.ImageStim(win=win, name='MASK4',
    image='sin', mask=None,
    ori=0, pos=[-0.4, -0.4], size=[0.5, 0.5],
    color=[1,1,1], colorSpace='rgb', opacity=1,
    flipHoriz=False, flipVert=False,
    texRes=128, interpolate=False, depth=-5.0)
POS1 = visual.ImageStim(win=win, name='POS1',
    image='sin', mask=None,
    ori=0, pos=[-0.4, 0.4], size=[0.5, 0.5],
    color=[1,1,1], colorSpace='rgb', opacity=1,
    flipHoriz=False, flipVert=False,
    texRes=128, interpolate=False, depth=-6.0)
POS2 = visual.ImageStim(win=win, name='POS2',
    image='sin', mask=None,
    ori=0, pos=[0.4, 0.4], size=[0.5, 0.5],
    color=[1,1,1], colorSpace='rgb', opacity=1,
    flipHoriz=False, flipVert=False,
    texRes=128, interpolate=False, depth=-7.0)
POS3 = visual.ImageStim(win=win, name='POS3',
    image='sin', mask=None,
    ori=0, pos=[0.4, -0.4], size=[0.5, 0.5],
    color=[1,1,1], colorSpace='rgb', opacity=1,
    flipHoriz=False, flipVert=False,
    texRes=128, interpolate=False, depth=-8.0)
POS4 = visual.ImageStim(win=win, name='POS4',
    image='sin', mask=None,
    ori=0, pos=[-0.4, -0.4], size=[0.5, 0.5],
    color=[1,1,1], colorSpace='rgb', opacity=1,
    flipHoriz=False, flipVert=False,
    texRes=128, interpolate=False, depth=-9.0)
MASK5 = visual.ImageStim(win=win, name='MASK5',
    image='sin', mask=None,
    ori=0, pos=[-0.4, 0.4], size=[0.5, 0.5],
    color=[1,1,1], colorSpace='rgb', opacity=1,
    flipHoriz=False, flipVert=False,
    texRes=128, interpolate=False, depth=-10.0)
MASK6 = visual.ImageStim(win=win, name='MASK6',
    image='sin', mask=None,
    ori=0, pos=[0.4, 0.4], size=[0.5, 0.5],
    color=[1,1,1], colorSpace='rgb', opacity=1,
    flipHoriz=False, flipVert=False,
    texRes=128, interpolate=False, depth=-11.0)
MASK7 = visual.ImageStim(win=win, name='MASK7',
    image='sin', mask=None,
    ori=0, pos=[0.4, -0.4], size=[0.5, 0.5],
    color=[1,1,1], colorSpace='rgb', opacity=1,
    flipHoriz=False, flipVert=False,
    texRes=128, interpolate=False, depth=-12.0)
MASK8 = visual.ImageStim(win=win, name='MASK8',
    image='sin', mask=None,
    ori=0, pos=[-0.4, -0.4], size=[0.5, 0.5],
    color=[1,1,1], colorSpace='rgb', opacity=1,
    flipHoriz=False, flipVert=False,
    texRes=128, interpolate=False, depth=-13.0)
image_2 = visual.ImageStim(win=win, name='image_2',
    image='questionmark.jpg', mask=None,
    ori=0, pos=[0, 0], size=[0.5, 0.5],
    color=[1,1,1], colorSpace='rgb', opacity=1,
    flipHoriz=False, flipVert=False,
    texRes=128, interpolate=True, depth=-15.0)


# Initialize components for Routine "Rest"
RestClock = core.Clock()
image_3 = visual.ImageStim(win=win, name='image_3',
    image='fixcross.jpg', mask=None,
    ori=0, pos=[0, 0], size=[0.5, 0.5],
    color=[1,1,1], colorSpace='rgb', opacity=1,
    flipHoriz=False, flipVert=False,
    texRes=128, interpolate=False, depth=0.0)

# Initialize components for Routine "Rest"
RestClock = core.Clock()
image_3 = visual.ImageStim(win=win, name='image_3',
    image='fixcross.jpg', mask=None,
    ori=0, pos=[0, 0], size=[0.5, 0.5],
    color=[1,1,1], colorSpace='rgb', opacity=1,
    flipHoriz=False, flipVert=False,
    texRes=128, interpolate=False, depth=0.0)

# Create some handy timers
globalClock = core.Clock()  # to track the time since experiment started
routineTimer = core.CountdownTimer()  # to track time remaining of each (non-slip) routine 

#------Prepare to start Routine "getMRIMode"-------
t = 0
getMRIModeClock.reset()  # clock 
frameN = -1
# update component parameters for each repeat

# keep track of which components have finished
getMRIModeComponents = []
for thisComponent in getMRIModeComponents:
    if hasattr(thisComponent, 'status'):
        thisComponent.status = NOT_STARTED

#-------Start Routine "getMRIMode"-------
continueRoutine = True
while continueRoutine:
    # get current time
    t = getMRIModeClock.getTime()
    frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
    # update/draw components on each frame
    
    
    # check if all components have finished
    if not continueRoutine:  # a component has requested a forced-end of Routine
        routineTimer.reset()  # if we abort early the non-slip timer needs reset
        break
    continueRoutine = False  # will revert to True if at least one component still running
    for thisComponent in getMRIModeComponents:
        if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
            continueRoutine = True
            break  # at least one component has not yet finished
    
    # check for quit (the Esc key)
    if endExpNow or event.getKeys(keyList=["escape"]):
        core.quit()
    
    # refresh the screen
    if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
        win.flip()
    else:  # this Routine was not non-slip safe so reset non-slip timer
        routineTimer.reset()

#-------Ending Routine "getMRIMode"-------
for thisComponent in getMRIModeComponents:
    if hasattr(thisComponent, "setAutoDraw"):
        thisComponent.setAutoDraw(False)


#------Prepare to start Routine "instr"-------
t = 0
instrClock.reset()  # clock 
frameN = -1
# update component parameters for each repeat
key_resp_3 = event.BuilderKeyResponse()  # create an object of type KeyResponse
key_resp_3.status = NOT_STARTED
# keep track of which components have finished
instrComponents = []
instrComponents.append(key_resp_3)
instrComponents.append(text_2)
for thisComponent in instrComponents:
    if hasattr(thisComponent, 'status'):
        thisComponent.status = NOT_STARTED

#-------Start Routine "instr"-------
continueRoutine = True
while continueRoutine:
    # get current time
    t = instrClock.getTime()
    frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
    # update/draw components on each frame
    
    # *key_resp_3* updates
    if t >= 1 and key_resp_3.status == NOT_STARTED:
        # keep track of start time/frame for later
        key_resp_3.tStart = t  # underestimates by a little under one frame
        key_resp_3.frameNStart = frameN  # exact frame index
        key_resp_3.status = STARTED
        # keyboard checking is just starting
        key_resp_3.clock.reset()  # now t=0
        event.clearEvents(eventType='keyboard')
    if key_resp_3.status == STARTED:
        theseKeys = event.getKeys(keyList=['space'])
        
        # check for quit:
        if "escape" in theseKeys:
            endExpNow = True
        if len(theseKeys) > 0:  # at least one key was pressed
            key_resp_3.keys = theseKeys[-1]  # just the last key pressed
            key_resp_3.rt = key_resp_3.clock.getTime()
            # a response ends the routine
            continueRoutine = False
    
    # *text_2* updates
    if t >= 0.0 and text_2.status == NOT_STARTED:
        # keep track of start time/frame for later
        text_2.tStart = t  # underestimates by a little under one frame
        text_2.frameNStart = frameN  # exact frame index
        text_2.setAutoDraw(True)
    
    # check if all components have finished
    if not continueRoutine:  # a component has requested a forced-end of Routine
        routineTimer.reset()  # if we abort early the non-slip timer needs reset
        break
    continueRoutine = False  # will revert to True if at least one component still running
    for thisComponent in instrComponents:
        if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
            continueRoutine = True
            break  # at least one component has not yet finished
    
    # check for quit (the Esc key)
    if endExpNow or event.getKeys(keyList=["escape"]):
        core.quit()
    
    # refresh the screen
    if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
        win.flip()
    else:  # this Routine was not non-slip safe so reset non-slip timer
        routineTimer.reset()

#-------Ending Routine "instr"-------
for thisComponent in instrComponents:
    if hasattr(thisComponent, "setAutoDraw"):
        thisComponent.setAutoDraw(False)
# check responses
if key_resp_3.keys in ['', [], None]:  # No response was made
   key_resp_3.keys=None
# store data for thisExp (ExperimentHandler)
thisExp.addData('key_resp_3.keys',key_resp_3.keys)
if key_resp_3.keys != None:  # we had a response
    thisExp.addData('key_resp_3.rt', key_resp_3.rt)
thisExp.nextEntry()

#------Prepare to start Routine "beginning"-------
t = 0
beginningClock.reset()  # clock 
frameN = -1
# update component parameters for each repeat
key_resp_10 = event.BuilderKeyResponse()  # create an object of type KeyResponse
key_resp_10.status = NOT_STARTED
#set up a clock the whole program can see
myClock.reset()
myStartTime= myClock.getTime()
# keep track of which components have finished
beginningComponents = []
beginningComponents.append(text_4)
beginningComponents.append(key_resp_10)
for thisComponent in beginningComponents:
    if hasattr(thisComponent, 'status'):
        thisComponent.status = NOT_STARTED

#-------Start Routine "beginning"-------
continueRoutine = True
while continueRoutine:
    # get current time
    t = beginningClock.getTime()
    frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
    # update/draw components on each frame
    
    # *text_4* updates
    if t >= 0.0 and text_4.status == NOT_STARTED:
        # keep track of start time/frame for later
        text_4.tStart = t  # underestimates by a little under one frame
        text_4.frameNStart = frameN  # exact frame index
        text_4.setAutoDraw(True)
    
    # *key_resp_10* updates
    if t >= 2 and key_resp_10.status == NOT_STARTED:
        # keep track of start time/frame for later
        key_resp_10.tStart = t  # underestimates by a little under one frame
        key_resp_10.frameNStart = frameN  # exact frame index
        key_resp_10.status = STARTED
        # keyboard checking is just starting
        key_resp_10.clock.reset()  # now t=0
        event.clearEvents(eventType='keyboard')
    if key_resp_10.status == STARTED:
        theseKeys = event.getKeys(keyList=['5'])
        
        # check for quit:
        if "escape" in theseKeys:
            endExpNow = True
        if len(theseKeys) > 0:  # at least one key was pressed
            key_resp_10.keys = theseKeys[-1]  # just the last key pressed
            key_resp_10.rt = key_resp_10.clock.getTime()
            # a response ends the routine
            continueRoutine = False
    
    
    # check if all components have finished
    if not continueRoutine:  # a component has requested a forced-end of Routine
        routineTimer.reset()  # if we abort early the non-slip timer needs reset
        break
    continueRoutine = False  # will revert to True if at least one component still running
    for thisComponent in beginningComponents:
        if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
            continueRoutine = True
            break  # at least one component has not yet finished
    
    # check for quit (the Esc key)
    if endExpNow or event.getKeys(keyList=["escape"]):
        core.quit()
    
    # refresh the screen
    if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
        win.flip()
    else:  # this Routine was not non-slip safe so reset non-slip timer
        routineTimer.reset()

#-------Ending Routine "beginning"-------
for thisComponent in beginningComponents:
    if hasattr(thisComponent, "setAutoDraw"):
        thisComponent.setAutoDraw(False)
# check responses
if key_resp_10.keys in ['', [], None]:  # No response was made
   key_resp_10.keys=None
# store data for thisExp (ExperimentHandler)
thisExp.addData('key_resp_10.keys',key_resp_10.keys)
if key_resp_10.keys != None:  # we had a response
    thisExp.addData('key_resp_10.rt', key_resp_10.rt)
thisExp.nextEntry()


# set up handler to look after randomisation of conditions etc
trials = data.TrialHandler(nReps=1, method='random', 
    extraInfo=expInfo, originPath=None,
    trialList=data.importConditions('block_order_places.xlsx'),
    seed=None, name='trials')
thisExp.addLoop(trials)  # add the loop to the experiment
thisTrial = trials.trialList[0]  # so we can initialise stimuli with some values
# abbreviate parameter names if possible (e.g. rgb=thisTrial.rgb)
if thisTrial != None:
    for paramName in thisTrial.keys():
        exec(paramName + '= thisTrial.' + paramName)


###
# core code to make sure the ordering is controlled acorss and within blocks

#this has been generated for us by the trial handler - it controls the order the
# stim files are loaded in ..
stimFileOrder = trials.sequenceIndices.squeeze() #comes out as 2d array so convert to vector
print 'stimFileOrder was ', stimFileOrder
#lets load each stimfile and generate a stimulus order per block

ordersThatWorkByFileName = []

for i in range(len(stimFileOrder)):
    thisFileIndex = stimFileOrder[i]
    ## FOR TESTING# thisFileIndex = 2 ## gte the correct files
    #lets use a nasty trick to get the stimulus order and position order from the filename
    tmpPLACES = data.TrialHandler(nReps=1, method='random', extraInfo=expInfo, originPath=None, trialList=data.importConditions(u'places%s.xlsx' %str(thisFileIndex+1)), seed=None, name='PLACES')
    
    posSequence = []
    orderNotSolved = True #we haven't got a good order yet
    for j in range(len(tmpPLACES.trialList)):
        posSequence.append(tmpPLACES.trialList[j]['Position'])

    posSequence = array(posSequence,'i')

    while orderNotSolved == True:
        #generate a random shuffle of the trials 1:12
        t = linspace(0,11,12) 
        random.shuffle(t)
        t = array(t,'i') # important - is this order good or not?

        #lets check
        newOrderPositions = posSequence[t]
        newOrderPositions = newOrderPositions[newOrderPositions!=0] #drop the zeros
        newOrderPositions = append(newOrderPositions,0) # but add a zero
        
        #generate a list to compare to
        compareOrder = append(lastTargetTrialPosition,newOrderPositions[:-1])
        
        #print newOrderPositions
        #print compareOrder
        
        compareDone = compareOrder - newOrderPositions
        
        time.sleep(0.1)
        
        #do the comparison
        if 0 in compareDone:
            orderNotSolved = True
            ##print 'loaded places%s' %str(thisFileIndex+1)
            ##print 'order that fails is: ' , t
        else:
            orderThatWorks = t #numbers 0-11 shuffled
            #remember to grab the last target trial from this list so we can compare the next list
            lastTargetTrialPosition = newOrderPositions[newOrderPositions!=0][-1]
            orderNotSolved = False
            
            print 'loaded places%s' %str(thisFileIndex+1)
            print 'order that works is: ' , t
            print compareOrder
            print newOrderPositions
             
            #now save the order to a list we will access in our loop
            ordersThatWorkByFileName.append(t)
            
        if endExpNow or event.getKeys(keyList=["escape"]):
            core.quit()

###




for thisTrial in trials:
    currentLoop = trials
    # abbreviate parameter names if possible (e.g. rgb = thisTrial.rgb)
    if thisTrial != None:
        for paramName in thisTrial.keys():
            exec(paramName + '= thisTrial.' + paramName)
    
    #------Prepare to start Routine "CUE"-------
    t = 0
    CUEClock.reset()  # clock 
    frameN = -1
    routineTimer.add(2.000000)
    # update component parameters for each repeat
    # keep track of which components have finished
    CUEComponents = []
    CUEComponents.append(text)
    for thisComponent in CUEComponents:
        if hasattr(thisComponent, 'status'):
            thisComponent.status = NOT_STARTED
    
    #-------Start Routine "CUE"-------
    continueRoutine = True
    while continueRoutine and routineTimer.getTime() > 0:
        # get current time
        t = CUEClock.getTime()
        frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
        # update/draw components on each frame
        
        # *text* updates
        if t >= 0.0 and text.status == NOT_STARTED:
            # keep track of start time/frame for later
            text.tStart = t  # underestimates by a little under one frame
            text.frameNStart = frameN  # exact frame index
            text.setAutoDraw(True)
        elif text.status == STARTED and t >= (0.0 + (2-win.monitorFramePeriod*0.75)): #most of one frame period left
            text.setAutoDraw(False)
        
        # check if all components have finished
        if not continueRoutine:  # a component has requested a forced-end of Routine
            routineTimer.reset()  # if we abort early the non-slip timer needs reset
            break
        continueRoutine = False  # will revert to True if at least one component still running
        for thisComponent in CUEComponents:
            if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
                continueRoutine = True
                break  # at least one component has not yet finished
        
        # check for quit (the Esc key)
        if endExpNow or event.getKeys(keyList=["escape"]):
            core.quit()
        
        # refresh the screen
        if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
            win.flip()
    
    #-------Ending Routine "CUE"-------
    for thisComponent in CUEComponents:
        if hasattr(thisComponent, "setAutoDraw"):
            thisComponent.setAutoDraw(False)
    
    # set up handler to look after randomisation of conditions etc
    #### TODO - this is where we need to actually reset the order and override psychopy
    ## theFileToActuallyLoad = stimFileOrder[thisTrial] 
    PLACES = data.TrialHandler(nReps=1, method='random', 
        extraInfo=expInfo, originPath=None,
        trialList=data.importConditions(u'places1.xlsx'),
        seed=None, name='PLACES')
    #### PLACES.trialList.sequence = blah
    ####
    thisExp.addLoop(PLACES)  # add the loop to the experiment
    thisPLACES = PLACES.trialList[0]  # so we can initialise stimuli with some values
    # abbreviate parameter names if possible (e.g. rgb=thisPLACES.rgb)
    if thisPLACES != None:
        for paramName in thisPLACES.keys():
            exec(paramName + '= thisPLACES.' + paramName)
    
    for thisPLACES in PLACES:
        currentLoop = PLACES
        # abbreviate parameter names if possible (e.g. rgb = thisPLACES.rgb)
        if thisPLACES != None:
            for paramName in thisPLACES.keys():
                exec(paramName + '= thisPLACES.' + paramName)
        
        #------Prepare to start Routine "trial"-------
        t = 0
        trialClock.reset()  # clock 
        frameN = -1
        routineTimer.add(2.000000)
        # update component parameters for each repeat
        fixationcross.setImage('fixcross.jpg')
        key_resp_2 = event.BuilderKeyResponse()  # create an object of type KeyResponse
        key_resp_2.status = NOT_STARTED
        print 'Started waiting for response at:'
        started_waiting_time = myClock.getTime()
        print started_waiting_time - myStartTime
        
        # set the first response to none so we can see if its changed
        first_resp = None
        # keep track of which components have finished
        trialComponents = []
        trialComponents.append(fixationcross)
        trialComponents.append(ISI)
        trialComponents.append(MASK1)
        trialComponents.append(MASK2)
        trialComponents.append(MASK3)
        trialComponents.append(MASK4)
        trialComponents.append(POS1)
        trialComponents.append(POS2)
        trialComponents.append(POS3)
        trialComponents.append(POS4)
        trialComponents.append(MASK5)
        trialComponents.append(MASK6)
        trialComponents.append(MASK7)
        trialComponents.append(MASK8)
        trialComponents.append(key_resp_2)
        trialComponents.append(image_2)
        for thisComponent in trialComponents:
            if hasattr(thisComponent, 'status'):
                thisComponent.status = NOT_STARTED
        
        #-------Start Routine "trial"-------
        continueRoutine = True
        while continueRoutine and routineTimer.getTime() > 0:
            # get current time
            t = trialClock.getTime()
            frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
            # update/draw components on each frame
            
            # *fixationcross* updates
            if t >= 0.0 and fixationcross.status == NOT_STARTED:
                # keep track of start time/frame for later
                fixationcross.tStart = t  # underestimates by a little under one frame
                fixationcross.frameNStart = frameN  # exact frame index
                fixationcross.setAutoDraw(True)
            elif fixationcross.status == STARTED and t >= (0.0 + (0.4-win.monitorFramePeriod*0.75)): #most of one frame period left
                fixationcross.setAutoDraw(False)
            
            # *MASK1* updates
            if t >= 0.4 and MASK1.status == NOT_STARTED:
                # keep track of start time/frame for later
                MASK1.tStart = t  # underestimates by a little under one frame
                MASK1.frameNStart = frameN  # exact frame index
                MASK1.setAutoDraw(True)
            elif MASK1.status == STARTED and t >= (0.4 + (0.1-win.monitorFramePeriod*0.75)): #most of one frame period left
                MASK1.setAutoDraw(False)
            
            # *MASK2* updates
            if t >= 0.4 and MASK2.status == NOT_STARTED:
                # keep track of start time/frame for later
                MASK2.tStart = t  # underestimates by a little under one frame
                MASK2.frameNStart = frameN  # exact frame index
                MASK2.setAutoDraw(True)
            elif MASK2.status == STARTED and t >= (0.4 + (0.1-win.monitorFramePeriod*0.75)): #most of one frame period left
                MASK2.setAutoDraw(False)
            
            # *MASK3* updates
            if t >= 0.4 and MASK3.status == NOT_STARTED:
                # keep track of start time/frame for later
                MASK3.tStart = t  # underestimates by a little under one frame
                MASK3.frameNStart = frameN  # exact frame index
                MASK3.setAutoDraw(True)
            elif MASK3.status == STARTED and t >= (0.4 + (0.1-win.monitorFramePeriod*0.75)): #most of one frame period left
                MASK3.setAutoDraw(False)
            
            # *MASK4* updates
            if t >= 0.4 and MASK4.status == NOT_STARTED:
                # keep track of start time/frame for later
                MASK4.tStart = t  # underestimates by a little under one frame
                MASK4.frameNStart = frameN  # exact frame index
                MASK4.setAutoDraw(True)
            elif MASK4.status == STARTED and t >= (0.4 + (0.1-win.monitorFramePeriod*0.75)): #most of one frame period left
                MASK4.setAutoDraw(False)
            
            # *POS1* updates
            if t >= 0.5 and POS1.status == NOT_STARTED:
                # keep track of start time/frame for later
                POS1.tStart = t  # underestimates by a little under one frame
                POS1.frameNStart = frameN  # exact frame index
                POS1.setAutoDraw(True)
            elif POS1.status == STARTED and t >= (0.5 + (0.1-win.monitorFramePeriod*0.75)): #most of one frame period left
                POS1.setAutoDraw(False)
            
            # *POS2* updates
            if t >= 0.5 and POS2.status == NOT_STARTED:
                # keep track of start time/frame for later
                POS2.tStart = t  # underestimates by a little under one frame
                POS2.frameNStart = frameN  # exact frame index
                POS2.setAutoDraw(True)
            elif POS2.status == STARTED and t >= (0.5 + (0.1-win.monitorFramePeriod*0.75)): #most of one frame period left
                POS2.setAutoDraw(False)
            
            # *POS3* updates
            if t >= 0.5 and POS3.status == NOT_STARTED:
                # keep track of start time/frame for later
                POS3.tStart = t  # underestimates by a little under one frame
                POS3.frameNStart = frameN  # exact frame index
                POS3.setAutoDraw(True)
            elif POS3.status == STARTED and t >= (0.5 + (0.1-win.monitorFramePeriod*0.75)): #most of one frame period left
                POS3.setAutoDraw(False)
            
            # *POS4* updates
            if t >= 0.5 and POS4.status == NOT_STARTED:
                # keep track of start time/frame for later
                POS4.tStart = t  # underestimates by a little under one frame
                POS4.frameNStart = frameN  # exact frame index
                POS4.setAutoDraw(True)
            elif POS4.status == STARTED and t >= (0.5 + (0.1-win.monitorFramePeriod*0.75)): #most of one frame period left
                POS4.setAutoDraw(False)
            
            # *MASK5* updates
            if t >= 0.6 and MASK5.status == NOT_STARTED:
                # keep track of start time/frame for later
                MASK5.tStart = t  # underestimates by a little under one frame
                MASK5.frameNStart = frameN  # exact frame index
                MASK5.setAutoDraw(True)
            elif MASK5.status == STARTED and t >= (0.6 + (0.1-win.monitorFramePeriod*0.75)): #most of one frame period left
                MASK5.setAutoDraw(False)
            
            # *MASK6* updates
            if t >= 0.6 and MASK6.status == NOT_STARTED:
                # keep track of start time/frame for later
                MASK6.tStart = t  # underestimates by a little under one frame
                MASK6.frameNStart = frameN  # exact frame index
                MASK6.setAutoDraw(True)
            elif MASK6.status == STARTED and t >= (0.6 + (0.1-win.monitorFramePeriod*0.75)): #most of one frame period left
                MASK6.setAutoDraw(False)
            
            # *MASK7* updates
            if t >= 0.6 and MASK7.status == NOT_STARTED:
                # keep track of start time/frame for later
                MASK7.tStart = t  # underestimates by a little under one frame
                MASK7.frameNStart = frameN  # exact frame index
                MASK7.setAutoDraw(True)
            elif MASK7.status == STARTED and t >= (0.6 + (0.1-win.monitorFramePeriod*0.75)): #most of one frame period left
                MASK7.setAutoDraw(False)
            
            # *MASK8* updates
            if t >= 0.6 and MASK8.status == NOT_STARTED:
                # keep track of start time/frame for later
                MASK8.tStart = t  # underestimates by a little under one frame
                MASK8.frameNStart = frameN  # exact frame index
                MASK8.setAutoDraw(True)
            elif MASK8.status == STARTED and t >= (0.6 + (0.1-win.monitorFramePeriod*0.75)): #most of one frame period left
                MASK8.setAutoDraw(False)
            
            # *key_resp_2* updates
            if t >= 0.7 and key_resp_2.status == NOT_STARTED:
                # keep track of start time/frame for later
                key_resp_2.tStart = t  # underestimates by a little under one frame
                key_resp_2.frameNStart = frameN  # exact frame index
                key_resp_2.status = STARTED
                # keyboard checking is just starting
                key_resp_2.clock.reset()  # now t=0
            elif key_resp_2.status == STARTED and t >= (2.00-win.monitorFramePeriod*0.75): #most of one frame period left
                key_resp_2.status = STOPPED
            if key_resp_2.status == STARTED:
                theseKeys = event.getKeys(keyList=['p', 'l', 'e', 'd', 'space'])
                
                # check for quit:
                if "escape" in theseKeys:
                    endExpNow = True
                if len(theseKeys) > 0:  # at least one key was pressed
                    key_resp_2.keys = theseKeys[-1]  # just the last key pressed
                    key_resp_2.rt = key_resp_2.clock.getTime()
                    # was this 'correct'?
                    if (key_resp_2.keys == str(corrAns)) or (key_resp_2.keys == corrAns):
                        key_resp_2.corr = 1
                    else:
                        key_resp_2.corr = 0
            
            # *image_2* updates
            if t >= 0.7 and image_2.status == NOT_STARTED:
                # keep track of start time/frame for later
                image_2.tStart = t  # underestimates by a little under one frame
                image_2.frameNStart = frameN  # exact frame index
                image_2.setAutoDraw(True)
            elif image_2.status == STARTED and t >= (2-win.monitorFramePeriod*0.75): #most of one frame period left
                image_2.setAutoDraw(False)
            if fmri_mode == 1:
                respData = ser.readline()   # try to read data from serial
            else:
                #for testing
                respData = '1'
            
            if first_resp == None:
                #check we actually got something
                if len(respData) > 0: #we did get something
                        first_resp = int(respData) # change the byte string from the serial device into a number
                        #write the result to the logfile
                        theFileObject.write('response was %s, at time: %s\n' %(first_resp, myClock.getTime()))
                        print first_resp # also print the response to the screen.
                else:
                    pass
            # *ISI* period
            if t >= 0.0 and ISI.status == NOT_STARTED:
                # keep track of start time/frame for later
                ISI.tStart = t  # underestimates by a little under one frame
                ISI.frameNStart = frameN  # exact frame index
                ISI.start(0.4)
            elif ISI.status == STARTED: #one frame should pass before updating params and completing
                # updating other components during *ISI*
                MASK1.setImage(mask1)
                MASK2.setImage(mask2)
                MASK3.setImage(mask3)
                MASK4.setImage(mask4)
                POS1.setImage(position1)
                POS2.setImage(position2)
                POS3.setImage(position3)
                POS4.setImage(position4)
                MASK5.setImage(mask5)
                MASK6.setImage(mask6)
                MASK7.setImage(mask7)
                MASK8.setImage(mask8)
                # component updates done
                ISI.complete() #finish the static period
            
            # check if all components have finished
            if not continueRoutine:  # a component has requested a forced-end of Routine
                routineTimer.reset()  # if we abort early the non-slip timer needs reset
                break
            continueRoutine = False  # will revert to True if at least one component still running
            for thisComponent in trialComponents:
                if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
                    continueRoutine = True
                    break  # at least one component has not yet finished
            
            # check for quit (the Esc key)
            if endExpNow or event.getKeys(keyList=["escape"]):
                core.quit()
            
            # refresh the screen
            if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
                win.flip()
        
        #-------Ending Routine "trial"-------
        for thisComponent in trialComponents:
            if hasattr(thisComponent, "setAutoDraw"):
                thisComponent.setAutoDraw(False)
        # check responses
        if key_resp_2.keys in ['', [], None]:  # No response was made
           key_resp_2.keys=None
           # was no response the correct answer?!
           if str(corrAns).lower() == 'none': key_resp_2.corr = 1  # correct non-response
           else: key_resp_2.corr = 0  # failed to respond (incorrectly)
        # store data for PLACES (TrialHandler)
        PLACES.addData('key_resp_2.keys',key_resp_2.keys)
        PLACES.addData('key_resp_2.corr', key_resp_2.corr)
        if key_resp_2.keys != None:  # we had a response
            PLACES.addData('key_resp_2.rt', key_resp_2.rt)
        if first_resp == None:
                    #write the result to the logfile - no response
                    theFileObject.write('NO RESPONSE to trial at time: %s\n' %(myClock.getTime()))
                    print first_resp # also print the response to the screen.
        thisExp.nextEntry()
        
    # completed 1 repeats of 'PLACES'
    
    
    #------Prepare to start Routine "Rest"-------
    t = 0
    RestClock.reset()  # clock 
    frameN = -1
    routineTimer.add(12.000000)
    # update component parameters for each repeat
    # keep track of which components have finished
    RestComponents = []
    RestComponents.append(image_3)
    for thisComponent in RestComponents:
        if hasattr(thisComponent, 'status'):
            thisComponent.status = NOT_STARTED
    
    #-------Start Routine "Rest"-------
    continueRoutine = True
    while continueRoutine and routineTimer.getTime() > 0:
        # get current time
        t = RestClock.getTime()
        frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
        # update/draw components on each frame
        
        # *image_3* updates
        if t >= 0.0 and image_3.status == NOT_STARTED:
            # keep track of start time/frame for later
            image_3.tStart = t  # underestimates by a little under one frame
            image_3.frameNStart = frameN  # exact frame index
            image_3.setAutoDraw(True)
        elif image_3.status == STARTED and t >= (0.0 + (12-win.monitorFramePeriod*0.75)): #most of one frame period left
            image_3.setAutoDraw(False)
        
        # check if all components have finished
        if not continueRoutine:  # a component has requested a forced-end of Routine
            routineTimer.reset()  # if we abort early the non-slip timer needs reset
            break
        continueRoutine = False  # will revert to True if at least one component still running
        for thisComponent in RestComponents:
            if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
                continueRoutine = True
                break  # at least one component has not yet finished
        
        # check for quit (the Esc key)
        if endExpNow or event.getKeys(keyList=["escape"]):
            core.quit()
        
        # refresh the screen
        if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
            win.flip()
    
    #-------Ending Routine "Rest"-------
    for thisComponent in RestComponents:
        if hasattr(thisComponent, "setAutoDraw"):
            thisComponent.setAutoDraw(False)
# completed 1 repeats of 'trials'


#------Prepare to start Routine "Rest"-------
t = 0
RestClock.reset()  # clock 
frameN = -1
routineTimer.add(12.000000)
# update component parameters for each repeat
# keep track of which components have finished
RestComponents = []
RestComponents.append(image_3)
for thisComponent in RestComponents:
    if hasattr(thisComponent, 'status'):
        thisComponent.status = NOT_STARTED

#-------Start Routine "Rest"-------
continueRoutine = True
while continueRoutine and routineTimer.getTime() > 0:
    # get current time
    t = RestClock.getTime()
    frameN = frameN + 1  # number of completed frames (so 0 is the first frame)
    # update/draw components on each frame
    
    # *image_3* updates
    if t >= 0.0 and image_3.status == NOT_STARTED:
        # keep track of start time/frame for later
        image_3.tStart = t  # underestimates by a little under one frame
        image_3.frameNStart = frameN  # exact frame index
        image_3.setAutoDraw(True)
    elif image_3.status == STARTED and t >= (0.0 + (12-win.monitorFramePeriod*0.75)): #most of one frame period left
        image_3.setAutoDraw(False)
    
    # check if all components have finished
    if not continueRoutine:  # a component has requested a forced-end of Routine
        routineTimer.reset()  # if we abort early the non-slip timer needs reset
        break
    continueRoutine = False  # will revert to True if at least one component still running
    for thisComponent in RestComponents:
        if hasattr(thisComponent, "status") and thisComponent.status != FINISHED:
            continueRoutine = True
            break  # at least one component has not yet finished
    
    # check for quit (the Esc key)
    if endExpNow or event.getKeys(keyList=["escape"]):
        core.quit()
    
    # refresh the screen
    if continueRoutine:  # don't flip if this routine is over or we'll get a blank screen
        win.flip()

#-------Ending Routine "Rest"-------
for thisComponent in RestComponents:
    if hasattr(thisComponent, "setAutoDraw"):
        thisComponent.setAutoDraw(False)



win.close()
core.quit()
