#!/usr/bin/python

import wx
import os, sys


if len(sys.argv) == 4:
    WindowTitle = sys.argv[2]
    WindowPrompt = sys.argv[3]

my_command = sys.argv[0]
if sys.argv[1] == '1':
    my_window_title = "Select functional data to open ... "
    my_filetypes = "NIFTI files (*.nii.gz)|*.nii.gz"
elif sys.argv[1] == '2':
    my_window_title = "Select a cortical surface to open ..."
    my_filetypes = "OFF BINARY files (*.off)|*.off"
elif sys.argv[1] == '3':
    my_window_title = "Select a dti fiber set (.out files) to open ..."
    my_filetypes = "OUT fiber files (*.out)|*.out"
elif sys.argv[1] == '4':
    my_window_title = "Save file as ..."
    my_filetypes = "TIF format (*.tif)|*.tif"
elif sys.argv[1] == '5':
    my_window_title = "Load the 4D dipole file ..."
    my_filetypes = "*.*"
elif sys.argv[1] == '6':
    my_window_title = "Load the session transformation matrix ..."
    my_filetypes = "*.*"
elif sys.argv[1] == '7':
    my_window_title = "Original DTI dataset ..."
    my_filetypes = "NIFTI files (*.nii.gz)|*.nii.gz"
elif sys.argv[1] == '8':
    my_window_title = "Transform matrix of DTI to structural MRI ..."
    my_filetypes = "*.*"
elif sys.argv[1] == '9':
    my_window_title = "Please select a structural mri to load (Nifti_gz) ..."
    my_filetypes = "NIFTI files (*.nii.gz)|*.nii.gz"
elif sys.argv[1] == '10':
    my_window_title = "If you have a transform for this data to MNI space load it here ..."
    my_filetypes = ".mat files (*.mat)|*.mat"

#headshape file
elif sys.argv[1] == '45':
    my_window_title = "load the headshape file ..."
    my_filetypes = "hs_file.txt files (hs_file.txt)|hs_file.txt"
elif sys.argv[1] == '46':
    my_window_title = "load the MEG data session transformation matrix ..."
    my_filetypes = "._transform.txt files (*_transform.txt)|*_transform.txt"


#coil positions
elif sys.argv[1] == '47':
    my_window_title = "load the .m4d file which holds the coils positions ..."
    my_filetypes = ".m4d files (*.m4d)|*.m4d"
elif sys.argv[1] == '48':
    my_window_title = "load the MEG data session transformation matrix ..."
    my_filetypes = "._transform.txt files (*_transform.txt)|*_transform.txt"
    

#Min norm stuff
elif sys.argv[1] == '49':
    my_window_title = "load the .vtk surface shape file ..."
    my_filetypes = ".vtk files (*.vtk)|*.vtk"
elif sys.argv[1] == '50':
    my_window_title = "Load the binary data file ..."
    my_filetypes = ".bin files (*.bin)|*.bin"

elif sys.argv[1] == '11':
    my_window_title = "SELECT AN MNI CO-ORDINATE TO FIND .."
    my_user_prompt = "Enter the MNI co-ordinate in mm you would like to find in this brain. This must be 3 numbers separated by commas (e.g.   23,122,-123   )"
    my_filetypes = "*.*"
elif sys.argv[1] == '12':
    my_window_title = "The upper boundary of the POSITIVE values in your data is %s" %sys.argv[2]
    my_user_prompt = "You can set the lower bound or leave it at zero .. \n   e.g. setting 2.3 here would show all data between 2.3 and your upper bound (%s)" %sys.argv[2]
    my_filetypes = "*.*"
elif sys.argv[1] == '13':
    my_window_title = "The upper boundary of the NEGATIVE values in your data is %s" %sys.argv[2]
    my_user_prompt = "You can set the lower bound or leave it at zero .. \n   e.g. setting -2.3 here would show all data between -2.3 and your upper bound (%s)" %sys.argv[2]
    my_filetypes = "*.*"


elif sys.argv[1] == '14':
    my_window_title = "manual Z correction in mm ..."
    my_user_prompt = "If you want to manually edit the coregistration type a value in mm ..."
    my_filetypes = "*.*" 
elif sys.argv[1] == '15':
    my_window_title = "manual Y correction in mm ..."
    my_user_prompt = "If you want to manually edit the coregistration type a value in mm ..."
    my_filetypes = "*.*" 
elif sys.argv[1] == '16':
    my_window_title = "manual X correction in mm ..."
    my_user_prompt = "If you want to manually edit the coregistration type a value in mm ..."
    my_filetypes = "*.*" 
elif sys.argv[1] == '17':
    my_window_title = "Number of bins to display..."
    my_user_prompt = "How many of these bins would you like to show? (more = slower) :  "
    my_filetypes = "*.*"    
elif sys.argv[1] == '18':
    my_window_title = "Number of bins ..."
    my_user_prompt = "How many bins would you like to divide your minima / maxima into? (more = slower) :  "
    my_filetypes = "*.*"    
elif sys.argv[1] == '19':
    my_window_title = "Merged or 3D?"
    my_user_prompt = "Would you like this data merged into the current structural volume (m) or in 3d (3)?"
    my_filetypes = "*.*"
elif sys.argv[1] == '20':
    my_window_title = "Dipole at time ....."
    my_user_prompt = "Select the time in ms you would like to see the dipole for ..."
    my_filetypes = "*.*"
    


else:

    my_window_title = "Select a file to load ..."
    my_filetypes = "*.*"
    
#    my_filetypes = "NIFTI files (*.nii.gz)|*.*.nii.gz|ANALYZE files(*.hdr)|*.hdr"   


#class StartupFrame(wx.Frame):
#    def __init__(self, parent, id, title):
#        wx.Frame.__init__(self, parent, id, title, size = (392, 290))
#
#        self.bitmap = wx.Bitmap('./DV3Dlogo.bmp')
#        wx.EVT_PAINT(self, self.OnPaint)
#
#        self.Centre()
#
#    def OnPaint(self, event):
#        dc = wx.PaintDC(self)
#        dc.DrawBitmap(self.bitmap, 5, 5)

class SelectFileFrame(wx.Frame):
    def __init__(self, parent, id, title):
        wx.Frame.__init__(self, parent, id, title)
        dlg = wx.FileDialog(self, my_window_title, os.getcwd(), "", my_filetypes, wx.OPEN)
        self.Centre()
        if dlg.ShowModal() == wx.ID_OK:
            path = dlg.GetPath()
            mypath = os.path.abspath(path)

            print mypath
            dlg.Destroy()
            sys.exit(0)
        else:
            sys.exit(1)



class SaveFrame(wx.Frame):
    def __init__(self, parent, id, title):
        wx.Frame.__init__(self, parent, id, title)
        dlg = wx.FileDialog(self, my_window_title, os.getcwd(), "", my_filetypes, wx.SAVE)
        self.Centre()
        if dlg.ShowModal() == wx.ID_OK:
            path = dlg.GetPath()
            mypath = os.path.abspath(path)

            print mypath
            dlg.Destroy()
            sys.exit(0)
        else:
            sys.exit(1)
            

class EntryFrame(wx.Frame):
    def __init__(self, parent, id, title):
        wx.Frame.__init__(self, parent, id, title)
        dlg = wx.TextEntryDialog(self, my_user_prompt, my_window_title )
        self.Centre()
        dlg.SetValue('0')
        if dlg.ShowModal() == wx.ID_OK:
            
            print(dlg.GetValue())
            dlg.Destroy()
            sys.exit(0)
        else:
            sys.exit(1)
            
class EntryFrameWithSkip(wx.Frame):
    def __init__(self, parent, id, title):
        wx.Frame.__init__(self, parent, id, title)
        dlg = wx.TextEntryDialog(self, my_user_prompt, my_window_title )
        self.Centre()
        dlg.SetValue('skip')
        if dlg.ShowModal() == wx.ID_OK:
            
            print(dlg.GetValue())
            dlg.Destroy()
            sys.exit(0)
        else:
            sys.exit(1)
            
class MyApp(wx.App):
    def OnInit(self):
        if sys.argv[1] == '4':
            myframe = SaveFrame(None, -1, "ynicDV3D_wxdialogs.py")

        #if sys.argv[1] == '25':
        #    myframe = StartupFrame(None, -1, "ynic DV3D - (c) 2006 - 2007")
        elif sys.argv[1] in ('11','14','15','16','17','18','19','20'):
            myframe = EntryFrame(None, -1, "ynicDV3D_wxdialogs.py")
        elif sys.argv[1] in ('12','13'):
            myframe = EntryFrameWithSkip(None, -1, "ynicDV3D_wxdialogs.py")
        else:
            myframe = SelectFileFrame(None, -1, "ynicDV3D_wxdialogs.py")
        

        myframe.CenterOnScreen()
        myframe.Show(True)
        return True



app = MyApp(0)
app.MainLoop()
