import wx
from wx.lib.colourchooser.pypalette import PyPalette

#############################################################
###THE MENU
#############################################################

#the wx application
class ynicDV3D_MenuApp(wx.App):
    def OnInit(self):
        wx.InitAllImageHandlers()
        self.main = Frame1(None)
        self.main.Show()
        self.SetTopWindow(self.main)
        return True

#IDs
[wxID_FRAME1, wxID_FRAME1BT_COLOUR_APPLYALL, wxID_FRAME1BT_COLOUR_APPLYSEL, 
 wxID_FRAME1BT_CORTEX_LOAD, wxID_FRAME1BT_CORTEX_ONOFF, 
 wxID_FRAME1BT_DIP_LOAD, wxID_FRAME1BT_DIP_VIS, wxID_FRAME1BT_FIBER_ALLONOFF, 
 wxID_FRAME1BT_FIBER_GRP1, wxID_FRAME1BT_FIBER_GRP2, wxID_FRAME1BT_FIBER_GRP3, 
 wxID_FRAME1BT_FIBER_GRP4, wxID_FRAME1BT_FIBER_GRP5, wxID_FRAME1BT_FIBER_GRP6, 
 wxID_FRAME1BT_FIBER_GRP7, wxID_FRAME1BT_FIBER_GRP8, wxID_FRAME1BT_FIBER_LOAD, 
 wxID_FRAME1BT_FIBER_SEEDONOFF, wxID_FRAME1BT_FIBER_TARGETONOFF, 
 wxID_FRAME1BT_FIBER_TRACKNOW, wxID_FRAME1BT_FUNC_3DCYCLE, 
 wxID_FRAME1BT_FUNC_LOAD, wxID_FRAME1BT_FUNC_SWITCH2D, 
 wxID_FRAME1BT_OTHER_HELP, wxID_FRAME1BT_OTHER_ORTHO, 
 wxID_FRAME1BT_OTHER_QUIT, wxID_FRAME1BT_OTHER_TIFMAIN, 
 wxID_FRAME1BT_OTHER_TIFORTHO, wxID_FRAME1BT_STRUCT_ANT_VIEW_SELECT, 
 wxID_FRAME1BT_STRUCT_AX, wxID_FRAME1BT_STRUCT_COR, 
 wxID_FRAME1BT_STRUCT_EDGES, wxID_FRAME1BT_STRUCT_INF_VIEW_SELECT, 
 wxID_FRAME1BT_STRUCT_L_VIEW_SELECT, wxID_FRAME1BT_STRUCT_POST_VIEW_SELECT, 
 wxID_FRAME1BT_STRUCT_RESET, wxID_FRAME1BT_STRUCT_R_VIEW_SELECT, 
 wxID_FRAME1BT_STRUCT_SAG, wxID_FRAME1BT_STRUCT_SUP_VIEW_SELECT, 
 wxID_FRAME1NOTEBOOK1, wxID_FRAME1PNL_COLOUR, wxID_FRAME1PNL_CORTEX, 
 wxID_FRAME1PNL_DIP, wxID_FRAME1PNL_FIBER, wxID_FRAME1PNL_FUNC, 
 wxID_FRAME1PNL_OTHER, wxID_FRAME1PNL_STRUCT, wxID_FRAME1SPBT_CORTEX_TRANSP, 
 wxID_FRAME1SPBT_DIP_DIPTIME, wxID_FRAME1SPBT_FUNC_THRESHOLD3D, 
 wxID_FRAME1STATICBITMAP1, wxID_FRAME1STATICBITMAP2, wxID_FRAME1STATICBITMAP3, 
 wxID_FRAME1STATICBITMAP4, wxID_FRAME1STATICBITMAP5, 
 wxID_FRAME1STBOX_COLOUR_DISPSELECTED, wxID_FRAME1ST_COLOURS_SELECTED, 
 wxID_FRAME1ST_COLOUR_PICKINSTR, wxID_FRAME1ST_CORTEX_TRANSP, 
 wxID_FRAME1ST_DIP_DIPTIME, wxID_FRAME1ST_FIBER_GRPLABEL, 
 wxID_FRAME1ST_FIBER_POS_SEED, wxID_FRAME1ST_FIBER_POS_TARGET, 
 wxID_FRAME1ST_FIBER_TRACKING, wxID_FRAME1ST_FUNC_2D, wxID_FRAME1ST_FUNC_3D, 
 wxID_FRAME1ST_FUNC_3D_CYCLE, wxID_FRAME1ST_FUNC_SWITCH2D, 
 wxID_FRAME1ST_FUNC_THRESHOLD3D, wxID_FRAME1ST_OTHER_ORTHO, 
 wxID_FRAME1ST_OTHER_SAVETOTIF, wxID_FRAME1ST_STRUCT_VIEW_FROM, wxID_COLPICK,
] = [wx.NewId() for _init_ctrls in range(73)]

#the wx frame
class Frame1(wx.Frame):
    def _init_coll_notebook1_Pages(self, parent):

        parent.AddPage(imageId=-1, page=self.pnl_STRUCT, select=True,
              text=u'Structural')
        parent.AddPage(imageId=-1, page=self.pnl_CORTEX, select=False,
              text=u'Surface')
        parent.AddPage(imageId=-1, page=self.pnl_FUNC, select=False,
              text=u'Functional')
        parent.AddPage(imageId=-1, page=self.pnl_DIP, select=False,
              text=u'Dipoles')
        parent.AddPage(imageId=-1, page=self.pnl_FIBER, select=False,
              text=u'Fiber')
        parent.AddPage(imageId=-1, page=self.pnl_COLOUR, select=False,
              text=u'Colours')
        parent.AddPage(imageId=-1, page=self.pnl_OTHER, select=False,
              text=u'Other')

    def _init_ctrls(self, prnt):

        wx.Frame.__init__(self, id=wxID_FRAME1, name='', parent=prnt,
              pos=wx.Point(631, 150), size=wx.Size(205, 606),
              style=wx.DEFAULT_FRAME_STYLE, title=u'ynicDV3D menu')
        self.SetClientSize(wx.Size(205, 584))

        self.notebook1 = wx.Notebook(id=wxID_FRAME1NOTEBOOK1, name='notebook1',
              parent=self, pos=wx.Point(0, 0), size=wx.Size(205, 584),
              style=wx.NB_LEFT)

        self.pnl_OTHER = wx.Panel(id=wxID_FRAME1PNL_OTHER, name=u'pnl_OTHER',
              parent=self.notebook1, pos=wx.Point(0, 0), size=wx.Size(165, 578),
              style=wx.TAB_TRAVERSAL)

        self.pnl_FIBER = wx.Panel(id=wxID_FRAME1PNL_FIBER, name=u'pnl_FIBER',
              parent=self.notebook1, pos=wx.Point(0, 0), size=wx.Size(165, 578),
              style=wx.TAB_TRAVERSAL)

        self.pnl_FUNC = wx.Panel(id=wxID_FRAME1PNL_FUNC, name=u'pnl_FUNC',
              parent=self.notebook1, pos=wx.Point(0, 0), size=wx.Size(165, 578),
              style=wx.TAB_TRAVERSAL)

        self.pnl_STRUCT = wx.Panel(id=wxID_FRAME1PNL_STRUCT, name=u'pnl_STRUCT',
              parent=self.notebook1, pos=wx.Point(0, 0), size=wx.Size(165, 578),
              style=wx.TAB_TRAVERSAL)

        self.bt_STRUCT_ax = wx.Button(id=wxID_FRAME1BT_STRUCT_AX,
              label=u'Axial On/Off   (A)', name=u'bt_STRUCT_ax',
              parent=self.pnl_STRUCT, pos=wx.Point(8, 176), size=wx.Size(144,
              20), style=0)
        self.bt_STRUCT_ax.SetForegroundColour(wx.Colour(0, 0, 255))
        self.bt_STRUCT_ax.Enable(True)
        self.bt_STRUCT_ax.Bind(wx.EVT_BUTTON, self.OnBt_STRUCT_axButton,
              id=wxID_FRAME1BT_STRUCT_AX)

        self.pnl_CORTEX = wx.Panel(id=wxID_FRAME1PNL_CORTEX, name=u'pnl_CORTEX',
              parent=self.notebook1, pos=wx.Point(0, 0), size=wx.Size(165, 578),
              style=wx.TAB_TRAVERSAL)

        self.pnl_COLOUR = wx.Panel(id=wxID_FRAME1PNL_COLOUR, name=u'pnl_COLOUR',
              parent=self.notebook1, pos=wx.Point(0, 0), size=wx.Size(165, 578),
              style=wx.TAB_TRAVERSAL)

        self.pnl_DIP = wx.Panel(id=wxID_FRAME1PNL_DIP, name=u'pnl_DIP',
              parent=self.notebook1, pos=wx.Point(0, 0), size=wx.Size(165, 578),
              style=wx.TAB_TRAVERSAL)

        self.bt_STRUCT_sag = wx.Button(id=wxID_FRAME1BT_STRUCT_SAG,
              label=u'Sagittal On/Off   (S)', name=u'bt_STRUCT_sag',
              parent=self.pnl_STRUCT, pos=wx.Point(8, 216), size=wx.Size(144,
              20), style=0)
        self.bt_STRUCT_sag.Bind(wx.EVT_BUTTON, self.OnBt_STRUCT_sagButton,
              id=wxID_FRAME1BT_STRUCT_SAG)

        self.staticBitmap1 = wx.StaticBitmap(bitmap=wx.Bitmap(u'wxmenu/structural.jpg',
              wx.BITMAP_TYPE_JPEG), id=wxID_FRAME1STATICBITMAP1,
              name='staticBitmap1', parent=self.pnl_STRUCT, pos=wx.Point(8, 8),
              size=wx.Size(140, 136), style=0)

        self.staticBitmap2 = wx.StaticBitmap(bitmap=wx.Bitmap(u'wxmenu/cortex.jpg',
              wx.BITMAP_TYPE_JPEG), id=wxID_FRAME1STATICBITMAP2,
              name='staticBitmap2', parent=self.pnl_CORTEX, pos=wx.Point(8, 8),
              size=wx.Size(140, 134), style=0)

        self.staticBitmap3 = wx.StaticBitmap(bitmap=wx.Bitmap(u'wxmenu/func.jpg',
              wx.BITMAP_TYPE_JPEG), id=wxID_FRAME1STATICBITMAP3,
              name='staticBitmap3', parent=self.pnl_FUNC, pos=wx.Point(8, 8),
              size=wx.Size(140, 141), style=0)

        self.staticBitmap4 = wx.StaticBitmap(bitmap=wx.Bitmap(u'wxmenu/dipole.jpg',
              wx.BITMAP_TYPE_JPEG), id=wxID_FRAME1STATICBITMAP4,
              name='staticBitmap4', parent=self.pnl_DIP, pos=wx.Point(8, 8),
              size=wx.Size(140, 141), style=0)

        self.staticBitmap5 = wx.StaticBitmap(bitmap=wx.Bitmap(u'wxmenu/fiber.jpg',
              wx.BITMAP_TYPE_JPEG), id=wxID_FRAME1STATICBITMAP5,
              name='staticBitmap5', parent=self.pnl_FIBER, pos=wx.Point(8, 8),
              size=wx.Size(140, 142), style=0)

        self.bt_CORTEX_load = wx.Button(id=wxID_FRAME1BT_CORTEX_LOAD,
              label=u'Load  (Ctrl+B)', name=u'bt_CORTEX_load',
              parent=self.pnl_CORTEX, pos=wx.Point(16, 176), size=wx.Size(136,
              20), style=0)
        self.bt_CORTEX_load.Bind(wx.EVT_BUTTON, self.OnBt_CORTEX_loadButton,
              id=wxID_FRAME1BT_CORTEX_LOAD)

        self.spbt_CORTEX_transp = wx.SpinButton(id=wxID_FRAME1SPBT_CORTEX_TRANSP,
              name=u'spbt_CORTEX_transp', parent=self.pnl_CORTEX,
              pos=wx.Point(136, 280), size=wx.Size(16, 32),
              style=wx.SP_HORIZONTAL)
        self.spbt_CORTEX_transp.Bind(wx.EVT_SPIN, self.OnSpbt_CORTEX_transpSpin,
              id=wxID_FRAME1SPBT_CORTEX_TRANSP)

        self.bt_CORTEX_OnOff = wx.Button(id=wxID_FRAME1BT_CORTEX_ONOFF,
              label=u'Visible On/Off  (v)', name=u'bt_CORTEX_OnOff',
              parent=self.pnl_CORTEX, pos=wx.Point(16, 232), size=wx.Size(136,
              20), style=0)
        self.bt_CORTEX_OnOff.Bind(wx.EVT_BUTTON, self.OnBt_CORTEX_OnOffButton,
              id=wxID_FRAME1BT_CORTEX_ONOFF)

        self.st_CORTEX_transp = wx.StaticText(id=wxID_FRAME1ST_CORTEX_TRANSP,
              label=u'  Transparency   up (b) / down (n)',
              name=u'st_CORTEX_transp', parent=self.pnl_CORTEX, pos=wx.Point(8,
              280), size=wx.Size(112, 40), style=0)

        self.bt_STRUCT_cor = wx.Button(id=wxID_FRAME1BT_STRUCT_COR,
              label=u'Coronal On/Off   (C)', name=u'bt_STRUCT_cor',
              parent=self.pnl_STRUCT, pos=wx.Point(8, 256), size=wx.Size(144,
              20), style=0)
        self.bt_STRUCT_cor.Bind(wx.EVT_BUTTON, self.OnBt_STRUCT_corButton,
              id=wxID_FRAME1BT_STRUCT_COR)

        self.bt_STRUCT_edges = wx.Button(id=wxID_FRAME1BT_STRUCT_EDGES,
              label=u'Edges On/Off   (B)', name=u'bt_STRUCT_edges',
              parent=self.pnl_STRUCT, pos=wx.Point(8, 296), size=wx.Size(144,
              20), style=0)
        self.bt_STRUCT_edges.Bind(wx.EVT_BUTTON, self.OnBt_STRUCT_edgesButton,
              id=wxID_FRAME1BT_STRUCT_EDGES)

        self.bt_STRUCT_reset = wx.Button(id=wxID_FRAME1BT_STRUCT_RESET,
              label=u'RESET  (r)', name=u'bt_STRUCT_reset',
              parent=self.pnl_STRUCT, pos=wx.Point(8, 336), size=wx.Size(136,
              20), style=0)
        self.bt_STRUCT_reset.Bind(wx.EVT_BUTTON, self.OnBt_STRUCT_resetButton,
              id=wxID_FRAME1BT_STRUCT_RESET)

        self.bt_STRUCT_L_view_select = wx.Button(id=wxID_FRAME1BT_STRUCT_L_VIEW_SELECT,
              label=u'Left', name=u'bt_STRUCT_L_view_select',
              parent=self.pnl_STRUCT, pos=wx.Point(16, 432), size=wx.Size(64,
              16), style=0)
        self.bt_STRUCT_L_view_select.Bind(wx.EVT_BUTTON,
              self.OnBt_STRUCT_L_view_selectButton,
              id=wxID_FRAME1BT_STRUCT_L_VIEW_SELECT)

        self.bt_STRUCT_R_view_select = wx.Button(id=wxID_FRAME1BT_STRUCT_R_VIEW_SELECT,
              label=u'Right', name=u'bt_STRUCT_R_view_select',
              parent=self.pnl_STRUCT, pos=wx.Point(88, 432), size=wx.Size(64,
              20), style=0)
        self.bt_STRUCT_R_view_select.Bind(wx.EVT_BUTTON,
              self.OnBt_STRUCT_R_view_selectButton,
              id=wxID_FRAME1BT_STRUCT_R_VIEW_SELECT)

        self.bt_STRUCT_Sup_view_select = wx.Button(id=wxID_FRAME1BT_STRUCT_SUP_VIEW_SELECT,
              label=u'Top', name=u'bt_STRUCT_Sup_view_select',
              parent=self.pnl_STRUCT, pos=wx.Point(16, 496), size=wx.Size(64,
              20), style=0)
        self.bt_STRUCT_Sup_view_select.Bind(wx.EVT_BUTTON,
              self.OnBt_STRUCT_Sup_view_selectButton,
              id=wxID_FRAME1BT_STRUCT_SUP_VIEW_SELECT)

        self.bt_STRUCT_Inf_view_select = wx.Button(id=wxID_FRAME1BT_STRUCT_INF_VIEW_SELECT,
              label=u'Bottom', name=u'bt_STRUCT_Inf_view_select',
              parent=self.pnl_STRUCT, pos=wx.Point(88, 496), size=wx.Size(64,
              20), style=0)
        self.bt_STRUCT_Inf_view_select.Bind(wx.EVT_BUTTON,
              self.OnBt_STRUCT_Inf_view_selectButton,
              id=wxID_FRAME1BT_STRUCT_INF_VIEW_SELECT)

        self.bt_STRUCT_Ant_view_select = wx.Button(id=wxID_FRAME1BT_STRUCT_ANT_VIEW_SELECT,
              label=u'Front', name=u'bt_STRUCT_Ant_view_select',
              parent=self.pnl_STRUCT, pos=wx.Point(16, 464), size=wx.Size(64,
              20), style=0)
        self.bt_STRUCT_Ant_view_select.Bind(wx.EVT_BUTTON,
              self.OnBt_STRUCT_Ant_view_selectButton,
              id=wxID_FRAME1BT_STRUCT_ANT_VIEW_SELECT)

        self.bt_STRUCT_Post_view_select = wx.Button(id=wxID_FRAME1BT_STRUCT_POST_VIEW_SELECT,
              label=u'Back', name=u'bt_STRUCT_Post_view_select',
              parent=self.pnl_STRUCT, pos=wx.Point(88, 464), size=wx.Size(64,
              20), style=0)
        self.bt_STRUCT_Post_view_select.Bind(wx.EVT_BUTTON,
              self.OnBt_STRUCT_Post_view_selectButton,
              id=wxID_FRAME1BT_STRUCT_POST_VIEW_SELECT)

        self.st_STRUCT_view_from = wx.StaticText(id=wxID_FRAME1ST_STRUCT_VIEW_FROM,
              label=u'View From  ..(cycle with H)', name=u'st_STRUCT_view_from',
              parent=self.pnl_STRUCT, pos=wx.Point(32, 392), size=wx.Size(96,
              32), style=0)
        self.st_STRUCT_view_from.SetExtraStyle(0)
        self.st_STRUCT_view_from.Enable(False)
        self.st_STRUCT_view_from.SetAutoLayout(True)
        self.st_STRUCT_view_from.SetForegroundColour(wx.Colour(255, 0, 0))

        self.bt_FUNC_load = wx.Button(id=wxID_FRAME1BT_FUNC_LOAD,
              label=u'Load  (F)', name=u'bt_FUNC_load', parent=self.pnl_FUNC,
              pos=wx.Point(24, 176), size=wx.Size(104, 20), style=0)
        self.bt_FUNC_load.Bind(wx.EVT_BUTTON, self.OnBt_FUNC_loadButton,
              id=wxID_FRAME1BT_FUNC_LOAD)

        self.bt_FUNC_switch2d = wx.Button(id=wxID_FRAME1BT_FUNC_SWITCH2D,
              label=u'Switch data  (M)', name=u'bt_FUNC_switch2d',
              parent=self.pnl_FUNC, pos=wx.Point(16, 304), size=wx.Size(120,
              20), style=0)
        self.bt_FUNC_switch2d.Bind(wx.EVT_BUTTON, self.OnBt_FUNC_switch2dButton,
              id=wxID_FRAME1BT_FUNC_SWITCH2D)

        self.bt_FUNC_3dcycle = wx.Button(id=wxID_FRAME1BT_FUNC_3DCYCLE,
              label=u'Cycle +/-/off  (f)', name=u'bt_FUNC_3dcycle',
              parent=self.pnl_FUNC, pos=wx.Point(16, 424), size=wx.Size(128,
              20), style=0)
        self.bt_FUNC_3dcycle.Bind(wx.EVT_BUTTON, self.OnBt_FUNC_3dcycleButton,
              id=wxID_FRAME1BT_FUNC_3DCYCLE)

        self.st_FUNC_3d_cycle = wx.StaticText(id=wxID_FRAME1ST_FUNC_3D_CYCLE,
              label=u'   Cycle +ve / -ve activation on/off  (f)  ',
              name=u'st_FUNC_3d_cycle', parent=self.pnl_FUNC, pos=wx.Point(16,
              384), size=wx.Size(136, 40), style=0)
        self.st_FUNC_3d_cycle.SetForegroundColour(wx.Colour(0, 0, 255))

        self.st_FUNC_2D = wx.StaticText(id=wxID_FRAME1ST_FUNC_2D,
              label=u'2D MODE', name=u'st_FUNC_2D', parent=self.pnl_FUNC,
              pos=wx.Point(16, 240), size=wx.Size(61, 16), style=0)
        self.st_FUNC_2D.SetForegroundColour(wx.Colour(255, 0, 0))

        self.st_FUNC_3D = wx.StaticText(id=wxID_FRAME1ST_FUNC_3D,
              label=u'3D MODE', name=u'st_FUNC_3D', parent=self.pnl_FUNC,
              pos=wx.Point(16, 360), size=wx.Size(61, 16), style=0)
        self.st_FUNC_3D.SetForegroundColour(wx.Colour(0, 0, 255))

        self.st_FUNC_threshold3d = wx.StaticText(id=wxID_FRAME1ST_FUNC_THRESHOLD3D,
              label=u'    Threshold   up(X) / down(Y)',
              name=u'st_FUNC_threshold3d', parent=self.pnl_FUNC,
              pos=wx.Point(16, 470), size=wx.Size(104, 32), style=0)
        self.st_FUNC_threshold3d.SetForegroundColour(wx.Colour(0, 0, 255))

        self.spbt_FUNC_threshold3d = wx.SpinButton(id=wxID_FRAME1SPBT_FUNC_THRESHOLD3D,
              name=u'spbt_FUNC_threshold3d', parent=self.pnl_FUNC,
              pos=wx.Point(120, 472), size=wx.Size(16, 24),
              style=wx.SP_HORIZONTAL)
        self.spbt_FUNC_threshold3d.Bind(wx.EVT_SPIN,
              self.OnSpbt_FUNC_threshold3dSpin,
              id=wxID_FRAME1SPBT_FUNC_THRESHOLD3D)

        self.st_FUNC_switch2d = wx.StaticText(id=wxID_FRAME1ST_FUNC_SWITCH2D,
              label=u'    switch between functional/structural',
              name=u'st_FUNC_switch2d', parent=self.pnl_FUNC, pos=wx.Point(16,
              264), size=wx.Size(136, 32), style=wx.TE_MULTILINE)
        self.st_FUNC_switch2d.SetForegroundColour(wx.Colour(255, 0, 0))

        self.bt_DIP_load = wx.Button(id=wxID_FRAME1BT_DIP_LOAD,
              label=u'Load  (D)', name=u'bt_DIP_load', parent=self.pnl_DIP,
              pos=wx.Point(16, 176), size=wx.Size(104, 20), style=0)
        self.bt_DIP_load.Bind(wx.EVT_BUTTON, self.OnBt_DIP_loadButton,
              id=wxID_FRAME1BT_DIP_LOAD)

        self.bt_DIP_vis = wx.Button(id=wxID_FRAME1BT_DIP_VIS,
              label=u'Visible On/Off  (d)', name=u'bt_DIP_vis',
              parent=self.pnl_DIP, pos=wx.Point(16, 232), size=wx.Size(136, 20),
              style=0)
        self.bt_DIP_vis.Bind(wx.EVT_BUTTON, self.OnBt_DIP_visButton,
              id=wxID_FRAME1BT_DIP_VIS)

        self.st_DIP_diptime = wx.StaticText(id=wxID_FRAME1ST_DIP_DIPTIME,
              label=u'Dipole at time ..    (Ctrl <-  /  ->)',
              name=u'st_DIP_diptime', parent=self.pnl_DIP, pos=wx.Point(24,
              280), size=wx.Size(112, 40), style=0)

        self.spbt_DIP_diptime = wx.SpinButton(id=wxID_FRAME1SPBT_DIP_DIPTIME,
              name=u'spbt_DIP_diptime', parent=self.pnl_DIP, pos=wx.Point(136,
              280), size=wx.Size(16, 24), style=wx.SP_HORIZONTAL)
        self.spbt_DIP_diptime.Bind(wx.EVT_SPIN, self.OnSpinButton1Spin,
              id=wxID_FRAME1SPBT_DIP_DIPTIME)

        self.bt_OTHER_ortho = wx.Button(id=wxID_FRAME1BT_OTHER_ORTHO,
              label=u'Create/update  (x)', name=u'bt_OTHER_ortho',
              parent=self.pnl_OTHER, pos=wx.Point(16, 88), size=wx.Size(136,
              20), style=0)
        self.bt_OTHER_ortho.Bind(wx.EVT_BUTTON, self.OnBt_OTHER_orthoButton,
              id=wxID_FRAME1BT_OTHER_ORTHO)

        self.st_OTHER_ortho = wx.StaticText(id=wxID_FRAME1ST_OTHER_ORTHO,
              label=u'Ortho views', name=u'st_OTHER_ortho',
              parent=self.pnl_OTHER, pos=wx.Point(16, 64), size=wx.Size(75, 16),
              style=0)

        self.st_OTHER_savetotif = wx.StaticText(id=wxID_FRAME1ST_OTHER_SAVETOTIF,
              label=u'Save to .TIF', name=u'st_OTHER_savetotif',
              parent=self.pnl_OTHER, pos=wx.Point(16, 136), size=wx.Size(73,
              16), style=0)

        self.bt_OTHER_tifmain = wx.Button(id=wxID_FRAME1BT_OTHER_TIFMAIN,
              label=u'Main window  ( J )', name=u'bt_OTHER_tifmain',
              parent=self.pnl_OTHER, pos=wx.Point(16, 160), size=wx.Size(136,
              20), style=0)
        self.bt_OTHER_tifmain.Bind(wx.EVT_BUTTON, self.OnBt_OTHER_tifmainButton,
              id=wxID_FRAME1BT_OTHER_TIFMAIN)

        self.bt_OTHER_tifortho = wx.Button(id=wxID_FRAME1BT_OTHER_TIFORTHO,
              label=u'Ortho window  ( j )', name=u'bt_OTHER_tifortho',
              parent=self.pnl_OTHER, pos=wx.Point(16, 192), size=wx.Size(136,
              20), style=0)
        self.bt_OTHER_tifortho.Bind(wx.EVT_BUTTON,
              self.OnBt_OTHER_tiforthoButton, id=wxID_FRAME1BT_OTHER_TIFORTHO)

        self.bt_OTHER_quit = wx.Button(id=wxID_FRAME1BT_OTHER_QUIT,
              label=u'QUIT', name=u'bt_OTHER_quit', parent=self.pnl_OTHER,
              pos=wx.Point(72, 504), size=wx.Size(75, 20), style=0)
        self.bt_OTHER_quit.Bind(wx.EVT_BUTTON, self.OnBt_OTHER_quitButton,
              id=wxID_FRAME1BT_OTHER_QUIT)

        self.bt_OTHER_help = wx.Button(id=wxID_FRAME1BT_OTHER_HELP,
              label=u'Open HELP  (h)', name=u'bt_OTHER_help',
              parent=self.pnl_OTHER, pos=wx.Point(16, 16), size=wx.Size(131,
              20), style=0)
        self.bt_OTHER_help.Bind(wx.EVT_BUTTON, self.OnBt_OTHER_helpButton,
              id=wxID_FRAME1BT_OTHER_HELP)

        self.bt_FIBER_load = wx.Button(id=wxID_FRAME1BT_FIBER_LOAD,
              label=u'Load  (Ctrl + D)', name=u'bt_FIBER_load',
              parent=self.pnl_FIBER, pos=wx.Point(24, 168), size=wx.Size(120,
              20), style=0)
        self.bt_FIBER_load.Bind(wx.EVT_BUTTON, self.OnBt_FIBER_loadButton,
              id=wxID_FRAME1BT_FIBER_LOAD)

        self.bt_FIBER_allonoff = wx.Button(id=wxID_FRAME1BT_FIBER_ALLONOFF,
              label=u'All on/off  (G)', name=u'bt_FIBER_allonoff',
              parent=self.pnl_FIBER, pos=wx.Point(24, 200), size=wx.Size(120,
              20), style=0)
        self.bt_FIBER_allonoff.Bind(wx.EVT_BUTTON,
              self.OnBt_FIBER_allonoffButton, id=wxID_FRAME1BT_FIBER_ALLONOFF)

        self.st_FIBER_tracking = wx.StaticText(id=wxID_FRAME1ST_FIBER_TRACKING,
              label=u'Tracking', name=u'st_FIBER_tracking',
              parent=self.pnl_FIBER, pos=wx.Point(48, 248), size=wx.Size(68,
              19), style=0)
        self.st_FIBER_tracking.SetForegroundColour(wx.Colour(255, 0, 0))
        self.st_FIBER_tracking.SetFont(wx.Font(16, wx.SWISS, wx.NORMAL,
              wx.NORMAL, False, u'Lucida Grande'))

        self.bt_FIBER_seedonoff = wx.Button(id=wxID_FRAME1BT_FIBER_SEEDONOFF,
              label=u'Seed On/Off (Ctrl+S)', name=u'bt_FIBER_seedonoff',
              parent=self.pnl_FIBER, pos=wx.Point(0, 272), size=wx.Size(160,
              20), style=0)
        self.bt_FIBER_seedonoff.SetForegroundColour(wx.Colour(255, 0, 0))
        self.bt_FIBER_seedonoff.SetFont(wx.Font(12, wx.SWISS, wx.NORMAL,
              wx.NORMAL, False, u'Lucida Grande'))
        self.bt_FIBER_seedonoff.SetExtraStyle(1)
        self.bt_FIBER_seedonoff.SetBackgroundColour(wx.Colour(221, 221, 221))
        self.bt_FIBER_seedonoff.Bind(wx.EVT_BUTTON,
              self.OnBt_FIBER_seedonoffButton,
              id=wxID_FRAME1BT_FIBER_SEEDONOFF)

        self.bt_FIBER_targetonoff = wx.Button(id=wxID_FRAME1BT_FIBER_TARGETONOFF,
              label=u'Target On/Off (Ctrl+T)', name=u'bt_FIBER_targetonoff',
              parent=self.pnl_FIBER, pos=wx.Point(0, 352), size=wx.Size(160,
              20), style=0)
        self.bt_FIBER_targetonoff.Bind(wx.EVT_BUTTON,
              self.OnBt_FIBER_targetonoffButton,
              id=wxID_FRAME1BT_FIBER_TARGETONOFF)

        self.bt_FIBER_tracknow = wx.Button(id=wxID_FRAME1BT_FIBER_TRACKNOW,
              label=u'TRACK NOW', name=u'bt_FIBER_tracknow',
              parent=self.pnl_FIBER, pos=wx.Point(24, 440), size=wx.Size(112,
              20), style=0)
        self.bt_FIBER_tracknow.Bind(wx.EVT_BUTTON,
              self.OnBt_FIBER_tracknowButton, id=wxID_FRAME1BT_FIBER_TRACKNOW)

        self.st_FIBER_pos_seed = wx.StaticText(id=wxID_FRAME1ST_FIBER_POS_SEED,
              label=u'To position the seed point and press Ctrl+s  in main window',
              name=u'st_FIBER_pos_seed', parent=self.pnl_FIBER, pos=wx.Point(8,
              296), size=wx.Size(160, 56), style=wx.TE_MULTILINE)
        self.st_FIBER_pos_seed.SetForegroundColour(wx.Colour(255, 0, 0))

        self.st_FIBER_pos_target = wx.StaticText(id=wxID_FRAME1ST_FIBER_POS_TARGET,
              label=u'To position a target point and press Ctrl+t  in main window',
              name=u'st_FIBER_pos_target', parent=self.pnl_FIBER,
              pos=wx.Point(8, 376), size=wx.Size(152, 64),
              style=wx.TE_MULTILINE)
        self.st_FIBER_pos_target.SetForegroundColour(wx.Colour(255, 0, 0))

        self.bt_FIBER_grp1 = wx.Button(id=wxID_FRAME1BT_FIBER_GRP1, label=u'1',
              name=u'bt_FIBER_grp1', parent=self.pnl_FIBER, pos=wx.Point(8,
              512), size=wx.Size(32, 20), style=0)
        self.bt_FIBER_grp1.Bind(wx.EVT_BUTTON, self.OnBt_FIBER_grp1Button,
              id=wxID_FRAME1BT_FIBER_GRP1)

        self.bt_FIBER_grp2 = wx.Button(id=wxID_FRAME1BT_FIBER_GRP2, label=u'2',
              name=u'bt_FIBER_grp2', parent=self.pnl_FIBER, pos=wx.Point(48,
              512), size=wx.Size(32, 20), style=0)
        self.bt_FIBER_grp2.Bind(wx.EVT_BUTTON, self.OnBt_FIBER_grp2Button,
              id=wxID_FRAME1BT_FIBER_GRP2)

        self.bt_FIBER_grp3 = wx.Button(id=wxID_FRAME1BT_FIBER_GRP3, label=u'3',
              name=u'bt_FIBER_grp3', parent=self.pnl_FIBER, pos=wx.Point(88,
              512), size=wx.Size(32, 20), style=0)
        self.bt_FIBER_grp3.Bind(wx.EVT_BUTTON, self.OnBt_FIBER_grp3Button,
              id=wxID_FRAME1BT_FIBER_GRP3)

        self.bt_FIBER_grp4 = wx.Button(id=wxID_FRAME1BT_FIBER_GRP4, label=u'4',
              name=u'bt_FIBER_grp4', parent=self.pnl_FIBER, pos=wx.Point(128,
              512), size=wx.Size(32, 20), style=0)
        self.bt_FIBER_grp4.Bind(wx.EVT_BUTTON, self.OnBt_FIBER_grp4Button,
              id=wxID_FRAME1BT_FIBER_GRP4)

        self.bt_FIBER_grp5 = wx.Button(id=wxID_FRAME1BT_FIBER_GRP5, label=u'5',
              name=u'bt_FIBER_grp5', parent=self.pnl_FIBER, pos=wx.Point(8,
              544), size=wx.Size(32, 20), style=0)
        self.bt_FIBER_grp5.Bind(wx.EVT_BUTTON, self.OnBt_FIBER_grp5Button,
              id=wxID_FRAME1BT_FIBER_GRP5)

        self.bt_FIBER_grp6 = wx.Button(id=wxID_FRAME1BT_FIBER_GRP6, label=u'6',
              name=u'bt_FIBER_grp6', parent=self.pnl_FIBER, pos=wx.Point(48,
              544), size=wx.Size(32, 20), style=0)
        self.bt_FIBER_grp6.Bind(wx.EVT_BUTTON, self.OnBt_FIBER_grp6Button,
              id=wxID_FRAME1BT_FIBER_GRP6)

        self.bt_FIBER_grp7 = wx.Button(id=wxID_FRAME1BT_FIBER_GRP7, label=u'7',
              name=u'bt_FIBER_grp7', parent=self.pnl_FIBER, pos=wx.Point(88,
              544), size=wx.Size(32, 20), style=0)
        self.bt_FIBER_grp7.Bind(wx.EVT_BUTTON, self.OnBt_FIBER_grp7Button,
              id=wxID_FRAME1BT_FIBER_GRP7)

        self.bt_FIBER_grp8 = wx.Button(id=wxID_FRAME1BT_FIBER_GRP8, label=u'8',
              name=u'bt_FIBER_grp8', parent=self.pnl_FIBER, pos=wx.Point(128,
              544), size=wx.Size(32, 20), style=0)
        self.bt_FIBER_grp8.Bind(wx.EVT_BUTTON, self.OnBt_FIBER_grp8Button,
              id=wxID_FRAME1BT_FIBER_GRP8)

        self.st_FIBER_grpLabel = wx.StaticText(id=wxID_FRAME1ST_FIBER_GRPLABEL,
              label=u'Fiber group On/Off', name=u'st_FIBER_grpLabel',
              parent=self.pnl_FIBER, pos=wx.Point(8, 488), size=wx.Size(122,
              16), style=0)
        self.st_FIBER_grpLabel.SetForegroundColour(wx.Colour(0, 0, 255))

        self.stbox_COLOUR_dispselected = wx.StaticBox(id=wxID_FRAME1STBOX_COLOUR_DISPSELECTED,
              label=u'', name=u'stbox_COLOUR_dispselected',
              parent=self.pnl_COLOUR, pos=wx.Point(-24, 321), size=wx.Size(200,
              50), style=0)
        self.stbox_COLOUR_dispselected.SetBackgroundColour(wx.Colour(221, 221,
              221))

        self.st_COLOURS_selected = wx.StaticText(id=wxID_FRAME1ST_COLOURS_SELECTED,
              label=u'Selected Colour', name=u'st_COLOURS_selected',
              parent=self.pnl_COLOUR, pos=wx.Point(24, 336), size=wx.Size(121,
              18), style=0)
        self.st_COLOURS_selected.SetFont(wx.Font(15, wx.SWISS, wx.NORMAL,
              wx.BOLD, False, u'Lucida Grande'))

        self.bt_COLOUR_applysel = wx.Button(id=wxID_FRAME1BT_COLOUR_APPLYSEL,
              label=u'Apply to selected', name=u'bt_COLOUR_applysel',
              parent=self.pnl_COLOUR, pos=wx.Point(16, 408), size=wx.Size(136,
              20), style=0)
        self.bt_COLOUR_applysel.Bind(wx.EVT_BUTTON,
              self.OnBt_COLOUR_applyselButton,
              id=wxID_FRAME1BT_COLOUR_APPLYSEL)

        self.bt_COLOUR_applyall = wx.Button(id=wxID_FRAME1BT_COLOUR_APPLYALL,
              label=u'Apply to all', name=u'bt_COLOUR_applyall',
              parent=self.pnl_COLOUR, pos=wx.Point(16, 456), size=wx.Size(136,
              20), style=0)
        self.bt_COLOUR_applyall.Bind(wx.EVT_BUTTON,
              self.OnBt_COLOUR_applyallButton,
              id=wxID_FRAME1BT_COLOUR_APPLYALL)

        self.st_COLOUR_pickinstr = wx.StaticText(id=wxID_FRAME1ST_COLOUR_PICKINSTR,
              label=u'Pick a colour by double clicking in the colour window above',
              name=u'st_COLOUR_pickinstr', parent=self.pnl_COLOUR,
              pos=wx.Point(24, 232), size=wx.Size(120, 72),
              style=wx.TE_MULTILINE)

        self.palette = PyPalette(self.pnl_COLOUR, id=wxID_COLPICK)
        self.palette.Bind(wx.EVT_LEFT_DCLICK, self.OnColourPick)

        self._init_coll_notebook1_Pages(self.notebook1)

    def __init__(self, parent):
        self._init_ctrls(parent)

    #functionality - bind to main window
    def OnButton1Button(self, event):
        event.Skip()

    def OnButton2Button(self, event):
        event.Skip()

    def OnButton5Button(self, event):
        event.Skip()

    def OnButton6Button(self, event):
        event.Skip()

    def OnButton7Button(self, event):
        event.Skip()

    def OnButton8Button(self, event):
        event.Skip()

    def OnBt_MPR_axButton(self, event):
        event.Skip()

    def OnBt_MPR_sagButton(self, event):
        event.Skip()

    def OnBt_MPR_corButton(self, event):
        event.Skip()

    def OnBt_MPR_edgesButton(self, event):
        event.Skip()

    def OnBt_MPR_resetButton(self, event):
        event.Skip()

    def OnBt_L_view_selectButton(self, event):
        event.Skip()

    def OnBt_R_view_selectButton(self, event):
        event.Skip()

    def OnBt_S_view_selectButton(self, event):
        event.Skip()

    def OnBt_I_view_selectButton(self, event):
        event.Skip()

    def OnBt_A_view_selectButton(self, event):
        event.Skip()

    def OnBt_P_view_selectButton(self, event):
        event.Skip()

    def OnBt_STRUCT_axButton(self, event):
        event.Skip()

    def OnBt_STRUCT_sagButton(self, event):
        event.Skip()

    def OnButton3Button(self, event):
        event.Skip()

    def OnBt_STRUCT_corButton(self, event):
        event.Skip()

    def OnBt_STRUCT_edgesButton(self, event):
        event.Skip()

    def OnBt_STRUCT_resetButton(self, event):
        event.Skip()

    def OnBt_STRUCT_L_view_selectButton(self, event):
        event.Skip()

    def OnBt_STRUCT_R_view_selectButton(self, event):
        event.Skip()

    def OnBt_STRUCT_Sup_view_selectButton(self, event):
        event.Skip()

    def OnBt_STRUCT_Inf_view_selectButton(self, event):
        event.Skip()

    def OnBt_STRUCT_Ant_view_selectButton(self, event):
        event.Skip()

    def OnBt_STRUCT_Post_view_selectButton(self, event):
        event.Skip()

    def OnBt_FUNC_loadButton(self, event):
        event.Skip()

    def OnBt_FUNC_switch2dButton(self, event):
        event.Skip()

    def OnBt_FUNC_3dcycleButton(self, event):
        event.Skip()

    def OnSpbt_FUNC_threshold3dSpin(self, event):
        event.Skip()

    def OnBt_CORTEX_loadButton(self, event):
        event.Skip()

    def OnBt_DIP_loadButton(self, event):
        event.Skip()

    def OnSpinButton1Spin(self, event):
        event.Skip()

    def OnSpbt_CORTEX_transpSpin(self, event):
        event.Skip()

    def OnBt_CORTEX_OnOffButton(self, event):
        event.Skip()

    def OnBt_DIP_visButton(self, event):
        event.Skip()

    def OnBt_OTHER_orthoButton(self, event):
        event.Skip()

    def OnBt_OTHER_tifmainButton(self, event):
        event.Skip()

    def OnBt_OTHER_tiforthoButton(self, event):
        event.Skip()

    def OnBt_OTHER_quitButton(self, event):
        event.Skip()

    def OnBt_OTHER_helpButton(self, event):
        event.Skip()

    def OnBt_FIBER_loadButton(self, event):
        event.Skip()

    def OnBt_FIBER_allonoffButton(self, event):
        event.Skip()

    def OnBt_FIBER_seedonoffButton(self, event):
        event.Skip()

    def OnBt_FIBER_targetonoffButton(self, event):
        event.Skip()

    def OnBt_FIBER_tracknowButton(self, event):
        event.Skip()

    def OnBt_FIBER_grp1Button(self, event):
        event.Skip()

    def OnBt_FIBER_grp2Button(self, event):
        event.Skip()

    def OnBt_FIBER_grp3Button(self, event):
        event.Skip()

    def OnBt_FIBER_grp4Button(self, event):
        event.Skip()

    def OnBt_FIBER_grp5Button(self, event):
        event.Skip()

    def OnBt_FIBER_grp6Button(self, event):
        event.Skip()

    def OnBt_FIBER_grp7Button(self, event):
        event.Skip()

    def OnBt_FIBER_grp8Button(self, event):
        event.Skip()

    def OnBt_COLOUR_applyselButton(self, event):
        event.Skip()

    def OnBt_COLOUR_applyallButton(self, event):
        event.Skip()

    def OnColourPick(self, event):
        selected_colour = self.palette.GetValue(event.GetX(), event.GetY())
        self.stbox_COLOUR_dispselected.SetBackgroundColour(selected_colour)

def main():
    application = ynicDV3D_MenuApp(0)
    application.MainLoop()

if __name__ == '__main__':
    main()
