#!/usr/bin/python
#ynicDV3D_wx_help.py

#TODO
#   1.  html help content
#   2. figure out correct exit / close

"""
This module creates a Help / info dialog implmented using an wx.html.HtmlWindow.
"""

import sys
try:
    import wx       # This module uses the new wx namespace (?2004)
    import wx.html
except:
    print 'Cannot load help'

#----------------------------------------------------------------------

class LoadHelpWindow(wx.Dialog):
    ' ynicDV3D - Using the main window '

#html format content goes here ...
    help_html_text = '''
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
  <meta content="text/html; charset=ISO-8859-1"
 http-equiv="content-type">
  <title>ynicDV3D help</title>
</head>
<body>
<font color="#000066" size="+1"><b><img
 alt="logo" src="./DV3Dlogo.jpg" height="62"
 width="93"></b></font><font color="#000066"
 size="+1"><b> &nbsp;
&nbsp; ynicDV3D HELP<br>
<br>
</b></font>Click in the main window to start.<br>
( press 'z' to turn these instructions on
/ off)<br>
<br>
<br>
<font color="#ff0000"><a name="top"></a>Quick
links:<br>
</font>
<ul>
  <li><a href="#USING_THE_MAIN_WINDOW"><font
 color="#ff0000">Using the main window</font></a></li>
  <li><a href="#USING_THE_MENU"><font
 color="#ff0000">Using the side menu</font></a></li>
  <li><a href="#LOADING_DATA__.._and_interacting_with_"><font
 color="#ff0000">Loading Data</font></a></li>
  <ul>
    <li><a href="#fMRI_loading"><font
 color="#ff0000">fMRI</font></a></li>
    <li><a href="#Beamforming_results"><font
 color="#ff0000">MEG (beamforming)</font></a></li>
    <li><a href="#Dipoles"><font color="#ff0000">MEG
(dipoles)</font></a></li>
  </ul>
  <li><font color="#ff0000">Other data types<br>
    </font></li>
  <ul>
    <li><a href="#Loading_a_3d_brain_surface"><font
 color="#ff0000">Cortex
(brain surface)</font></a></li>
  </ul>
  <li><font color="#ff0000">Useful functions</font></li>
  <ul>
    <li><a href="#Snapping_planes"><font
 color="#ff0000">snapping planes to a selected point</font></a></li>
    <li><a href="#Generating_orthogonal_plane_views"><font
 color="#ff0000">generating ortho views</font></a></li>
    <li><a href="#Saving_images_out"><font
 color="#ff0000">saving
out images</font></a></li>
  </ul>
  <li><a href="#Keyboard_shortcuts"><font
 color="#ff0000">Keyboard shortcut list</font></a></li>
</ul>
<font color="#ff0000"><!--# Other data types
* DTI fibers
* DTI probability distributions
#
# Changing the colour of objects--></font><br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<font color="#000066"><b><a
 name="USING_THE_MAIN_WINDOW"></a>USING
THE MAIN
WINDOW: &nbsp; &nbsp; &nbsp; &nbsp;<a href="#top"><font
 color="#ff0000">(back to top)</font></a></b></font><br>
<br>
<div align="center"><img alt="mw"
 src="./help/main_window.png" height="208" width="252"><br>
</div>
<br>
Instructions
for interacting with the main window:<br>
<br>
<font color="#ff0000">LEFT MOUSE BUTTON: <small>hold
down the button and move the mouse</small></font><br>
<blockquote><font color="#ff0000">OUTSIDE</font>
the edges of the brain: ROTATE in that direction<br>
  <font color="#ff0000">INSIDE</font> the edges of
the brain to PICK a co-ordinate of a point on a
plane<br>
Coordinates appear in the bottom left corner of the selected plane<br>
</blockquote>
<br>
<font color="#ff0000">MIDDLE
MOUSE BUTTON:</font><font color="#ff0000"><small>
hold down the button and move
the mouse</small></font>
<blockquote><font color="#ff0000">OUTSIDE</font>
the edges of the brain: MOVE the entire dataset in that direction<br>
  <font color="#ff0000">INSIDE</font> the edges of
the brain to MOVE THE PLANE backwards or forward: This effectively
re-slices the plane to show you a different slice<br>
  <blockquote><i><font color="#3333ff"><b>ADVANCED</b>:
    <b>RESLICE IN ANY DIRECTION</b>: when you middle click
inside the edges of a slice, bounding boxes appear at the edges (the
slice edges go green and blue lines appear inside these). Middle
clicking in this edge 'box' and moving the mouse rotates the selected
slice around its axis. This allows you to reslice in any direction. You
can re-centre the slices at any time by pressing '<b><font
 color="#ff0000">L</font></b>' in the main window
or selecting the 'RESET' button on the side menu.</font></i><br>
  </blockquote>
</blockquote>
<font color="#ff0000">RIGHT
MOUSE BUTTON: </font><font color="#ff0000"><small>hold
down the button and move
the mouse</small></font>
<blockquote><font color="#ff0000">OUTSIDE</font>
the edges of the brain: ZOOM IN (top half of window) or ZOOM
OUT (bottom half)<br>
Press&nbsp;<font color="#ff0000"><b>r</b></font>
to reset the zoom of the window<br>
  <font color="#ff0000">INSIDE</font> the edges of
the brain: change the COLOUR LEVEL or WINDOW LEVEL
of MRI data<br>
</blockquote>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<a name="USING_THE_MENU"></a><font color="#000066"><b>USING
THE MENU</b></font><font color="#000066"><b>
&nbsp; &nbsp; &nbsp; &nbsp;<a href="#top"><font
 color="#ff0000">(back to top)</font></a><br>
<br>
</b></font>
<div align="center"><font color="#000066"><b><img
 alt="sm" src="./help/side_menu.png" align="left"
 height="242" width="88"></b></font><br>
</div>
<br>
The
menu has a number of buttons which can be pressed to call
the
desired functions. You need to click on the actual buttons / arrows
(not the text) to call the action.<br>
<br>
Each function can also be called by pressing the appropriate
keyboard
key when the main window has the focus.<br>
<br>
Simply click on an object in the Menu Window to call the
function.<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<a name="LOADING_DATA__.._and_interacting_with_"></a><br>
<b><font color="#000066">LOADING DATA</font></b>
<font color="#000066" size="-1">( .. and
interacting with it ..)</font> <font color="#000066"><b>
&nbsp; &nbsp; &nbsp; &nbsp;<a href="#top"><font
 color="#ff0000">(back to top)</font></a></b></font><br>
<br>
Data files are loaded by calling your systems standard pop-up
window
file dialog. Simply select the required file and click OK or OPEN when
requested.<br>
<br>
<br>
Data file formats supported at the moment are:<br>
<br>
<table border="1" cellpadding="2" cellspacing="2"
 width="100%">
  <tbody>
    <tr>
      <td>Beamforming
results (MEG)</td>
      <td>NIFTI compressed (.nii.gz)</td>
    </tr>
    <tr>
      <td>fMRI results</td>
      <td>NIFTI compressed (.nii.gz)</td>
    </tr>
    <tr>
      <td>Structural MRI</td>
      <td>NIFTI compressed (.nii.gz)</td>
    </tr>
    <tr>
      <td>Dipoles (MEG)</td>
      <td>4D Neuroimaging dipole fit output file (any format)</td>
    </tr>
    <tr>
      <td>Fiber data (DTI)</td>
      <td>.OUT fiber files (see specification)</td>
    </tr>
    <tr>
      <td>Cortical Surface</td>
      <td>Binary .OFF files (see specification)</td>
    </tr>
  </tbody>
</table>
<br>
<br>
If you have
ANALYZE files (.hdr and .img) at the moment you
can easily
convert them to NIFTI_GZ by running <i>avwchfiletype</i>
at the command line ( .. at YNiC ..)<br>
<br>
Loading data can take time .. remember that data sets are
often big and
all the clever things we try to do to display the data also take time.
We are always working to make these faster but ( .. in the meantime ..
) please be patient.<br>
<br>
<br>
<a name="Functional_data_types"></a>Functional
data
(or those which we typically visualise as 'coloured
blobs') can be loaded in 2 different modes, 2D-merged or 3D:<br>
<br>
<ul>
  <li>2D-merged processing merges the 'blobs'
of activation /
deactivation into the already loaded structural dataset; absolute
thresholds (positive and negative) are set by you when the data is
loaded; data needs to be reloaded if thresholds are to be recalculated
...</li>
</ul>
<br>
<br>
<div align="center"><img alt="2d_eg"
 src="./help/2d_func.png" height="271" width="329"></div>
<br>
<br>
<ul>
  <li>3D
processing shows the blobs
as 3D surfaces;
thresholds
are set by you when loading.. in this case the thresholds are not
absolute but are as a percentage of the maximum and minimum of your
data: e.g. lets say you have a maximum of 20 and a minimum of -10 in
your data. You choose to spilt these into 10 'bins' and display the top
5. This will create an isosurface for each of the isocontours at +20,
+18, +16, +14 and +12 for your positive values (shades of red-yellow)
and -10, -9, -8, -7, and -6 in your negative values (shades of blue).
Once the surfaces are genrated they can be cycled on/off so you can see
all positive values only, a selection of positive, all negative, a
selection of negative or even a selection (e.g. the top 2 of all 5
generated surfaces) of both the top <i>x</i> negative and
positive values together ...</li>
</ul>
<br>
<br>
<div align="center"><img alt="3d_both_eg"
 src="./help/3d_func_both.png" height="273" width="330"></div>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<font color="#000066"><b><a name="MRI_DATA"></a>LOADING
MRI DATA</b></font> <font color="#000066"><b>
&nbsp; &nbsp; &nbsp;
&nbsp;<a href="#top"><font color="#ff0000">(back
to top)</font></a></b></font><br>
<br>
<br>
Structural MRIs are loaded at the startup of the
program.<br>
<br>
<br>
<br>
<br>
<font color="#000066"><b><a name="fMRI_loading"></a>fMRI</b></font>
<font color="#000066"><b> &nbsp; &nbsp;
&nbsp;
&nbsp;<a href="#top"><font color="#ff0000">(back
to top)</font></a></b></font><br>
<br>
fMRI results are loaded for 2d-merged or 3d visualisation
(see&nbsp;<a href="#Functional_data_types"><span
 style="font-style: italic;"></span></a><i><a
 href="ynicDV3D_help.html#Functional_data_types">Functional
data types</a></i> above)<br>
<br>
<br>
Press <font color="#ff0000"><b>F</b></font>
in the main window or select the <b><font color="#ff0000">LOAD</font></b>
button under FUNCTIONAL DATA on the
side menu to
load your fMRI result data file<br>
<br>
<br>
After typing <font color="#ff0000"><b>F</b></font>
in the main window or clicking the <span
 style="font-weight: bold; color: rgb(255, 0, 0);">Load</span>
button under FUNCTIONAL DATA on the side menu, you will be prompted to
pick:<br>
<ol>
  <li>&nbsp;&nbsp;&nbsp;a NIFTI GZ file
containing
your fMRI results&nbsp;
&ndash; BROWSE, SELECT A FILE AND CLICK <b><font
 color="#ff0000">OPEN</font></b><i><font
 color="#3333ff"><b> &nbsp; &nbsp; &nbsp;<font
 size="-1">.. NB</font></b><font size="-1">:
this file should already have been co-registered to the structural data
you have loaded at the start of the program. This is usually done by
running FSLs FLIRT program. See FSL tutorial.</font><span
 style="color: rgb(0, 0, 102);"></span></font></i></li>
  <li>You will now be asked if you want to load the data in
2d-merged or 3d mode (see <span style="font-style: italic;"><a
 href="#Functional_data_types">Functional
data types</a> </span>above). Type <b><font
 color="#ff0000">m&nbsp;</font></b>if you
want 2d-merged mode or <font color="#ff0000"><b>3</b></font>
if you want 3d mode.</li>
  <li>If you selected 3d mode:</li>
  <ol>
    <li>Enter the number of bins you would ike to split
your data
into (see <span style="font-style: italic;"><a
 href="#Functional_data_types">Functional
data types</a> </span>above). The current maximum is 10.
CLICK <b><font color="#ff0000">OK</font></b></li>
    <li>Enter the number of these bins you would like to be made
visible. CLICK <b><font color="#ff0000">OK
&nbsp;</font></b><font color="#3333ff"
 size="-1"><i>.. e.g. if you set 10 before and 3 here,
you will see surfaces at 80%, 90% and 100% of the maximum in your
data.&nbsp;</i></font></li>
    <li>Give the program a few
seconds to draw the surfaces&nbsp; <font color="#3333ff"
 size="-1"><i>.. this can take up to a minute depending
on the number of surfaces you chose to calculate / display</i></font></li>
    <li>The
top surface is displayed (or surfaces if there are positive and
negative maxima in your dataset). Positive values are displayed inn
red-yellow and negative in shades of blue. Since these surface may be
small it may be diffucult to see.&nbsp;</li>
    <li>You can make more surfaces visible by pressing <font
 color="#ff0000"><b>X</b></font> or
clicking the <font color="#ff0000"><b>Threshold&nbsp;DOWN</b></font>
button on the side menu <font color="#3333ff" size="-1"><i>..
this effectively lowers your theshold by 10%</i></font></li>
    <li>You can make fewer surfaces visible by pressing <font
 color="#ff0000"><b>Y</b></font> or
clicking the <font color="#ff0000"><b>Threshold Up</b></font>
button on the side menu<font color="#3333ff" size="-1"><i>&nbsp;</i><i>
      </i></font><font color="#3333ff" size="-1"><i>..
this effectively raises your theshold by 10%</i></font></li>
    <li>Press <font color="#ff0000"><b>f</b></font>
or click&nbsp;the <font color="#ff0000"><b>Cycle
3d</b></font> button on the side menu to cycle through the
following modes:&nbsp;</li>
    <ol>
      <li>Positive and negative visible (default)</li>
      <li>Positive only visible</li>
      <li>Negative only visible</li>
      <li>Neither visible</li>
      <li>Back to positive and negative visible ... etc.</li>
    </ol>
    <li>N.B. whilst cycling through, the threshold may be
reset
to highest
values only, but this can be adjusted as required by pressing <font
 color="#ff0000"><b>X</b></font> / <font
 color="#ff0000"><b>Y</b></font> as
described above</li>
  </ol>
  <li>If you selected 2d-merged mode:</li>
  <ol>
    <li>Prompts will tell you the maxima and minina that
have
been found in your data files&nbsp;<font color="#3333ff"
 size="-1"><i>.. if there are no negative values only
one pop-up box is used for positive value choices (vica versa)</i></font></li>
    <li>You will be asked to enter the lower boundary (or
threshold) of the data to display. Enter the value and click <font
 color="#ff0000"><b>OK</b></font>. <font
 color="#3333ff" size="-1"><i>..
e.g. the maximum in your data might be 7.353 but you might only want to
threshold the result at all values above 2.3 ( if loading z-stat data
for example)</i></font></li>
    <li>The default value in the pop-up box is <font
 color="#ff0000"><i>'skip'</i></font>.
This allows you to skip the generation of the positive values /
negative values ( .. or both! .. ) so that&nbsp;positive or
negative
results can be viewed independently. Click <font color="#ff0000"><b>OK</b></font>
without changing the value if you want to skip.</li>
    <li>Give the program a few
seconds to draw your results&nbsp;<font color="#3333ff"
 size="-1"><i>.. this can take up to a minute depending
on the number of slices in your mri dataset</i></font></li>
    <li>You can toggle between the original structural dataset
loaded by pressing <font color="#ff0000"><b>M</b></font>
or clicking the <font color="#ff0000"><b>Switch</b><b>
2d</b></font> button on the side menu</li>
  </ol>
</ol>
<font color="#000066"><b><br>
<a href="#top"><font color="#ff0000">(back
to
top)</font></a></b></font><br>
<br>
<br>
<br>
<br>
<br>
<br>
<!--DTI - Fiber data (back to top)
Todo
Fiber data (back to top)
W &#8211; Load
g &#8211; make all loaded fibers visible
G &#8211; make all loaded fibers invisible
h &#8211; make ROI fiber selector visible
t &#8211; place ROI fiber selector at picked location
k &#8211; make any fibers touching the ROI selector invisible
K &#8211; make any fibers not touching the ROI selector invisible
Colour on menu - make any fibers touching the ROI selector this colour
Ctrl + Colour on menu - make all visible fibers this colour
DTI - Probabilistic connectivity distributions (back to top)
Todo
--><br>
<br>
<br>
<b><font color="#000066">MEG DATA</font></b>
<font color="#000066"><b> &nbsp;
&nbsp; &nbsp; &nbsp;<a href="#top"><font
 color="#ff0000">(back to top)</font></a></b></font><br>
<font color="#ff0000"><b><br>
<a name="Beamforming_results"></a><font
 color="#000066">Loading
-
Beamforming results</font> </b></font><font
 color="#000066"><b>
&nbsp; &nbsp; &nbsp; &nbsp;<a href="#top"><font
 color="#ff0000">(back to top)</font></a></b></font><br>
<br>
<br>
Press <font color="#ff0000"><b>F</b></font>
in the main window or select the <b><font color="#ff0000">LOAD</font></b>
button under FUNCTIONAL DATA on the side menu to load your beamforming
result data file<br>
<br>
<br>
After typing <font color="#ff0000"><b>F</b></font>
in the main window or clicking the <span
 style="font-weight: bold; color: rgb(255, 0, 0);">Load</span>
button under FUNCTIONAL DATA on the side menu, you will be prompted to
pick:<br>
<ol>
  <li>&nbsp;&nbsp;&nbsp;a NIFTI GZ file
containing
your beamforming results&nbsp;
&ndash; BROWSE, SELECT A FILE AND CLICK <b><font
 color="#ff0000">OPEN</font></b><i><font
 color="#3333ff"><b> &nbsp; &nbsp; &nbsp;<font
 size="-1">.. NB</font></b><font size="-1">:
this file should already have been co-registered to the struturla data
you have loaded at the start of the program. This is usually the case
for beamforming data - you would only look at the results in subject
R1025's directory overlaid on R1025's structural.</font><span
 style="color: rgb(0, 0, 102);"></span></font></i></li>
  <li>You will now be asked if you want to load the data in
2d-merged or 3d mode (see <span style="font-style: italic;"><a
 href="#Functional_data_types">Functional data types</a>
    </span>above). Type <b><font color="#ff0000">m&nbsp;</font></b>if
you want 2d-merged mode or <font color="#ff0000"><b>3</b></font>
if you want 3d mode.</li>
  <li>If you selected 3d mode:</li>
  <ol>
    <li>Enter the number of bins you would ike to split
your data
into (see <span style="font-style: italic;"><a
 href="#Functional_data_types">Functional
data types</a> </span>above). The current maximum is 10.
CLICK <b><font color="#ff0000">OK</font></b></li>
    <li>Enter the number of these bins you would like to be made
visible. CLICK <b><font color="#ff0000">OK
&nbsp;</font></b><font color="#3333ff"
 size="-1"><i>.. e.g. if you set 10 before and 3 here,
you will see surfaces at 80%, 90% and 100% of the maximum in your
data.&nbsp;</i></font></li>
    <li>Give the program a few
seconds to draw the surfaces&nbsp; <font color="#3333ff"
 size="-1"><i>.. this can take up to a minute depending
on the number of surfaces you chose to calculate / display</i></font></li>
    <li>The top surface is displayed (or surfaces if there are
positive and negative maxima in your dataset). Positive values are
displayed inn red-yellow and negative in shades of blue. Since these
surface may be small it may be diffucult to see.&nbsp;</li>
    <li>You can make more surfaces visible by pressing <font
 color="#ff0000"><b>X</b></font> or
clicking the <font color="#ff0000"><b>Threshold&nbsp;DOWN</b></font>
button on the side menu <font color="#3333ff" size="-1"><i>..
this effectively lowers your theshold by 10%</i></font></li>
    <li>You can make fewer surfaces visible by pressing <font
 color="#ff0000"><b>Y</b></font> or
clicking the <font color="#ff0000"><b>Threshold Up</b></font>
button on the side menu<font color="#3333ff" size="-1"><i>&nbsp;</i><i>
      </i></font><font color="#3333ff" size="-1"><i>..
this effectively raises your theshold by 10%</i></font></li>
    <li>Press <font color="#ff0000"><b>f</b></font>
or click&nbsp;the <font color="#ff0000"><b>Cycle
3d</b></font> button on the side menu to cycle through the
following modes:&nbsp;</li>
    <ol>
      <li>Positive and negative visible (default)</li>
      <li>Positive only visible</li>
      <li>Negative only visible</li>
      <li>Neither visible</li>
      <li>Back to positive and negative visible ... etc.</li>
    </ol>
    <li>N.B. whilst cycling through, the threshold may be
reset
to highest
values only, but this can be adjusted as required by pressing <font
 color="#ff0000"><b>X</b></font> / <font
 color="#ff0000"><b>Y</b></font> as
described above</li>
  </ol>
  <li>If you selected 2d-merged mode:</li>
  <ol>
    <li>Prompts will tell you the maxima and minina that
have
been found in your data files&nbsp;<font color="#3333ff"
 size="-1"><i>.. if there are no negative values only
one pop-up box is used for positive value choices (vica versa)</i></font></li>
    <li>You will be asked to enter the lower boundary (or
threshold) of the data to display. Enter the value and click <font
 color="#ff0000"><b>OK</b></font>. <font
 color="#3333ff" size="-1"><i>.. e.g. the
maximum in your data might be 7.353 but you might only want to
threshold the result at all values above 2.3 ( if loading z-stat data
for example)</i></font></li>
    <li>The default value in the pop-up box is <font
 color="#ff0000"><i>'skip'</i></font>. This
allows you to skip the generation of the positive values / negative
values ( .. or both! .. ) so that&nbsp;positive or negative results
can be viewed independently. Click <font color="#ff0000"><b>OK</b></font>
without changing the value if you want to skip.</li>
    <li>Give the program a few
seconds to draw your results&nbsp;<font color="#3333ff"
 size="-1"><i>.. this can take up to a minute depending
on the number of slices in your mri dataset</i></font></li>
    <li>You can toggle between the original structural dataset
loaded by pressing <font color="#ff0000"><b>M</b></font>
or clicking the <font color="#ff0000"><b>Switch</b><b>
2d</b></font> button on the side menu</li>
  </ol>
</ol>
<font color="#000066"><b><br>
<a href="#top"><font color="#ff0000">(back
to
top)</font></a></b></font><br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<font color="#ff0000"><b><a name="Dipoles"></a><font
 color="#000066">Loading
- Dipoles</font> </b></font><font color="#000066"><b>
&nbsp; &nbsp; &nbsp; &nbsp;<a href="#top"><font
 color="#ff0000">(back to top)</font></a></b></font><br>
<br>
Press <font color="#ff0000"><b>D</b></font>
in the main window or select the dipole <b><font
 color="#ff0000">LOAD</font></b> button on the
menu to
load dipole data file
<blockquote><font color="#3333ff"><i>Information:
Dipole data consists of a time-series with:</i></font><br>
  <blockquote><font color="#3333ff"><i>3 x-y-z
co-ordinates for the location of the centre of the estimated
source<br>
3 x-y-z scalars describing the magnitude and orientation vector of the
estimated source<br>
2 scalars describing the confidence and goodness-of-fit of the
estimated source</i></font><br>
  </blockquote>
</blockquote>
<div align="center"><img alt="dip"
 src="./help/dipole_1.png" height="350" width="384"><br>
</div>
<br>
<br>
After
typing <font color="#ff0000"><b>D</b></font>
in the main window or clicking the <span
 style="font-weight: bold; color: rgb(255, 0, 0);">Load</span>
button under DIPOLE DATA on the side menu, you will be prompted to pick:<br>
<ol>
  <li>&nbsp;&nbsp;&nbsp;a 4D-Neuroimaging
dipole
overlay file&nbsp;
&ndash; BROWSE, SELECT A FILE AND CLICK <b><font
 color="#ff0000">OPEN</font></b></li>
  <li>&nbsp;&nbsp;&nbsp;a text file (any format)
containing the 4x4
transformation matrix which described the values required to transform
the MEG data set / space into the co-ordinate system of the currently
loaded MRI set - BROWSE, SELECT A FILE AND CLICK <font
 color="#ff0000"><b>OPEN &nbsp; &nbsp;</b></font><i><font
 color="#3333ff"><b>YNIC Users</b>:
this file is generated for you when you use ynicBF to do a
coregistration. It is usually saved for you in the same directory that
contains you beamforming results (IMG_5mm and NAI_5mm) in your
beamforming output path. It will be called something like&nbsp;<span
 style="color: rgb(0, 0, 102);"><span
 style="color: rgb(255, 0, 0);">home_andre_PhD_myexperiment_R1025b_c,rfDC_transform.txt</span>.</span></font></i></li>
  <li>&nbsp;&nbsp;&nbsp;Select the time-point for
which you would like
to display the initial dipole location e.g. you may be interested in
the position of your dipole 100 ms after the start of your pre-defined
epoch / data sample. &ndash; TYPE THE REQUIRED VALUE (in
milliseconds) AND CLICK <b><font color="#ff0000">OK</font></b></li>
  <li>&nbsp;&nbsp;Give the program a few
seconds to load the data</li>
  <li>&nbsp;&nbsp;The initial dipole position and
orientation
should be displayed. The radius of the sphere depicting the dipole
source is proportional to the confidence in the localisation; the
length of the orientation vector is proportional of the strength of the
dipole</li>
  <li>&nbsp;&nbsp;&nbsp;Hold down <font
 color="#ff0000"><b>Ctrl</b></font> and
then click the left arrow ( <font color="#ff0000"><b>&larr;</b></font>
) or right arrow ( <font color="#ff0000"><b>&rarr;</b></font>
) cycle to the position of the
dipole 1 ms previous in time or 1 ms forward in time respectively.</li>
  <li>&nbsp;&nbsp;&nbsp;You can also change to colour
of the dipole by
picking it and changing the color (See <a
 href="#CHANGING_OBJECT_COLOURS">CHANGING OBJECT COLOURS</a>
below)</li>
  <li>&nbsp;&nbsp;&nbsp;Multiple dipole files can be
loaded and
displayed simultaneously, but when a new dipole data set is loaded the
ability to interact with the previous set is lost.</li>
</ol>
<font color="#000066"><b><br>
<a href="#top"><font color="#ff0000">(back to
top)</font></a></b></font><br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<font color="#000066"><b><a
 name="Loading_a_3d_brain_surface"></a>Loading a 3d
brain surface</b><b>&nbsp;
&nbsp; &nbsp; &nbsp;<a href="#top"><font
 color="#ff0000">(back to top)</font></a></b></font><br>
<br>
If you have a generated cortical surface in Binary .OFF
format, you can load it into your data.<br>
<blockquote><font color="#3333ff" size="-1"><i>Information
about
the .OFF file fomat is available at
http://www.geomview.org/docs/html/geomview_41.html#SEC44. A tutorial on
generating your own will follow soon. A .off file example is provided
in the examples directory (but is of course not guaranteed to
co-register with your data!)</i></font><br>
</blockquote>
Press
<font color="#ff0000"><b>B</b></font>
in the main window or select the CORTICAL SURFACE <b><font
 color="#ff0000">LOAD</font></b> button on the
menu to
load dipole data file
<font color="#3333ff"><i><br>
<br>
</i></font><font color="#3333ff"><i><br>
</i></font>
<div align="center"><font color="#3333ff"><i><img
 alt="brain surface" src="./help/cortex.png"
 height="329" width="332"></i></font><br>
</div>
<br>
<br>
After
typing <font color="#ff0000"><b>B</b></font>
in the main window or clicking the <span
 style="font-weight: bold; color: rgb(255, 0, 0);">Load</span>
button under&nbsp;CORTICAL SURFACE on the side menu, you will be
prompted to pick:<br>
<ol>
  <li>a Binary .OFF file of the cortical surface
&ndash; BROWSE, SELECT A FILE AND CLICK <b><font
 color="#ff0000">OPEN</font></b></li>
  <li>Give
the program a few
seconds to draw your results&nbsp;<font color="#3333ff"
 size="-1"><i>.. this can take up to a minute depending
on the resolution of your cortical surface file</i></font></li>
  <li>Once
the cortex is loaded it will appear as a red surface in the main window.</li>
  <li>The
surface can be toggles on / off by pressing <font color="#ff0000"><b>v&nbsp;</b></font>or
by clicking the <font color="#ff0000"><b>Visible
On/Off</b></font> button under&nbsp;CORTICAL SURFACE on
the side menu</li>
  <li>The surface can be faded in / out by
pressing <font color="#ff0000"><b>b </b></font>/<font
 color="#ff0000"><b> n </b></font>respectively
or by clicking the <font color="#ff0000"><b>Opacity
Up/Down</b></font> buttons under&nbsp;CORTICAL SURFACE
on the side menu</li>
</ol>
<blockquote>
  <blockquote><font color="#3333ff"><i><b>ADVANCED</b>:
Clicking <font color="#ff0000"><b>V</b></font>
in the main window initiates the surface cutter. By clicking on and
moving the spherical handles of each surface of the cutter cube, the
surface can be sliced into in any plane. Click </i></font><font
 color="#3333ff"><i><font color="#ff0000"><b>V</b></font>
in to turn the cutter off again. This procedure is pretty complex and
calculation intensive so can be pretty slow.</i></font></blockquote>
</blockquote>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<font color="#000066"><b><a
 name="Generating_orthogonal_plane_views"></a>Generating
orthogonal plane views</b><b>&nbsp;
&nbsp; &nbsp; &nbsp;<a href="#top"><font
 color="#ff0000">(back to top)</font></a></b></font><br>
<br>
<img alt="ortho" src="./help/ortho.png" align="left"
 height="404" hspace="30" width="133"><br>
<br>
You
can generate orthogonal (in plane) views of you main window at any
time, whatever type of data you are displaying.<br>
<br>
Press
<font color="#ff0000"><b>x</b></font>
in the main window or select the <font color="#ff0000"><b>ORTHO-VIEWS
ON / UPDATE</b></font>
button on the side
menu to create new views (these appear in a new pop-up window).<br>
<br>
Make
sure all the planes are visible by pressing <font color="#ff0000"><b>C</b></font>
(coronal), <font color="#ff0000"><b>A</b></font>
(axial) and <font color="#ff0000"><b>S</b></font>
(sagittal) in the main window or selecting the corresponding button
under MRI PLANES on the side menu.<br>
<br>
If the views do
not look correct, try pressing <font color="#ff0000"><b>r</b></font>
in the main window or clicking the <font color="#ff0000"><b>Reset
</b></font>button under MRI PLANES on the side menu. This
will reset the current zoom.<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<font color="#000066"><b><a
 name="Saving_images_out"></a>Saving
images out</b><b>&nbsp;
&nbsp; &nbsp; &nbsp;<a href="#top"><font
 color="#ff0000">(back to top)</font></a></b></font><br>
<br>
You
can save images of your current view(s) to .tif files at any time. The
image maker will save out the picture exactly as it appears on your
screen and will ask you where and under what name you would like the
file saved.<br>
<br>
Press <font color="#ff0000"><b>J</b></font>
in the main window or select the&nbsp;<font color="#ff0000"><b>Main
Window: save image</b></font>&nbsp;
button on the
side menu to save the main window.<br>
<br>
Press <font color="#ff0000"><b>j</b></font>
in the main window or select the&nbsp;<font color="#ff0000"><b>Ortho
Views: save image</b></font>&nbsp; button on the
side menu to save the ortho window.<br>
<br>
&nbsp;<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<font color="#000066"><b><a name="Snapping_planes"></a></b><b>Snapping
planes to a selected point&nbsp;
&nbsp; &nbsp; &nbsp;<a href="#top"><font
 color="#ff0000">(back to top)</font></a></b></font><br>
<br>
You
can make the x, y and z plane <i>snap </i>to any point on
the image planes easily.<br>
<br>
Simply hover your mouse
pointer over the spot in the image you want the planes to intersect at
and press <font color="#ff0000"><b>o&nbsp;</b></font><i>(lowercase
letter o)</i> in the main window.<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<br>
<font color="#000066"><b><a
 name="Keyboard_shortcuts"></a></b><b>Keyboard
shortcuts&nbsp;
&nbsp; &nbsp; &nbsp;<a href="#top"><font
 color="#ff0000">(back to top)</font></a></b></font><br>
<br>
<br>
Keyboard shortcuts can be called after clicking in the main window.<br>
<br>
Keyboard functiona are cAsE seNsitiVE so make sure you use the right
ones!<br>
<br>
<br>
<table border="1" cellpadding="2" cellspacing="2"
 width="100%">
  <tbody>
    <tr>
      <td colspan="1" rowspan="13" align="center"
 bgcolor="#ffff99"><b>Main Window</b></td>
      <td align="center" bgcolor="#ffff99"><font
 color="#000099"><b>r</b></font></td>
      <td bgcolor="#ffff99">Reset the zoom of the main
window</td>
    </tr>
    <tr>
      <td align="center" bgcolor="#ffff99"><font
 color="#000099"><b>o</b></font></td>
      <td bgcolor="#ffff99">Hover the mouse over a point
and press the <i>o</i>&nbsp;key to centre all 3 planes
on the point under the mouse pointer</td>
    </tr>
    <tr>
      <td align="center" bgcolor="#ffff99"><font
 color="#000099"><b>L</b></font></td>
      <td bgcolor="#ffff99">Reset the 3 planes to the
original orientation</td>
    </tr>
    <tr>
      <td align="center" bgcolor="#ffff99"><font
 color="#000099"><b>C</b></font></td>
      <td bgcolor="#ffff99">Switch the coronal slice on /
off</td>
    </tr>
    <tr>
      <td align="center" bgcolor="#ffff99"><font
 color="#000099"><b>A</b></font></td>
      <td bgcolor="#ffff99">Switch the axial slice on / off</td>
    </tr>
    <tr>
      <td align="center" bgcolor="#ffff99"><font
 color="#000099"><b>S</b></font></td>
      <td bgcolor="#ffff99">Switch the sagittal slice on /
off</td>
    </tr>
    <tr>
      <td align="center" bgcolor="#ffff99"><font
 color="#000099"><b>E</b></font></td>
      <td bgcolor="#ffff99">Switch the edges of the planes
on / off</td>
    </tr>
    <tr>
      <td align="center" bgcolor="#ffff99"><font
 color="#000099"><b>x</b></font></td>
      <td bgcolor="#ffff99">Create new / update current
orthogonal views</td>
    </tr>
    <tr>
      <td align="center" bgcolor="#ffff99"><font
 color="#000099"><b>j</b></font></td>
      <td bgcolor="#ffff99">Save the current orthogonal
view to a tif file</td>
    </tr>
    <tr>
      <td align="center" bgcolor="#ffff99"><font
 color="#000099"><b>J</b></font></td>
      <td bgcolor="#ffff99">Save the current main window
view to a tif file</td>
    </tr>
    <tr>
      <td align="center" bgcolor="#ffff99"><font
 color="#000099"><b>H</b></font></td>
      <td bgcolor="#ffff99">Cycle main window viewing angle</td>
    </tr>
    <tr>
      <td align="center" bgcolor="#ffff99"><font
 color="#000099"><b>z</b></font></td>
      <td bgcolor="#ffff99">Turn help file on</td>
    </tr>
    <tr>
      <td align="center" bgcolor="#ffff99"><font
 color="#000099"><b>q</b></font></td>
      <td bgcolor="#ffff99">Quit thye application (NB no
confirmation)</td>
    </tr>
    <tr>
      <td align="center"></td>
      <td align="center"></td>
      <td></td>
    </tr>
    <tr>
      <td colspan="1" rowspan="4" align="center"
 bgcolor="#ffff66"><b>Loading Data</b></td>
      <td align="center" bgcolor="#ffff66"><font
 color="#000099"><b>F</b></font></td>
      <td bgcolor="#ffff66">Load functional data -
Beamforming, fMRI or DTI Probability Distributions</td>
    </tr>
    <tr>
      <td align="center" bgcolor="#ffff66"><font
 color="#000099"><b>D</b></font></td>
      <td bgcolor="#ffff66">Load dipole files</td>
    </tr>
    <tr>
      <td align="center" bgcolor="#ffff66"><font
 color="#000099"><b>B</b></font></td>
      <td bgcolor="#ffff66">Load a brain - cortical surface</td>
    </tr>
    <tr>
      <td align="center" bgcolor="#ffff66"><font
 color="#000099"><b>T</b></font></td>
      <td bgcolor="#ffff66">Load DTI fiber data</td>
    </tr>
    <tr>
      <td align="center"></td>
      <td align="center"></td>
      <td></td>
    </tr>
    <tr>
      <td align="center" bgcolor="#ffff33"><b>Beamforming
/ fMRI<br>
in 2d-merged mode</b></td>
      <td align="center" bgcolor="#ffff33"><font
 color="#000099"><b>M</b></font></td>
      <td bgcolor="#ffff33">Switch between original
structural image and functional data</td>
    </tr>
    <tr>
      <td align="center"></td>
      <td align="center"></td>
      <td></td>
    </tr>
    <tr>
      <td colspan="1" rowspan="3" align="center"
 bgcolor="#ffff00"><b>Beamforming / fMRI<br>
in 3d isosurface mode</b></td>
      <td align="center" bgcolor="#ffff00"><font
 color="#000099"><b>f</b></font></td>
      <td bgcolor="#ffff00">Cycle through visible surfaces:<br>
&nbsp; &nbsp; &nbsp; positive and negative (default)<br>
&nbsp; &nbsp; &nbsp; positive only<br>
&nbsp; &nbsp; &nbsp; negative only<br>
&nbsp; &nbsp; &nbsp; none</td>
    </tr>
    <tr>
      <td align="center" bgcolor="#ffff00"><font
 color="#000099"><b>X</b></font></td>
      <td bgcolor="#ffff00">Make more surfaces visible (
lower threshold )</td>
    </tr>
    <tr>
      <td align="center" bgcolor="#ffff00"><font
 color="#000099"><b>Y</b></font></td>
      <td bgcolor="#ffff00">Make fewer surfaces visible (
raise threshold )</td>
    </tr>
    <tr>
      <td align="center"></td>
      <td align="center"></td>
      <td></td>
    </tr>
    <tr>
      <td colspan="1" rowspan="3" align="center"
 bgcolor="#ffcc33"><b>Dipoles</b></td>
      <td align="center" bgcolor="#ffcc33"><font
 color="#000099"><b>d</b></font></td>
      <td bgcolor="#ffcc33">Make the dipole visible /
invisible</td>
    </tr>
    <tr>
      <td bgcolor="#ffcc33"><font color="#000099"><b>Ctrl&nbsp;&lt;-
      </b></font></td>
      <td bgcolor="#ffcc33">Show the dipole position 1ms
earlier</td>
    </tr>
    <tr>
      <td bgcolor="#ffcc33"><font color="#000099"><b>Ctrl
-&gt;</b></font></td>
      <td bgcolor="#ffcc33">Show the dipole position 1ms
later</td>
    </tr>
    <tr>
      <td align="center"></td>
      <td></td>
      <td></td>
    </tr>
    <tr>
      <td colspan="1" rowspan="4" align="center"
 bgcolor="#ffcc00"><b>Cortex</b></td>
      <td align="center" bgcolor="#ffcc00"><b><font
 color="#000099">v</font></b></td>
      <td bgcolor="#ffcc00">Make the brain surface visible
/ invisible</td>
    </tr>
    <tr>
      <td align="center" bgcolor="#ffcc00"><b><font
 color="#000099">V</font></b></td>
      <td bgcolor="#ffcc00">Turn the surface cutter on /
off</td>
    </tr>
    <tr>
      <td align="center" bgcolor="#ffcc00"><font
 color="#000099"><b>b</b></font></td>
      <td bgcolor="#ffcc00">Fade the cortical surface out
(more transparent)</td>
    </tr>
    <tr>
      <td align="center" bgcolor="#ffcc00"><font
 color="#000099"><b>n</b></font></td>
      <td bgcolor="#ffcc00">Fade the corticla surface in
(less transparent)</td>
    </tr>
    <tr>
      <td align="center"></td>
      <td align="center"></td>
      <td></td>
    </tr>
    <tr>
      <td colspan="1" rowspan="5" align="center"
 bgcolor="#ff9900"><b>DTI</b></td>
      <td align="center" bgcolor="#ff9900"><font
 color="#000099"><b>g</b></font></td>
      <td bgcolor="#ff9900">Make all loaded fibers visible</td>
    </tr>
    <tr>
      <td align="center" bgcolor="#ff9900"><font
 color="#000099"><b>G</b></font></td>
      <td bgcolor="#ff9900">Hide all fibers</td>
    </tr>
    <tr>
      <td align="center" bgcolor="#ff9900"><font
 color="#000099"><b>h</b></font></td>
      <td bgcolor="#ff9900">Make the region of interest
selector visible</td>
    </tr>
    <tr>
      <td align="center" bgcolor="#ff9900"><font
 color="#000099"><b>t</b></font></td>
      <td bgcolor="#ff9900">Place the region of interest
selector at the point under the mouse pointer position</td>
    </tr>
    <tr>
      <td align="center" bgcolor="#ff9900"><font
 color="#000099"><b>s</b></font></td>
      <td bgcolor="#ff9900">Place the mouseover the region
of interest selector and press the <i>s</i> key to make
all fibers passing through this area visible</td>
    </tr>
  </tbody>
</table>
<br>
<br>
<br>
<!--
CHANGING OBJECT COLOURS (back to top)
Todo
Uncommented functions (todo)
q
d
O
x
C
A
S
f
L
E
H
p
g
G
6
7
8
9
Ctrl + 1
Ctrl + 2
Ctrl + 3
Ctrl + 4
Ctrl + 5
-->
<br>
<br>
<br>
<br>
</body>
</html>

'''

#end html content

    def __init__(self, parent):
        wx.Dialog.__init__(self, parent, -1, ' ynicDV3D Main window: Getting started ...',
                          pos=wx.Point(800, 25), size=(450, 600) )

        html = wx.html.HtmlWindow(self, -1)
        html.SetPage(self.help_html_text)
        #html.SetPage(./html_help/ynicDV3D_HTML_help.html)
        button = wx.Button(self, wx.ID_OK, "Close")
        
        # constraints for the html window
        lc = wx.LayoutConstraints()
        lc.top.SameAs(self, wx.Top, 0)
        lc.left.SameAs(self, wx.Left, 0)
        lc.bottom.SameAs(button, wx.Top, 0)
        lc.right.SameAs(self, wx.Right, 0)
        html.SetConstraints(lc)

        # constraints for the button
        lc = wx.LayoutConstraints()
        lc.bottom.SameAs(self, wx.Bottom, 5)
        lc.centreX.SameAs(self, wx.CentreX)
        lc.width.AsIs()
        lc.height.AsIs()
        button.SetConstraints(lc)
        
        self.SetAutoLayout(True)
        self.Layout()
        #self.CentreOnParent(wx.BOTH)


#----------------------------------------------------------------------

class ynicDV3DHelpApp(wx.App):
    def OnInit(self):
        frame = LoadHelpWindow(None)
        frame.Show(True)        
        self.SetTopWindow(frame)
        return True
    

    
#----------------------------------------------------------------------

if __name__ == '__main__':
    app = ynicDV3DHelpApp(0)
    app.MainLoop()

