import numpy as np
import time
from ynicKinectHandPositions import *


def checkHandPos(vtkScreenX, vtkScreenY, left_hand_pos, right_hand_pos):
    #print 'right_hand_pos', right_hand_pos
    #print 'left_hand_pos', left_hand_pos
    rhpx, rhpy = right_hand_pos.x, right_hand_pos.y
    lhpx, lhpy = left_hand_pos.x, left_hand_pos.y
    
    #current x/y are real world, scale to window pixel units
    #realWorld x range currently -1280 to 1280 -> wanted 0 to vtkScreenX
    rhpx_vtk = int(((rhpx + 640) / 1280)*vtkScreenX) #should be + 1280) / 2560 but we'll scale by 2
    lhpx_vtk = int(((lhpx + 640) / 1280)*vtkScreenX) #should be + 1280) / 2560 but we'll scale by 2
    
    #realWorld x range currently -960 to 960 -> wanted 0 to vtkScreenY
    rhpy_vtk = int(((rhpy+ 480) / 960)*vtkScreenY) #should be + 960) / 1920 but we'll scale by 
    lhpy_vtk = int(((lhpy + 480) / 960)*vtkScreenY) #should be + 960) / 1920 but we'll scale by    
    
    hand_diff = np.sqrt((lhpx_vtk-rhpx_vtk)**2 + (lhpy_vtk-rhpy_vtk)**2)
    return hand_diff, lhpx_vtk, lhpy_vtk, rhpx_vtk, rhpy_vtk


def checkButtonPress(renderer, left_hand_pos, right_hand_pos, lhpx_vtk, lhpy_vtk, rhpx_vtk, rhpy_vtk, vtkScreenX, vtkScreenY, prev_zoom, txtLeftHand, txtRightHand, renderWindow, combinedHands):
    #print rhpx_vtk, rhpy_vtk
    #if hand is near the right edge of screen in button region
    if vtkScreenX-rhpx_vtk<100:
        if vtkScreenY-rhpy_vtk<100:
            time.sleep(1) #give time to activate the button event
            if renderer.buttons[0][-1] == 0:
                renderer.buttons[0][1].VisibilityOn()
                renderer.buttons[0][-1] = 1
            else:
                renderer.buttons[0][1].VisibilityOff()
                renderer.buttons[0][-1] = 0    


def checkSetElevation(cam, renderer, prev_zoom, renderWindow, left_hand_pos, prev_left_hand_pos):
    try: #todo .. fix this .. it fails as prev_left_hand_pos is set to tuple type at outset
        if left_hand_pos.y > prev_left_hand_pos.y+3 and left_hand_pos.y < prev_left_hand_pos.y+25: #adjusts sensitivty
            print 'try down'
            cam.Elevation(-6)
            cam.OrthogonalizeViewUp()
            renderWindow.Render()
        elif left_hand_pos.y < prev_left_hand_pos.y-3  and left_hand_pos.y > prev_left_hand_pos.y-25:#adjusts sensitivty
            print 'try up'
            cam.Elevation(6)
            cam.OrthogonalizeViewUp()
            renderWindow.Render()
    except:
        pass


def checkSetAzimuth(cam, renderer, prev_zoom, renderWindow, right_hand_pos, prev_right_hand_pos):
    try: #todo .. fix this .. it fails as prev_left_hand_pos is set to tuple type at outset
        if right_hand_pos.x > prev_right_hand_pos.x+3 and right_hand_pos.x < prev_right_hand_pos.x+25:#adjusts sensitivty
            cam.Azimuth(-3)
            cam.OrthogonalizeViewUp()
            renderWindow.Render()
        elif right_hand_pos.x < prev_right_hand_pos.x-3  and right_hand_pos.x > prev_right_hand_pos.x-25:#adjusts sensitivty
            cam.Azimuth(3)
            cam.OrthogonalizeViewUp()
            renderWindow.Render()
    except:
        pass


def checkSetZoom(cam, renderer, renderWindow, right_hand_pos, prev_right_hand_pos):
    try: #todo .. fix this .. it fails as prev_left_hand_pos is set to tuple type at outset
        if right_hand_pos.z > prev_right_hand_pos.z+3 and right_hand_pos.z < prev_right_hand_pos.z+25:#adjusts sensitivty
            cam.Zoom(0.95)
        elif right_hand_pos.z < prev_right_hand_pos.z-3 and right_hand_pos.z > prev_right_hand_pos.z-25:#adjusts sensitivty
            cam.Zoom(1.05)
    except:
        pass


