#! /usr/bin/env python

# Copyright (C) 2011 Andre Gouws
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>

import sys
import time
from ConfigParser import SafeConfigParser
from collections import deque
import numpy as np
from OpenGL.GL import *
from OpenGL.GLUT import *
from OpenGL.GLU import *
from OSCeleton import *
import threading
import vtk
from ynicKinectHandActor import AddHandActor
from ynicKinectAlgorithms import *
from ynicKinectVTKObjects import *
from ynicKinectHandPositions import *
from ynicKinectAddVTKButtons import addButtons
from ynicKinectClippingFunctions import *

from numpy import *

#some pre-generated code snippet modules borrowed from DV3D
from dv3dNifti2VtkImageData import *
from dv3dAddLight import *

#----------------------------------
#some variables
global renderer, prev_zoom, renWin, txtLeftHand, txtRightHand, combinedHands, right_hand_pos, left_hand_pos, l_h_actor2d

SIZE_X = 160
SIZE_Y = 120
TARGET_SIZE = 0
REMOVE_AFTER = 200
usersTargets = []
server = OSCeleton(7110)
server.realWorld = True
frameCount = 0
users = {}
lastDisplayed = 0.0

vtkScreenX = 640
vtkScreenY = 480

left_hand_pos = (0,0,0)
right_hand_pos = (0,0,0)
prev_left_hand_pos = (0,0,0)
prev_right_hand_pos = (0,0,0)
prev_zoom = 1
#----------------------------------



## start of skeleton tracking / window code -----------------

class Player(Skeleton):
    """Holds a players data.  Inherits from Skeleton.
        
    Player.last is the time at which this player's joints were updated. 
    """
    
    def __init__(self, user_id):
        Skeleton.__init__(self, user_id)
        self.hits = 0
        self.last = 0.0
        
    def still_moving(self):
        """Tests whether the Player's joints have been updated recently"""
        return time.time() - self.last < REMOVE_AFTER
        
class Target(Point):
    """Stores target information"""
    def __init__(self, x, y, z):
        Point.__init__(self, x, y, z)
        self.baseJoint = ""
        self.middleJoint = ""
        self.hitJoint = ""
        self.calcLen = False

    
def getRGB(joint, colorRange = 800):
    """Returns a tuple with r, g and b color values based on joint's Z.
    
    Ugly but does the job, needs to be completely rewritten"""
    z = joint.z
    z = z % colorRange #smaller range gives more noticeable transitions
    subInterval = colorRange / 6.0
    rgb = [0, 0, 0]
    if z < subInterval:
        rgb[0] = 1.0
        rgb[1] = z / subInterval
    elif z < 2 * subInterval:
        rgb[1] = 1.0
        rgb[0] = (2 * subInterval - z) / subInterval
    elif z < 3 * subInterval:
        rgb[1] = 1.0
        rgb[2] = (z - 2 * subInterval) / subInterval
    elif z < 4 * subInterval:
        rgb[2] = 1.0
        rgb[1] = (4 * subInterval - z) / subInterval
    elif z < 5 * subInterval:
        rgb[2] = 1.0
        rgb[0] = (z - 4 * subInterval) / subInterval
    else:
        rgb[0] = 1
        rgb[2] = (colorRange - z) / subInterval
    return tuple(rgb)


def drawLine(player, jointLabel1, jointLabel2):
    global left_hand_pos, right_hand_pos, prev_left_hand_pos, prev_right_hand_pos
    """Accepts a skeleton and two joint labels.
    Draws a colored line between the skeleton's two joints that have the desired labels"""
    
    if (jointLabel1, jointLabel2) in player:
        joint1 = player[jointLabel1]
        joint2 = player[jointLabel2]
        if jointLabel2 == 'l_hand':
            prev_left_hand_pos = left_hand_pos #before assigning the new value keep track of previous
            left_hand_pos = joint2
        if jointLabel2 == 'r_hand':
            prev_right_hand_pos = right_hand_pos #before assigning the new value keep track of previous
            right_hand_pos = joint2	
        
        r, g, b = getRGB(joint1)
        glColor3f(r, g, b)
        glVertex3f(joint1.x, joint1.y, joint1.z)
        r, g, b = getRGB(joint2)
        glColor3f(r, g, b)
        glVertex3f(joint2.x, joint2.y, joint2.z)
            
def glutIdle():
    """Registered as GlutIdleFunc.
    
    Catches server events, adds and removes users and loads newest Skeletons"""
    global frameCount, users
    server.run()
    if server.frames > frameCount or server.lostUsers:
        if server.lostUsers:
            try:
                for each in server.lostUsers:
                    del users[each]
                    glutPostRedisplay()
            except KeyError:
                pass
            del server.lostUsers[:]
        for player in server.get_new_skeletons():
            if player.id not in users:
                users[player.id] = Player(player.id)
            users[player.id].joints = player.copy_joints()
            users[player.id].last = time.time()
            frameCount = server.frames
            glutPostRedisplay()
    elif time.time() - lastDisplayed > REMOVE_AFTER:
        glutPostRedisplay()


def drawPlayers():
    """Draws lines connecting available joints for every player in users"""
    glBegin(GL_LINES)
    for player in users.values():
        if player.still_moving():
            drawLine(player, HEAD, NECK)
            drawLine(player, NECK, TORSO)
            drawLine(player, LEFT_SHOULDER, LEFT_HIP)
            drawLine(player, RIGHT_SHOULDER, RIGHT_HIP)
            drawLine(player, LEFT_HIP, RIGHT_HIP)
            drawLine(player, LEFT_HIP, LEFT_KNEE)
            drawLine(player, LEFT_KNEE, LEFT_FOOT)
            drawLine(player, RIGHT_HIP, RIGHT_KNEE)
            drawLine(player, RIGHT_KNEE, RIGHT_FOOT)
            drawLine(player, LEFT_SHOULDER, RIGHT_SHOULDER)
            drawLine(player, LEFT_SHOULDER, LEFT_ELBOW)
            drawLine(player, LEFT_ELBOW, LEFT_HAND)   
            drawLine(player, RIGHT_SHOULDER, RIGHT_ELBOW)
            drawLine(player, RIGHT_ELBOW, RIGHT_HAND)
    glEnd()
 
    
def getPlayersOrientation(player):
    """Determines a users orientation.
    
    Accepts a Skeleton and returns a Point.
    
    Calculates orientation by using 3 points to create two vectors
    and then cross multiplies those vectors to find a vector perpindicular to both"""
    if (TORSO, LEFT_SHOULDER, RIGHT_SHOULDER) in player:
        torso = player[TORSO]
        tl = player[LEFT_SHOULDER] - player[TORSO]
        tr = player[RIGHT_SHOULDER] - player[TORSO]
        tl.normalize()
        tr.normalize()
        orientationArray = np.cross(tr.vals(), tl.vals())
        orientation = Point(orientationArray[0], orientationArray[1], orientationArray[2]) 
        orientation.normalize()
    else:
        orientation = Point(1, 1, 1)
        orientation.normalize()
    return orientation


def glutDisplay():
    """Registered as GlutDisplayFunc.  Calls all drawing functions"""
    global last_displayed
    lastDisplayed = time.time()
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)
    glMatrixMode(GL_PROJECTION)
    glShadeModel(GL_SMOOTH)
    glLineWidth(5)
    glLoadIdentity()
    drawPlayers()
    glFlush()
    glutSwapBuffers()


def runSkeletonWindow():
    if len(sys.argv) > 1:
        iniFile = sys.argv[1]
    else:
        iniFile = "generic.ini"
    #getTargets(iniFile)
    glutInit(sys.argv)
    glutInitDisplayMode(GLUT_RGB | GLUT_DOUBLE | GLUT_DEPTH)
    glutInitWindowSize(SIZE_X, SIZE_Y)
    glutCreateWindow("mySkeleton")
    glOrtho(-1280, 1280, -960, 960, 0, 10000)
    glEnable(GL_DEPTH_TEST)
    glutDisplayFunc(glutDisplay)
    glutIdleFunc(glutIdle)
    glLineWidth(5)
    glutMainLoop()

## end of skeleton tracking / window code -----------------

global iren, box_bounds, point, pointWidget, box, scalpbox, skullbox, cortexbox, planeWidgetX, planeWidgetY, planeWidgetZ, x_distance, y_distance, z_distance


def pwInteraction(obj, event):
    global box, scalpbox, skullbox, cortexbox, planeWidgetX, planeWidgetY, planeWidgetZ, x_distance, y_distance, z_distance, point, pointWidget, glyphActor, box, box_bounds,planeWidgetX,planeWidgetY,planeWidgetZ
    obj.GetPolyData(point)
    c_bounds = pointWidget.GetPosition()
    box_bounds = (c_bounds[0]-x_distance, c_bounds[0]+x_distance+50, \
                    c_bounds[1]-y_distance-50, c_bounds[1]+y_distance, \
                    c_bounds[2]-z_distance-50, c_bounds[2]+z_distance)
    
    box.SetBounds(box_bounds)
    box.Modified()
    try:
        scalpbox.SetBounds(box_bounds)
        scalpbox.Modified()
        skullbox.SetBounds(box_bounds)
        skullbox.Modified()
        cortexbox.SetBounds(box_bounds)
        cortexbox.Modified()
    except:
        pass
    
    xpos = (box_bounds[1]-1,box_bounds[1]-1, box_bounds[2],box_bounds[3], box_bounds[4],box_bounds[5])

    ypos = (box_bounds[0],box_bounds[1], box_bounds[2]+1,box_bounds[2]+1, box_bounds[4],box_bounds[5])

    zpos = (box_bounds[0],box_bounds[1], box_bounds[2],box_bounds[3], box_bounds[4]+1,box_bounds[4]+1)

    planeWidgetX.PlaceWidget(xpos)
    planeWidgetY.PlaceWidget(ypos)
    planeWidgetZ.PlaceWidget(zpos)


def myKeyEvents(obj, event):
    key = obj.GetKeySym()
    if key == "l":
        print 'l'
        cortexMapper.SetInput(cortexReader.GetOutput())
        planeWidgetX.Off(); planeWidgetY.Off(); planeWidgetZ.Off()
        print ren.GetDisplayPoint()
    elif key == "k":
        print 'k'
        cortexMapper.SetInput(cortexClipper.GetOutput())
        skullMapper.SetInput(skullClipper.GetOutput())
        planeWidgetX.On(); planeWidgetY.On(); planeWidgetZ.On()
    elif key == "x":
        skullMapper.SetInput(skullReader.GetOutput())
        cortexMapper.SetInput(cortexReader.GetOutput())
        planeWidgetX.Off(); planeWidgetY.Off(); planeWidgetZ.Off()
    elif key == "y":
        skullMapper.SetInput(skullClipper.GetOutput())
        cortexMapper.SetInput(cortexReader.GetOutput())
        planeWidgetX.Off(); planeWidgetY.Off(); planeWidgetZ.Off()
    renderer.Render()


def resizePlanes(arg1, arg2):
    global box_bounds, planeWidgetX, planeWidgetY, planeWidgetZ
    x1 = planeWidgetX.GetPoint1()
    x2 = planeWidgetX.GetPoint2()
    y1 = planeWidgetY.GetPoint1()
    y2 = planeWidgetY.GetPoint2()
    z1 = planeWidgetZ.GetPoint1()
    z2 = planeWidgetZ.GetPoint2()
    xpos = (box_bounds[1],box_bounds[1], box_bounds[2],box_bounds[3], box_bounds[4],box_bounds[5])
    ypos = (box_bounds[0],box_bounds[1], box_bounds[2],box_bounds[2], box_bounds[4],box_bounds[5])
    zpos = (box_bounds[0],box_bounds[1], box_bounds[2],box_bounds[3], box_bounds[4],box_bounds[4])
    planeWidgetX.PlaceWidget(xpos)
    planeWidgetY.PlaceWidget(ypos)
    planeWidgetZ.PlaceWidget(zpos)

def doTheVTKStuff():
    global iren, box_bounds, point, pointWidget, box, scalpbox, skullbox, cortexbox, planeWidgetX, planeWidgetY, planeWidgetZ, x_distance, y_distance, z_distance, renderer, prev_zoom, renWin, left_hand_pos, right_hand_pos, prev_left_hand_pos, prev_right_hand_pos, txtLeftHand, txtRightHand, combinedHands, l_h_actor2d

    ## ---------------------------------------
    #Add the brain data


    try:
        vol, x, y, bounds, x_slice_pos, y_slice_pos, z_slice_pos, srow_x, srow_y, srow_z, spacing = nifti2vtkImageData('./anatomy/MNI_structural.nii.gz')
    except:
        vol, x, y, bounds, x_slice_pos, y_slice_pos, z_slice_pos, srow_x, srow_y, srow_z, spacing = nifti2vtkImageData('/home/andre/andre_svn/trunk/DV3D_BetaDist/DV3D_v0.547/DV3D_essentials/MNI_structural.nii.gz')    

    #print bounds

    # lets assume the viewing angle will alway be from the front-left of the head
    # no lets har code some bounds for our imageplanes accordingly

    x_edge, y_edge, z_edge = bounds[0], bounds[2], bounds[4]


    #vol, x, y, bounds, x_slice_pos, y_slice_pos, z_slice_pos, srow_x, srow_y, srow_z, spacing = nifti2vtkImageData('./DV3D_essentials/talairach_in_MNI.nii.gz')


    ########

    vol.Update()
    print vol.GetOutput()

    #do some calculations to restrict our cutting
    gb = vol.GetOutput().GetBounds()
    x_distance = (gb[1]-gb[0])/2.0
    y_distance = (gb[3]-gb[2])/2.0
    z_distance = (gb[5]-gb[4])/2.0

    # Create the standard renderer, render window and interactor
    renderer = vtk.vtkRenderer()
    renWin = vtk.vtkRenderWindow()
    renWin.SetSize(600,600)
    renWin.AddRenderer(renderer)
    iren = vtk.vtkRenderWindowInteractor()
    iren.SetRenderWindow(renWin)
    iren.SetInteractorStyle(vtk.vtkInteractorStyleTrackballCamera())

    #plane lookuptables
    lu = vtk.vtkLookupTable()
    lu.SetNumberOfTableValues(256)
    lu.SetTableRange(25,200)
    #lu.ForceBuild()
    for i in range(256):
        if i <25 :
            lu.SetTableValue(i, (i/255.,i/255.0,i/255.0,0.0))
        elif i <230 :
            lu.SetTableValue(i, (i/400.,i/400.0,i/400.0,1.0))
        else:
            lu.SetTableValue(i, (1.0,1.0,1.0,1.0))
    lu.Build()
    lu.SetTableValue(0, (0.0,0.0,0.0,0.0))


    #IPWs
    # The shared picker enables us to use 3 planes at one time
    # and gets the picking order right
    picker = vtk.vtkCellPicker()
    picker.SetTolerance(0.005)

    # The 3 image plane widgets are used to probe the dataset.
    planeWidgetX = vtk.vtkImagePlaneWidget()
    planeWidgetX.DisplayTextOn()
    planeWidgetX.SetInput(vol.GetOutput())
    planeWidgetX.SetPlaneOrientationToXAxes()
    planeWidgetX.SetSliceIndex(32)
    planeWidgetX.SetPicker(picker)
    planeWidgetX.SetKeyPressActivationValue("x")
    planeWidgetX.SetLookupTable(lu)
    prop1 = planeWidgetX.GetPlaneProperty()
    prop1.SetOpacity(0.0)

    planeWidgetY = vtk.vtkImagePlaneWidget()
    planeWidgetY.DisplayTextOn()
    planeWidgetY.SetInput(vol.GetOutput())
    planeWidgetY.SetPlaneOrientationToYAxes()
    planeWidgetY.SetSliceIndex(32)
    planeWidgetY.SetPicker(picker)
    planeWidgetY.SetKeyPressActivationValue("y")
    planeWidgetY.SetLookupTable(lu)
    prop2 = planeWidgetY.GetPlaneProperty()
    prop2.SetOpacity(0.0)
    planeWidgetY.SetLookupTable(planeWidgetX.GetLookupTable())


    # for the z-slice, turn off texture interpolation:
    # interpolation is now nearest neighbour, to demonstrate
    # cross-hair cursor snapping to pixel centers
    planeWidgetZ = vtk.vtkImagePlaneWidget()
    planeWidgetZ.DisplayTextOn()
    planeWidgetZ.SetInput(vol.GetOutput())
    planeWidgetZ.SetPlaneOrientationToZAxes()
    planeWidgetZ.SetSliceIndex(46)
    planeWidgetZ.SetPicker(picker)
    planeWidgetZ.SetKeyPressActivationValue("z")
    planeWidgetZ.SetLookupTable(lu)
    prop3 = planeWidgetZ.GetPlaneProperty()
    prop3.SetOpacity(0.0)
    planeWidgetZ.SetLookupTable(planeWidgetX.GetLookupTable())

    #-----------------------------------------------------------------
    #prepare a box to use as our implicit cutter
    box = vtk.vtkBox()

    #-----------------------------------------------------------------


    #-----------------------------------------------------------------
    #load some .vtk surfaces with a naming loop
    # get MH to show me an alternative way of naming here

    surfs =  [['amygdala', './anatomy/Amygdala.vtk', (0, 1, 0), 1],
            ['brainstem', './anatomy/Brainstem.vtk', (0.2,  0.2, 1), 1],
            ['thalamus', './anatomy/Thalamus.vtk', (1,  0,  0), 1],
            ['ventricles', './anatomy/Ventricles.vtk', (0,  1,  1), 1],
            ['hippocampus', './anatomy/Hippocampus.vtk', (1, 1,  0), 1],
            ['cortex', './anatomy/Cortex_3mm.vtk', (0.98,  0.12,  0.12), 0.3],
            ['skull', './anatomy/Skull.vtk', (0.95, 0.95, 0.95), 0.2],
            ['scalp', './anatomy/Scalp.vtk', (0.9,  0.8,  0.3), 0.1]]


    for i in surfs:
        exec('%sbox = vtk.vtkBox()' %i[0])
        exec('%sReader = vtk.vtkPolyDataReader()' %i[0])
        exec('%sReader.SetFileName(i[1])' %i[0])
        exec('%sReader.Update()' %i[0])

        exec('%sClipper = vtk.vtkClipPolyData()' %i[0])
        exec('%sClipper.SetInput(%sReader.GetOutput())' %(i[0], i[0]))
        exec('%sClipper.SetClipFunction(%sbox)' %(i[0], i[0]))
        #exec('%sClipper.GenerateClipScalarsOn()' %i[0])
        exec('%sClipper.GenerateClippedOutputOff()' %i[0])
        
        exec('%sMapper = vtk.vtkPolyDataMapper()' %i[0])
        exec('%sMapper.SetInput(%sClipper.GetOutput())' %(i[0], i[0]))
        exec('%sMapper.ScalarVisibilityOff()' %i[0])

        exec('%sActor = vtk.vtkActor()' %i[0])
        exec('%sActor.SetMapper(%sMapper)' %(i[0], i[0]))
        exec('%sActor.GetProperty().SetColor(i[2])' %i[0])
        exec('%sActor.GetProperty().SetOpacity(i[3])' %i[0])
        exec('renderer.AddActor(%sActor)' %i[0])


    #-----------------------------------------------------------------


    print scalpMapper.GetCenter()



    #-----------------------------------------------------------------
    #----Now we add a point widgte that can be dragged around to 
    # define the centre of our cutting box 
    # The plane widget is used probe the dataset.
    vol2 = vtk.vtkImageData()
    vol2.DeepCopy(vol.GetOutput())
    vol2.SetOrigin(-90,108,90)

    pointWidget = vtk.vtkPointWidget()
    pointWidget.SetInput(vol2)
    pointWidget.AllOn()
    pointWidget.PlaceWidget()
    #pointWidget.PlaceWidget(10,10,100,100,100,100)
    point = vtk.vtkPolyData()
    pointWidget.GetPolyData(point)
    pointWidget.SetPriority(1)
    pointWidget.ZShadowsOff()
    pointWidget.GetProperty().SetOpacity(0.01)
    pointWidget.GetSelectedProperty().SetOpacity(0.01)
    #pointWidget.GetProperty().SetLineWidth(0)

    probe = vtk.vtkProbeFilter()
    probe.SetInput(point)
    probe.SetSource(vol.GetOutput())

    # create glyph
    cone = vtk.vtkSphereSource()
    cone.SetRadius(10)
    #cone.SetHeight(20)
    #cone.SetResolution(16)
    glyph = vtk.vtkGlyph3D()
    glyph.SetInputConnection(probe.GetOutputPort())
    glyph.SetSource(cone.GetOutput())
    glyph.SetVectorModeToUseVector()
    glyph.SetScaleModeToDataScalingOff()
    #glyph.SetScaleFactor(pl3d.GetOutput().GetLength()*0.1)
    glyphMapper = vtk.vtkPolyDataMapper()
    glyphMapper.SetInputConnection(glyph.GetOutputPort())
    glyphActor = vtk.vtkActor()
    glyphActor.SetMapper(glyphMapper)

    # Associate the line widget with the interactor
    pointWidget.SetInteractor(iren)
    #pointWidget.AddObserver("EnableEvent", pwInteraction)
    pointWidget.AddObserver("StartInteractionEvent", pwInteraction)
    pointWidget.AddObserver("InteractionEvent", pwInteraction)
    pointWidget.TranslationModeOn()
    #pointWidget.On()
    pointWidget.Modified()
    #-----------------------------------------------------------------

    iren.AddObserver("KeyPressEvent", myKeyEvents)

    #-----------------------------------------------------------------

    #resizePlanes(1,2)

    planeWidgetX.SetInteractor(iren)
    planeWidgetX.On()
    planeWidgetX.SetInteraction(0) #stop users messing with it directly
    planeWidgetY.SetInteractor(iren)
    planeWidgetY.On()
    planeWidgetY.SetInteraction(0) #stop users messing with it directly
    planeWidgetZ.SetInteractor(iren)
    planeWidgetZ.On()
    planeWidgetZ.SetInteraction(0) #stop users messing with it directly

    #-----------------------------------------------------------------
    # Add the actors to the renderer, set the background and size
    #ren.AddActor(surf)
    renderer.AddActor(glyphActor)

    #-----------------------------------------------------------------

    ##Add some hard-coded lights - this seems to help with depth sorting
    ## by the renderer
    #AddMainLights(renderer)



    ## ---------------------------------------

    
    #Create a mapper and actor for the left hand
    txtLeftHand = AddHandActor((30,30), './icons/left_hand.jpg')
    txtRightHand = AddHandActor((vtkScreenX-30,30), './icons/right_hand.jpg')
    combinedHands = AddHandActor((vtkScreenX/2,30), './icons/both_hand.jpg')

    renWin.AddRenderer(renderer);

    #add some buttons first so they are in the background
    addButtons(renderer, vtkScreenX, vtkScreenY)

    #Add the actors to the scene
    #renderer.AddActor(actorBrain)
    renderer.AddActor(txtLeftHand)
    renderer.AddActor(txtRightHand)
    renderer.AddActor(combinedHands) 
    renderer.SetBackground(1,1,1) # Background color white
        
    ##rw = renWinInteractor.GetRenderWindow()
    renWin.SetSize(vtkScreenX, vtkScreenY)
    
    cam = renderer.GetActiveCamera()

    #----Now start your engines!--------------------------------------
    iren.Initialize()
    renWin.Render()
    act_center = scalpMapper.GetCenter()
    cam.SetFocalPoint(scalpMapper.GetCenter())
    orig_pos = cam.GetPosition()
    cam.SetPosition(orig_pos[0]+10*act_center[0], orig_pos[1]+10*act_center[1], orig_pos[2])
    cam.Modified()
    renWin.Render()
    pointWidget.InvokeEvent("InteractionEvent")
    renWin.Render()
    iren.Start()
    print 'running'

    #here we run our algorithms that control the movement gesture input
    while True:
        time.sleep(0.05) #loops just don't seem to work without this .. time to tal superMark
        if left_hand_pos != (0,0,0): #not tuple basically
            #first lets see where the hands are
            hand_diff, lhpx_vtk, lhpy_vtk, rhpx_vtk, rhpy_vtk = checkHandPos(vtkScreenX, vtkScreenY, left_hand_pos, right_hand_pos)
            #print hand_diff
            if hand_diff > 100: #the hands are separate in the window
                #update the hand actor positions
                updateIndividualHandPos(lhpx_vtk, lhpy_vtk, rhpx_vtk, rhpy_vtk, renderer, prev_zoom, renWin, right_hand_pos, left_hand_pos, txtLeftHand, txtRightHand, combinedHands)
                #check if the user made a horz sweep with the right hand
                checkSetAzimuth(cam, renderer, prev_zoom, renWin, right_hand_pos, prev_right_hand_pos)
                #check if the user made a vert sweep with the left right hand                
                checkSetElevation(cam, renderer, prev_zoom, renWin, left_hand_pos, prev_left_hand_pos)
                #check if the users hands are over buttons
                checkButtonPress(renderer, left_hand_pos, right_hand_pos, lhpx_vtk, lhpy_vtk, rhpx_vtk, rhpy_vtk, vtkScreenX, vtkScreenY, prev_zoom, txtLeftHand, txtRightHand, renWin, combinedHands)
            else:
                #the hands are together
                updateCombinedHandPos(lhpx_vtk, lhpy_vtk, rhpx_vtk, rhpy_vtk, renderer, prev_zoom, renWin, right_hand_pos, left_hand_pos, txtLeftHand, txtRightHand, combinedHands, )
                checkSetZoom(cam, renderer, renWin, right_hand_pos, prev_right_hand_pos)
        else:
            pass





if __name__ == "__main__":
    #doTheVTKStuff()
    global iren
    t = threading.Thread(target=doTheVTKStuff, kwargs={})
    t.start()
    runSkeletonWindow()
    #t2 = threading.Thread(target=runSkeletonWindow, kwargs={})
    #t2.start()
    
    
    
    





