#!/usr/bin/env python
# -*- coding: utf-8 -*-
#===============================================================================
#
# test.py
#
# Test program for the simple GL Viewer.
#
# Copyright (c) 2011, Arne Schmitz <arne.schmitz@gmx.net>
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#     * Neither the name of the <organization> nor the
#       names of its contributors may be used to endorse or promote products
#       derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
# DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
# ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#===============================================================================

import sys
from PyQt4 import QtGui
from PyGLWidget import PyGLWidget
from OpenGL.GL import *


#===============================================================================
#===============================================================================
#===============================================================================

#---------------
#from PyQt4 import QtCore, QtGui
from PyQt4.QtGui import QApplication
import vtk
from vtk.qt4.QVTKRenderWindowInteractor import QVTKRenderWindowInteractor
import sys
#---------------


class Ui_MainWindow(object):
    def setupUi(self, MainWindow):
        MainWindow.setObjectName("MainWindow")
        MainWindow.resize(603, 553)
        self.centralWidget = QtGui.QWidget(MainWindow)
        #self.centralWidget2 = QtGui.QWidget(MainWindow)
        self.gridlayout = QtGui.QGridLayout(self.centralWidget)
        self.vtkWidget = QVTKRenderWindowInteractor(self.centralWidget)
        self.vtkWidget2 = QVTKRenderWindowInteractor(self.centralWidget)
        self.gridlayout.addWidget(self.vtkWidget, 0, 0, 1, 1)
        self.gridlayout.addWidget(self.vtkWidget2, 1, 0, 1, 1)
        MainWindow.setCentralWidget(self.centralWidget)

class SimpleView(QtGui.QMainWindow):

    def __init__(self, parent = None):
        QtGui.QMainWindow.__init__(self, parent)
        self.ui = Ui_MainWindow()
        self.ui.setupUi(self)
        self.ren = vtk.vtkRenderer()
        self.ui.vtkWidget.GetRenderWindow().AddRenderer(self.ren)
        iren = self.ui.vtkWidget.GetRenderWindow().GetInteractor()
        iren2 = self.ui.vtkWidget2.GetRenderWindow().GetInteractor()
        self.ren2 = vtk.vtkRenderer()
        self.ui.vtkWidget2.GetRenderWindow().AddRenderer(self.ren2)
        cube = vtk.vtkCubeSource()
        cube.SetXLength(200)
        cube.SetYLength(200)
        cube.SetZLength(200)
        cube.Update()
        cm = vtk.vtkPolyDataMapper()
        cm.SetInputConnection(cube.GetOutputPort())
        ca = vtk.vtkActor()
        ca.SetMapper(cm)
        self.ren.AddActor(ca)

        cube2 = vtk.vtkCubeSource()
        cube2.SetXLength(200)
        cube2.SetYLength(200)
        cube2.SetZLength(200)
        cube2.Update()
        cm2 = vtk.vtkPolyDataMapper()
        cm2.SetInputConnection(cube2.GetOutputPort())
        ca2 = vtk.vtkActor()
        ca2.SetMapper(cm2)
        self.ren2.AddActor(ca2)

        self.axesActor = vtk.vtkAnnotatedCubeActor();
        self.axesActor.SetXPlusFaceText('R')
        self.axesActor.SetXMinusFaceText('L')
        self.axesActor.SetYMinusFaceText('H')
        self.axesActor.SetYPlusFaceText('F')
        self.axesActor.SetZMinusFaceText('P')
        self.axesActor.SetZPlusFaceText('A')
        self.axesActor.GetTextEdgesProperty().SetColor(1,1,0)
        self.axesActor.GetTextEdgesProperty().SetLineWidth(2)
        self.axesActor.GetCubeProperty().SetColor(0,0,1)
        self.axes = vtk.vtkOrientationMarkerWidget()
        self.axes.SetOrientationMarker(self.axesActor)
        self.axes.SetInteractor(iren)
        self.axes.EnabledOn()
        self.axes.InteractiveOn()
        self.ren.ResetCamera()
        iren2.Start()
        iren.Start()
        print 'here'



#===============================================================================
#===============================================================================
#===============================================================================




#===============================================================================

class testGLWidget(PyGLWidget):
    def paintGL(self):
        PyGLWidget.paintGL(self)
        glBegin(GL_TRIANGLES)
        glColor3f(1,0,0)
        glVertex3f(0,0,0)
        glColor3f(0,1,0)
        glVertex3f(0,1,0)
        glColor3f(0,0,1)
        glVertex3f(1,1,0)
        glEnd()

#===============================================================================
# Main
#===============================================================================

app = QtGui.QApplication(sys.argv)
mainWindow = testGLWidget()
mainWindow.show()
mainWindow.raise_() # Need this at least on OS X, otherwise the window ends up in background
window = SimpleView()
window.show()
window.raise_()
sys.exit(app.exec_())

#===============================================================================
#
# Local Variables:
# mode: Python
# indent-tabs-mode: nil
# End:
#
#===============================================================================
