#ynicKinectHandPositions
import numpy as np

def updateIndividualHandPos(lhpx_vtk, lhpy_vtk, rhpx_vtk, rhpy_vtk, renderer, prev_zoom, renderWindow, right_hand_pos, left_hand_pos, txtLeftHand, txtRightHand, combinedHands):
    txtLeftHand.SetDisplayPosition(lhpx_vtk, lhpy_vtk)
    txtRightHand.SetDisplayPosition(rhpx_vtk, rhpy_vtk)
    combinedHands.SetDisplayPosition(np.mean([lhpx_vtk, rhpx_vtk]), np.mean([lhpy_vtk, rhpy_vtk]))
    txtLeftHand.VisibilityOn()
    txtRightHand.VisibilityOn()
    combinedHands.VisibilityOff()
    renderWindow.Render()

def updateCombinedHandPos(lhpx_vtk, lhpy_vtk, rhpx_vtk, rhpy_vtk, renderer, prev_zoom, renderWindow, right_hand_pos, left_hand_pos, txtLeftHand, txtRightHand, combinedHands):
    txtLeftHand.SetDisplayPosition(lhpx_vtk, lhpy_vtk)
    txtRightHand.SetDisplayPosition(rhpx_vtk, rhpy_vtk)
    combinedHands.SetDisplayPosition(np.mean([lhpx_vtk, rhpx_vtk]), np.mean([lhpy_vtk, rhpy_vtk]))
    txtLeftHand.VisibilityOff()
    txtRightHand.VisibilityOff()
    combinedHands.VisibilityOn()
    renderWindow.Render()
