import vtk

def AddHandActorOld(start_position, my_label, my_color):
    Hand = vtk.vtkTextActor()
    Hand.SetInput(my_label)
    txtprop=Hand.GetTextProperty()
    txtprop.SetFontFamilyToArial()
    txtprop.SetFontSize(40)
    txtprop.SetColor(my_color)
    Hand.SetDisplayPosition(start_position[0],start_position[1])

    return Hand


def AddHandActor(start_position, my_base_image):

    reader = vtk.vtkJPEGReader()
    reader.SetFileName(my_base_image)
    reader.Update()

    y = vtk.vtkImageMapper()
    y.SetInput(reader.GetOutput())
    y.SetColorWindow(255)
    y.SetColorLevel(127.5)
    y.Update()

    Hand = vtk.vtkActor2D()
    Hand.SetMapper(y)
    
    return Hand