import vtk

def generateActor(infile, my_color, my_opacity):
    box = vtk.vtkBox()
    Reader = vtk.vtkPolyDataReader()
    Reader.SetFileName(infile)
    Reader.Update()

    Clipper = vtk.vtkClipPolyData()
    Clipper.SetInput(Reader.GetOutput())
    Clipper.SetClipFunction(box)
    Clipper.GenerateClippedOutputOff()
                
    Mapper = vtk.vtkPolyDataMapper()
    Mapper.SetInput(Clipper.GetOutput())
    Mapper.ScalarVisibilityOff()

    Actor = vtk.vtkActor()
    Actor.SetMapper(Mapper)
    Actor.GetProperty().SetColor(my_color)
    Actor.GetProperty().SetOpacity(my_opacity)
    return Actor, box, Mapper, Clipper, Reader

