import vtk

def CreateVTKPolyDataSurface(vertex_file):
    try_me = vtk.vtkPolyDataReader()
    try_me.SetFileName(vertex_file)    

    mn_PolyData = try_me.GetOutput()
    mn_PolyData.Update()

    t = vtk.vtkSmoothPolyDataFilter()
    t.SetNumberOfIterations(10)
    t.SetInput(mn_PolyData)
    t.Update()

    mn_PolyData = t.GetOutput()
    mn_PolyData.Update()
    
    mn_Mapper = vtk.vtkPolyDataMapper()
    mn_Mapper.ImmediateModeRenderingOn()
    mn_Mapper.SetInput(mn_PolyData)
    mn_Mapper.ScalarVisibilityOff()
    
    mn_Mapper.Update()
    my_mnorm_brain = vtk.vtkLODActor()
    my_mnorm_brain.SetMapper(mn_Mapper)
        
    my_mnorm_brain.GetProperty().SetColor(1.0,0.2,0.2)
    return my_mnorm_brain, mn_Mapper