import vtk

def addButtons(renderer, vtkScreenX, vtkScreenY):
    
    button_list = [["./icons/brain.jpg", "./icons/brain1.jpg", [100,100]],
                    ["./icons/skeleton.jpg", "./icons/skeleton1.jpg", [100,200]],
                    ["./icons/rotate.jpg", "./icons/rotate1.jpg", [100,400]],
                    ["./icons/scissors.jpg", "./icons/scissors1.jpg", [100,500]],
                    ]
    
    renderer.buttons = [];
    
    for i in button_list:
        on_reader = vtk.vtkJPEGReader()
        on_reader.SetFileName(i[0])
        on_reader.Update()

        onMapper = vtk.vtkImageMapper()
        onMapper.SetInput(on_reader.GetOutput())
        onMapper.SetColorWindow(255)
        onMapper.SetColorLevel(127.5)
        onMapper.Update()

        button_on_actor = vtk.vtkActor2D()
        button_on_actor.SetMapper(onMapper)
        button_on_actor.SetPosition(vtkScreenX-i[2][0], vtkScreenY-i[2][1])
        button_on_actor.VisibilityOff()
        #img.SetPosition2(vtkScreenX, vtkScreenY)

        off_reader = vtk.vtkJPEGReader()
        off_reader.SetFileName(i[1])
        off_reader.Update()

        offMapper = vtk.vtkImageMapper()
        offMapper.SetInput(off_reader.GetOutput())
        offMapper.SetColorWindow(255)
        offMapper.SetColorLevel(127.5)
        offMapper.Update()

        button_off_actor = vtk.vtkActor2D()
        button_off_actor.SetMapper(offMapper)
        button_off_actor.SetPosition(vtkScreenX-i[2][0], vtkScreenY-i[2][1])
        #img.SetPosition2(vtkScreenX, vtkScreenY)

        if i < 1:
            renderer.buttons.append([button_off_actor, button_on_actor, 1])
        else:        
            renderer.buttons.append([button_off_actor, button_on_actor, 0])
        renderer.AddActor2D(renderer.buttons[-1][0])
        renderer.AddActor2D(renderer.buttons[-1][1])


