#! /usr/bin/env python

#===============================================================================
import sys
from PyQt4 import QtGui
from PyGLWidget import PyGLWidget
from OpenGL.GL import *


import threading
from numpy import *

#some pre-generated code snippet modules borrowed from DV3D
from dv3dNifti2VtkImageData import *
from dv3dAddLight import *
from generateActor import generateActor

#---------------
#from PyQt4 import QtCore, QtGui
from PyQt4.QtGui import QApplication
import vtk
from vtk.qt4.QVTKRenderWindowInteractor import QVTKRenderWindowInteractor
import sys
#---------------

from ynicKinectHandActor import AddHandActor
from ynicKinectAlgorithms import *
from ynicKinectVTKObjects import *
from ynicKinectHandPositions import *
from ynicKinectAddVTKButtons import addButtons
from ynicKinectClippingFunctions import *

#===============================================================================


import sys
import time
from ConfigParser import SafeConfigParser
from collections import deque
import numpy as np
from OpenGL.GL import *
from OpenGL.GLUT import *
from OpenGL.GLU import *
from OSCeleton import *



#----------------------------------
#some variables
global renderer, prev_zoom, renderWindow, txtLeftHand, txtRightHand, combinedHands, right_hand_pos, left_hand_pos, l_h_actor2d

SIZE_X = 160
SIZE_Y = 120
TARGET_SIZE = 0
REMOVE_AFTER = 200
usersTargets = []
server = OSCeleton(7110)
server.realWorld = True
frameCount = 0
users = {}
lastDisplayed = 0.0

vtkScreenX = 800
vtkScreenY = 600

left_hand_pos = (0,0,0)
right_hand_pos = (0,0,0)
prev_left_hand_pos = (0,0,0)
prev_right_hand_pos = (0,0,0)
prev_zoom = 1
#----------------------------------





class Player(Skeleton):
	"""Holds a players data.  Inherits from Skeleton.
	
	Player.hits is a counter for the number of targets this player hits.
	
	Player.last is the time at which this player's joints were updated. 
	"""
	
	def __init__(self, user_id):
		Skeleton.__init__(self, user_id)
		self.hits = 0
		self.last = 0.0
		
	def still_moving(self):
		"""Tests whether the Player's joints have been updated recently"""
		return time.time() - self.last < REMOVE_AFTER
		
class Target(Point):
	"""Stores target information"""
	def __init__(self, x, y, z):
		Point.__init__(self, x, y, z)
		self.baseJoint = ""
		self.middleJoint = ""
		self.hitJoint = ""
		self.calcLen = False

def runSkeleton():
	#def __init__(self):
	#	print 'launched thisThing'
	
	def getTargets(iniFile):
		"""Parses ini file and adds the targets found in the file to users_targets"""
		global usersTargets
		parser = SafeConfigParser()
		parser.read(iniFile)
		targList = parser.sections()
		targList.sort()
		for section in targList:
			x = parser.getfloat(section, 'x')
			y = parser.getfloat(section, 'y')
			z = parser.getfloat(section, 'z')
			t = Target(x, y, z)
			t.baseJoint = parser.get(section, 'baseJoint')
			t.middleJoint = parser.get(section, 'middleJoint')
			t.hitJoint = parser.get(section, 'hitJoint')
			if parser.has_option(section, 'calcLen'):
				t.calcLen = parser.getboolean(section, 'calcLen')
			usersTargets.append(t)
		
	def getRGB(joint, colorRange = 800):
		"""Returns a tuple with r, g and b color values based on joint's Z.
		
		Ugly but does the job, needs to be completely rewritten"""
		z = joint.z
		z = z % colorRange #smaller range gives more noticeable transitions
		subInterval = colorRange / 6.0
		rgb = [0, 0, 0]
		if z < subInterval:
			rgb[0] = 1.0
			rgb[1] = z / subInterval
		elif z < 2 * subInterval:
			rgb[1] = 1.0
			rgb[0] = (2 * subInterval - z) / subInterval
		elif z < 3 * subInterval:
			rgb[1] = 1.0
			rgb[2] = (z - 2 * subInterval) / subInterval
		elif z < 4 * subInterval:
			rgb[2] = 1.0
			rgb[1] = (4 * subInterval - z) / subInterval
		elif z < 5 * subInterval:
			rgb[2] = 1.0
			rgb[0] = (z - 4 * subInterval) / subInterval
		else:
			rgb[0] = 1
			rgb[2] = (colorRange - z) / subInterval
		return tuple(rgb)

	def drawLine(player, jointLabel1, jointLabel2):
		global left_hand_pos, right_hand_pos, prev_left_hand_pos, prev_right_hand_pos
		"""Accepts a skeleton and two joint labels.
		Draws a colored line between the skeleton's two joints that have the desired labels"""
		
		if (jointLabel1, jointLabel2) in player:
			joint1 = player[jointLabel1]
			joint2 = player[jointLabel2]
			if jointLabel2 == 'l_hand':
				prev_left_hand_pos = left_hand_pos #before assigning the new value keep track of previous
				left_hand_pos = joint2
			if jointLabel2 == 'r_hand':
				prev_right_hand_pos = right_hand_pos #before assigning the new value keep track of previous
				right_hand_pos = joint2 
			
			r, g, b = getRGB(joint1)
			glColor3f(r, g, b)
			glVertex3f(joint1.x, joint1.y, joint1.z)
			r, g, b = getRGB(joint2)
			glColor3f(r, g, b)
			glVertex3f(joint2.x, joint2.y, joint2.z)
				
	def glutIdle():
		"""Registered as GlutIdleFunc.
		
		Catches server events, adds and removes users and loads newest Skeletons"""
		global frameCount, users
		server.run()
		if server.frames > frameCount or server.lostUsers:
			if server.lostUsers:
				try:
					for each in server.lostUsers:
						del users[each]
						glutPostRedisplay()
				except KeyError:
					pass
				del server.lostUsers[:]
			for player in server.get_new_skeletons():
				if player.id not in users:
					users[player.id] = Player(player.id)
				users[player.id].joints = player.copy_joints()
				users[player.id].last = time.time()
				frameCount = server.frames
				glutPostRedisplay()
		elif time.time() - lastDisplayed > REMOVE_AFTER:
			glutPostRedisplay()
			
	def drawPlayers():
		"""Draws lines connecting available joints for every player in users"""
		glBegin(GL_LINES)
		for player in users.values():
			if player.still_moving():
				drawLine(player, HEAD, NECK)
				drawLine(player, NECK, TORSO)
				drawLine(player, LEFT_SHOULDER, LEFT_HIP)
				drawLine(player, RIGHT_SHOULDER, RIGHT_HIP)
				drawLine(player, LEFT_HIP, RIGHT_HIP)
				drawLine(player, LEFT_HIP, LEFT_KNEE)
				drawLine(player, LEFT_KNEE, LEFT_FOOT)
				drawLine(player, RIGHT_HIP, RIGHT_KNEE)
				drawLine(player, RIGHT_KNEE, RIGHT_FOOT)
				drawLine(player, LEFT_SHOULDER, RIGHT_SHOULDER)
				drawLine(player, LEFT_SHOULDER, LEFT_ELBOW)
				drawLine(player, LEFT_ELBOW, LEFT_HAND)   
				drawLine(player, RIGHT_SHOULDER, RIGHT_ELBOW)
				drawLine(player, RIGHT_ELBOW, RIGHT_HAND)
		glEnd()
		
	def getPlayersOrientation(player):
		"""Determines a users orientation.
		
		Accepts a Skeleton and returns a Point.
		
		Calculates orientation by using 3 points to create two vectors
		and then cross multiplies those vectors to find a vector perpindicular to both"""
		if (TORSO, LEFT_SHOULDER, RIGHT_SHOULDER) in player:
			torso = player[TORSO]
			tl = player[LEFT_SHOULDER] - player[TORSO]
			tr = player[RIGHT_SHOULDER] - player[TORSO]
			tl.normalize()
			tr.normalize()
			orientationArray = np.cross(tr.vals(), tl.vals())
			orientation = Point(orientationArray[0], orientationArray[1], orientationArray[2]) 
			orientation.normalize()
		else:
			orientation = Point(1, 1, 1)
			orientation.normalize()
		return orientation
		
	def glutDisplay():
		"""Registered as GlutDisplayFunc.  Calls all drawing functions"""
		global last_displayed
		lastDisplayed = time.time()
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)
		glMatrixMode(GL_PROJECTION)
		glShadeModel(GL_SMOOTH)
		glLineWidth(5)
		glLoadIdentity()
		drawPlayers()
		glFlush()
		glutSwapBuffers()

	iniFile = "generic.ini"
	getTargets(iniFile)
	glutInit(sys.argv)
	glutInitDisplayMode(GLUT_RGB | GLUT_DOUBLE | GLUT_DEPTH)
	glutInitWindowSize(SIZE_X, SIZE_Y)
	glutCreateWindow("BrainKinectSkeleton")
	glOrtho(-1280, 1280, -960, 960, 0, 10000)
	glEnable(GL_DEPTH_TEST)
	glutDisplayFunc(glutDisplay)
	glutIdleFunc(glutIdle)
	glLineWidth(5)
	glutMainLoop()
		


class Ui_MainWindow(object):
	def setupUi(self, MainWindow):
		MainWindow.setObjectName("MainWindow")
		
		self.centralWidget = QtGui.QWidget(MainWindow)
		self.gridlayout = QtGui.QGridLayout(self.centralWidget)
		self.vtkWidget = QVTKRenderWindowInteractor(self.centralWidget)
		self.gridlayout.addWidget(self.vtkWidget, 0, 0, 1, 1)
		MainWindow.setCentralWidget(self.centralWidget)
        MainWindow.resize(800, 640)
		

global iren, box_bounds, point, pointWidget, box, scalpbox, skullbox, cortexbox, planeWidgetX, planeWidgetY, planeWidgetZ, x_distance, y_distance, z_distance		


class SimpleView(QtGui.QMainWindow):
	global iren, box_bounds, point, pointWidget, box, scalpbox, skullbox, cortexbox, planeWidgetX, planeWidgetY, planeWidgetZ, x_distance, y_distance, z_distance		
	global prev_rhpx_vtk, prev_rhpy_vtk, rhpx_vtk, rhpy_vtk
	def __init__(self, parent = None):
		global iren, box_bounds, point, pointWidget, box, scalpbox, skullbox, cortexbox, planeWidgetX, planeWidgetY, planeWidgetZ, x_distance, y_distance, z_distance		
		global prev_rhpx_vtk, prev_rhpy_vtk, rhpx_vtk, rhpy_vtk
		QtGui.QMainWindow.__init__(self, parent)
		self.ui = Ui_MainWindow()
		self.ui.setupUi(self)
		self.ren = vtk.vtkRenderer()
		self.ui.vtkWidget.GetRenderWindow().AddRenderer(self.ren)
		iren = self.ui.vtkWidget.GetRenderWindow().GetInteractor()
		
		renderWindow = self.ui.vtkWidget.GetRenderWindow()
		
		try:
			vol, x, y, bounds, x_slice_pos, y_slice_pos, z_slice_pos, srow_x, srow_y, srow_z, spacing = nifti2vtkImageData('./anatomy/MNI_structural.nii.gz')
		except:
			vol, x, y, bounds, x_slice_pos, y_slice_pos, z_slice_pos, srow_x, srow_y, srow_z, spacing = nifti2vtkImageData('/home/andre/andre_svn/trunk/DV3D_BetaDist/DV3D_v0.547/DV3D_essentials/MNI_structural.nii.gz')	

		#print bounds

		# lets assume the viewing angle will alway be from the front-left of the head
		# no lets har code some bounds for our imageplanes accordingly

		x_edge, y_edge, z_edge = bounds[0], bounds[2], bounds[4]


		#vol, x, y, bounds, x_slice_pos, y_slice_pos, z_slice_pos, srow_x, srow_y, srow_z, spacing = nifti2vtkImageData('./DV3D_essentials/talairach_in_MNI.nii.gz')


		########

		vol.Update()
		#print vol.GetOutput()

		#do some calculations to restrict our cutting
		gb = vol.GetOutput().GetBounds()
		x_distance = (gb[1]-gb[0])/2.0
		y_distance = (gb[3]-gb[2])/2.0
		z_distance = (gb[5]-gb[4])/2.0

		#plane lookuptables
		lu = vtk.vtkLookupTable()
		lu.SetNumberOfTableValues(256)
		lu.SetTableRange(25,200)
		#lu.ForceBuild()
		for i in range(256):
			if i <25 :
				lu.SetTableValue(i, (i/255.,i/255.0,i/255.0,0.0))
			elif i <230 :
				lu.SetTableValue(i, (i/400.,i/400.0,i/400.0,1.0))
			else:
				lu.SetTableValue(i, (1.0,1.0,1.0,1.0))
		lu.Build()
		lu.SetTableValue(0, (0.0,0.0,0.0,0.0))


		#IPWs
		# The shared picker enables us to use 3 planes at one time
		# and gets the picking order right
		picker = vtk.vtkCellPicker()
		picker.SetTolerance(0.005)

		# The 3 image plane widgets are used to probe the dataset.
		planeWidgetX = vtk.vtkImagePlaneWidget()
		planeWidgetX.DisplayTextOn()
		planeWidgetX.SetInput(vol.GetOutput())
		planeWidgetX.SetPlaneOrientationToXAxes()
		planeWidgetX.SetSliceIndex(32)
		planeWidgetX.SetPicker(picker)
		planeWidgetX.SetKeyPressActivationValue("x")
		planeWidgetX.SetLookupTable(lu)
		prop1 = planeWidgetX.GetPlaneProperty()
		prop1.SetOpacity(0.0)

		planeWidgetY = vtk.vtkImagePlaneWidget()
		planeWidgetY.DisplayTextOn()
		planeWidgetY.SetInput(vol.GetOutput())
		planeWidgetY.SetPlaneOrientationToYAxes()
		planeWidgetY.SetSliceIndex(32)
		planeWidgetY.SetPicker(picker)
		planeWidgetY.SetKeyPressActivationValue("y")
		planeWidgetY.SetLookupTable(lu)
		prop2 = planeWidgetY.GetPlaneProperty()
		prop2.SetOpacity(0.0)
		planeWidgetY.SetLookupTable(planeWidgetX.GetLookupTable())


		# for the z-slice, turn off texture interpolation:
		# interpolation is now nearest neighbour, to demonstrate
		# cross-hair cursor snapping to pixel centers
		planeWidgetZ = vtk.vtkImagePlaneWidget()
		planeWidgetZ.DisplayTextOn()
		planeWidgetZ.SetInput(vol.GetOutput())
		planeWidgetZ.SetPlaneOrientationToZAxes()
		planeWidgetZ.SetSliceIndex(46)
		planeWidgetZ.SetPicker(picker)
		planeWidgetZ.SetKeyPressActivationValue("z")
		planeWidgetZ.SetLookupTable(lu)
		prop3 = planeWidgetZ.GetPlaneProperty()
		prop3.SetOpacity(0.0)
		planeWidgetZ.SetLookupTable(planeWidgetX.GetLookupTable())

		#-----------------------------------------------------------------
		#prepare a box to use as our implicit cutter
		box = vtk.vtkBox()

		#-----------------------------------------------------------------


		#-----------------------------------------------------------------
		#load some .vtk surfaces with a naming loop
		# get MH to show me an alternative way of naming here

		surfs = [['amygdala', './anatomy/Amygdala.vtk', (0, 1, 0), 1],
				['brainstem', './anatomy/Brainstem.vtk', (0.2,  0.2, 1), 1],
				['thalamus', './anatomy/Thalamus.vtk', (1,  0,  0), 1],
				['ventricles', './anatomy/Ventricles.vtk', (0,  1,  1), 1],
				['hippocampus', './anatomy/Hippocampus.vtk', (1, 1,  0), 1],
				['cortex', './anatomy/Cortex_3mm.vtk', (0.98,  0.12,  0.12), 1],
				['skull', './anatomy/Skull.vtk', (0.95, 0.95, 0.95), 1],
				['scalp', './anatomy/Scalp.vtk', (0.9,  0.8,  0.3), 1]]

		
		amygdalaActor, amygdalabox, amygdalaMapper = generateActor(surfs[0][1], surfs[0][2], surfs[0][3])
		brainstemActor, brainstembox, brainstemMapper = generateActor(surfs[1][1], surfs[1][2], surfs[1][3])
		thalamusActor, thalamusbox, thalamusMapper = generateActor(surfs[2][1], surfs[2][2], surfs[2][3])
		ventriclesActor, ventriclesbox, ventriclesMapper = generateActor(surfs[3][1], surfs[3][2], surfs[3][3])
		hippocampusActor, hippocampusbox, hippocampusMapper = generateActor(surfs[4][1], surfs[4][2], surfs[4][3])
		cortexActor, cortexbox, cortexMapper = generateActor(surfs[5][1], surfs[5][2], surfs[5][3])
		skullActor, skullbox, skullMapper = generateActor(surfs[6][1], surfs[6][2], surfs[6][3])
		scalpActor, scalpbox, scalpMapper = generateActor(surfs[7][1], surfs[7][2], surfs[7][3])
		
		
		self.ren.AddActor(amygdalaActor)
		self.ren.AddActor(brainstemActor)
		self.ren.AddActor(thalamusActor)
		self.ren.AddActor(ventriclesActor)
		self.ren.AddActor(hippocampusActor)
		self.ren.AddActor(cortexActor)
		self.ren.AddActor(skullActor)
		self.ren.AddActor(scalpActor)


		#-----------------------------------------------------------------
		#----Now we add a point widgte that can be dragged around to 
		# define the centre of our cutting box 
		# The plane widget is used probe the dataset.
		vol2 = vtk.vtkImageData()
		vol2.DeepCopy(vol.GetOutput())
		vol2.SetOrigin(-90,108,90)

		pointWidget = vtk.vtkPointWidget()
		pointWidget.SetInput(vol2)
		pointWidget.AllOn()
		pointWidget.PlaceWidget()
		#pointWidget.PlaceWidget(10,10,100,100,100,100)
		point = vtk.vtkPolyData()
		pointWidget.GetPolyData(point)
		pointWidget.SetPriority(1)
		pointWidget.ZShadowsOff()
		pointWidget.GetProperty().SetOpacity(0.01)
		pointWidget.GetSelectedProperty().SetOpacity(0.01)
		#pointWidget.GetProperty().SetLineWidth(0)

		probe = vtk.vtkProbeFilter()
		probe.SetInput(point)
		probe.SetSource(vol.GetOutput())

		# create glyph
		cone = vtk.vtkSphereSource()
		cone.SetRadius(10)
		#cone.SetHeight(20)
		#cone.SetResolution(16)
		glyph = vtk.vtkGlyph3D()
		glyph.SetInputConnection(probe.GetOutputPort())
		glyph.SetSource(cone.GetOutput())
		glyph.SetVectorModeToUseVector()
		glyph.SetScaleModeToDataScalingOff()
		#glyph.SetScaleFactor(pl3d.GetOutput().GetLength()*0.1)
		glyphMapper = vtk.vtkPolyDataMapper()
		glyphMapper.SetInputConnection(glyph.GetOutputPort())
		glyphActor = vtk.vtkActor()
		glyphActor.SetMapper(glyphMapper)

		c_bounds = pointWidget.GetPosition()
		box_bounds = (c_bounds[0]-x_distance, c_bounds[0]+x_distance+50, \
				c_bounds[1]-y_distance-50, c_bounds[1]+y_distance, \
				c_bounds[2]-z_distance-50, c_bounds[2]+z_distance)


		#some nasty globals
		global iren, box_bounds, point, pointWidget, box, scalpbox, skullbox, cortexbox, planeWidgetX, planeWidgetY, planeWidgetZ, x_distance, y_distance, z_distance		
		
		def pwInteraction(obj, event):
			pass
			#global point, glyphActor, box, box_bounds,planeWidgetX,planeWidgetY,planeWidgetZ
			#obj.GetPolyData(point)
			#c_bounds = pointWidget.GetPosition()
			#box_bounds = (c_bounds[0]-x_distance, c_bounds[0]+x_distance+50, \
							#c_bounds[1]-y_distance-50, c_bounds[1]+y_distance, \
							#c_bounds[2]-z_distance-50, c_bounds[2]+z_distance)
			
			#box.SetBounds(box_bounds)
			#box.Modified()
			#scalpbox.SetBounds(box_bounds)
			#scalpbox.Modified()
			#skullbox.SetBounds(box_bounds)
			#skullbox.Modified()
			#cortexbox.SetBounds(box_bounds)
			#cortexbox.Modified()
			
			#xpos = (box_bounds[1]-1,box_bounds[1]-1, box_bounds[2],box_bounds[3], box_bounds[4],box_bounds[5])

			#ypos = (box_bounds[0],box_bounds[1], box_bounds[2]+1,box_bounds[2]+1, box_bounds[4],box_bounds[5])

			#zpos = (box_bounds[0],box_bounds[1], box_bounds[2],box_bounds[3], box_bounds[4]+1,box_bounds[4]+1)

			#planeWidgetX.PlaceWidget(xpos)
			#planeWidgetY.PlaceWidget(ypos)
			#planeWidgetZ.PlaceWidget(zpos)
			
			#iren.InvokeEvent('MouseMoveEvent')


		global mouse_cutter_on, cut_dir
		global point, glyphActor, box, box_bounds,planeWidgetX,planeWidgetY,planeWidgetZ
		global prev_rhpx_vtk, prev_rhpy_vtk, rhpx_vtk, rhpy_vtk
		
		mouse_cutter_on = 0
		cut_dir = 0


		def myKeyEvents(obj, event):
			global box_bounds, mouse_cutter_on, cut_dir,  point, glyphActor, box, box_bounds,planeWidgetX,planeWidgetY,planeWidgetZ
			key = obj.GetKeyCode()
			print 'key', key
			if key == "l":
				print 'l'
				print cam.GetPosition()
				cortexMapper.SetInput(cortexReader.GetOutput())
				planeWidgetX.Off(); planeWidgetY.Off(); planeWidgetZ.Off()
				#print ren.GetDisplayPoint()
				
			elif key == "k":
				print 'k'
				cortexMapper.SetInput(cortexClipper.GetOutput())
				skullMapper.SetInput(skullClipper.GetOutput())
				planeWidgetX.On(); planeWidgetY.On(); planeWidgetZ.On()
				
			elif key == "x":
				skullMapper.SetInput(skullReader.GetOutput())
				cortexMapper.SetInput(cortexReader.GetOutput())
				planeWidgetX.Off(); planeWidgetY.Off(); planeWidgetZ.Off()
				
			elif key == "y":
				skullMapper.SetInput(skullClipper.GetOutput())
				cortexMapper.SetInput(cortexReader.GetOutput())
				planeWidgetX.Off(); planeWidgetY.Off(); planeWidgetZ.Off()
				
			elif key == "g":
				print 'g'
				cut_dir = 0
				mouse_cutter_on = 1
				
			elif key == "h":
				print 'h'
				cut_dir = 0
				mouse_cutter_on = 0
				
			elif key == "7":
				print '7'
				frames = 50
				(curr_x, curr_y, curr_z) = cam.GetPosition()
				(trgt_x, trgt_y, trgt_z) = (-800,640,320)
				
				x_vals = linspace(curr_x, trgt_x, frames)
				y_vals = linspace(curr_y, trgt_y, frames)
				z_vals = linspace(curr_z, trgt_z, frames)
				
				(curr_xVU, curr_yVU, curr_zVU) = cam.GetViewUp()
				(trgt_xVU, trgt_yVU, trgt_zVU) = (0,0,1)
				
				x_vu = linspace(curr_xVU, trgt_xVU, frames)
				y_vu = linspace(curr_yVU, trgt_yVU, frames)
				z_vu = linspace(curr_zVU, trgt_zVU, frames)
				
				(curr_xFP, curr_yFP, curr_zFP) = cam.GetFocalPoint()
				(trgt_xFP, trgt_yFP, trgt_zFP) = scalpMapper.GetCenter()
				
				x_fp = linspace(curr_xFP, trgt_xFP, frames)
				y_fp = linspace(curr_yFP, trgt_yFP, frames)
				z_fp = linspace(curr_zFP, trgt_zFP, frames)
				
				
				for i in range(frames):
					cam.SetPosition(x_vals[i], y_vals[i], z_vals[i])
					cam.SetViewUp((x_vu[i], y_vu[i], z_vu[i]))
					cam.SetFocalPoint(x_fp[i], y_fp[i], z_fp[i])
					iren.Render()
					time.sleep(0.02)
					
			elif key == "8":
				print cam.GetPosition()
				print cam.GetViewUp()
				print cam.GetViewAngle()
				
			elif key == "9":
				cam.SetFocalPoint(scalpMapper.GetCenter())
				orig_pos = cam.GetPosition()
				cam.SetPosition(-800,640,320)
				cam.SetViewUp(0,0,1)
				cam.SetViewAngle(30)
				cam.Elevation(15)


			iren.Render()


		def checkMouseCutDirection(prev, curr):
			global box_bounds, point, glyphActor, box, box_bounds,planeWidgetX,planeWidgetY,planeWidgetZ
			cutAngle = rad2deg(arctan2(curr[0]-prev[0], curr[1]-prev[1]))
			print cutAngle

			bb = box_bounds

			#check which boundary range the movement is in
			if (cutAngle >-180 and cutAngle <-160) or (cutAngle >160 and cutAngle <180):
				cutDir =  6
				bb = (bb[0], bb[1], bb[2], bb[3], bb[4]-10, bb[5])
				
			elif (cutAngle >-140 and cutAngle <-100):
				cutDir = 8
				bb = (bb[0], bb[1], bb[2]+10, bb[3], bb[4], bb[5])

			elif (cutAngle >-80 and cutAngle <-40):
				cutDir = 10
				bb = (bb[0], bb[1]+10, bb[2], bb[3], bb[4], bb[5])

			elif (cutAngle >-20 and cutAngle <20):
				cutDir = 12
				bb = (bb[0], bb[1], bb[2], bb[3], bb[4]+10, bb[5])

			elif (cutAngle >40 and cutAngle <80):
				cutDir = 2
				bb = (bb[0], bb[1], bb[2]-10, bb[3], bb[4], bb[5])

			elif (cutAngle >100 and cutAngle <140):
				cutDir = 4
				bb = (bb[0], bb[1]-10, bb[2], bb[3], bb[4], bb[5])	

			box_bounds = bb
				
			box.SetBounds(box_bounds)
			box.Modified()
			scalpbox.SetBounds(box_bounds)
			scalpbox.Modified()
			skullbox.SetBounds(box_bounds)
			skullbox.Modified()
			cortexbox.SetBounds(box_bounds)
			cortexbox.Modified()

			xpos = (box_bounds[1]-1,box_bounds[1]-1, box_bounds[2],box_bounds[3], box_bounds[4],box_bounds[5])

			ypos = (box_bounds[0],box_bounds[1], box_bounds[2]+1,box_bounds[2]+1, box_bounds[4],box_bounds[5])

			zpos = (box_bounds[0],box_bounds[1], box_bounds[2],box_bounds[3], box_bounds[4]+1,box_bounds[4]+1)

			planeWidgetX.PlaceWidget(xpos)
			planeWidgetY.PlaceWidget(ypos)
			planeWidgetZ.PlaceWidget(zpos)
			
			iren.Render()

		def mouseMovingCutter(arg1, arg2):
			global mouse_cutter_on, cut_dir, prev_rhpx_vtk, prev_rhpy_vtk, rhpx_vtk, rhpy_vtk
			
			print prev_rhpx_vtk, prev_rhpy_vtk, rhpx_vtk, rhpy_vtk
			print type(right_hand_pos)
			#get state
			if mouse_cutter_on == 1:

				prev, curr = array((prev_rhpx_vtk, prev_rhpy_vtk),'f'), array((rhpx_vtk, rhpy_vtk),'f')
				time.sleep(0.05) #TODO will have to calibrate
				
				#first check if movement is in the right range 
				abs_diff = sqrt((abs(prev[0])-abs(curr[0]))**2 + (abs(prev[1])-abs(curr[1]))**2)
				#print abs_diff
				if abs_diff > 10 and abs_diff < 150: #TODO will have to calibrate
					cut_dir = checkMouseCutDirection(prev, curr)
				
				#get cut direction
				if cut_dir == 0:
					pass
				elif cut_dir == 1:
					pass
				elif cut_dir == 2:
					pass
				else:
					pass
				
				
		# Associate the line widget with the interactor
		pointWidget.SetInteractor(iren)
		pointWidget.AddObserver("EnableEvent", pwInteraction)
		pointWidget.AddObserver("StartInteractionEvent", pwInteraction)
		pointWidget.AddObserver("InteractionEvent", pwInteraction)
		pointWidget.TranslationModeOn()
		pointWidget.On()
		pointWidget.Modified()
		#-----------------------------------------------------------------
		
		iren.AddObserver("KeyPressEvent", myKeyEvents)

		#-----------------------------------------------------------------
		def resizePlanes(arg1, arg2):
			global box_bounds
			x1 = planeWidgetX.GetPoint1()
			x2 = planeWidgetX.GetPoint2()
			y1 = planeWidgetY.GetPoint1()
			y2 = planeWidgetY.GetPoint2()
			z1 = planeWidgetZ.GetPoint1()
			z2 = planeWidgetZ.GetPoint2()
			xpos = (box_bounds[1],box_bounds[1], box_bounds[2],box_bounds[3], box_bounds[4],box_bounds[5])
			ypos = (box_bounds[0],box_bounds[1], box_bounds[2],box_bounds[2], box_bounds[4],box_bounds[5])
			zpos = (box_bounds[0],box_bounds[1], box_bounds[2],box_bounds[3], box_bounds[4],box_bounds[4])
			planeWidgetX.PlaceWidget(xpos)
			planeWidgetY.PlaceWidget(ypos)
			planeWidgetZ.PlaceWidget(zpos)


		#resizePlanes(1,2)

		planeWidgetX.SetInteractor(iren)
		planeWidgetX.On()
		planeWidgetX.SetInteraction(0) #stop users messing with it directly
		planeWidgetY.SetInteractor(iren)
		planeWidgetY.On()
		planeWidgetY.SetInteraction(0) #stop users messing with it directly
		planeWidgetZ.SetInteractor(iren)
		planeWidgetZ.On()
		planeWidgetZ.SetInteraction(0) #stop users messing with it directly


		#Create a mapper and actor for the left hand
		txtLeftHand = AddHandActor((30,30), './icons/left_hand.jpg')
		txtRightHand = AddHandActor((vtkScreenX-30,30), './icons/right_hand.jpg')
		combinedHands = AddHandActor((vtkScreenX/2,30), './icons/both_hand.jpg')

		iren.SetInteractorStyle(vtk.vtkInteractorStyleTrackballCamera()) 

		##add some buttons first so they are in the background
		#addButtons(self.ren, vtkScreenX, vtkScreenY)

		self.ren.AddActor(txtLeftHand)
		self.ren.AddActor(txtRightHand)
		self.ren.AddActor(combinedHands) 

		#-----------------------------------------------------------------
		# Add the actors to the renderer, set the background and size
		#ren.AddActor(surf)
		self.ren.AddActor(glyphActor)
		
		
		renderWindow.SetSize(vtkScreenX, vtkScreenY)
	 
		def checkGestures(arg1, arg2):
			global prev_rhpx_vtk, prev_rhpy_vtk, rhpx_vtk, rhpy_vtk
			#print 'test'
			time.sleep(0.05)
			#here we run our algorithms that control the movement gesture input
			if left_hand_pos != (0,0,0): #not tuple basically
				#first lets see where the hands are
				try:
					prev_rhpx_vtk, prev_rhpy_vtk = rhpx_vtk, rhpy_vtk
				except:
					'print couldnt do it'
				hand_diff, lhpx_vtk, lhpy_vtk, rhpx_vtk, rhpy_vtk = checkHandPos(vtkScreenX, vtkScreenY, left_hand_pos, right_hand_pos)
				#print hand_diff
				if hand_diff > 100: #the hands are separate in the window
					#update the hand actor positions
					updateIndividualHandPos(lhpx_vtk, lhpy_vtk, rhpx_vtk, rhpy_vtk, self.ren, prev_zoom, renderWindow, right_hand_pos, left_hand_pos, txtLeftHand, txtRightHand, combinedHands)
					#check if the user made a horz sweep with the right hand
					
					if mouse_cutter_on == True:
						mouseMovingCutter(1,2)
					else:
						checkSetAzimuth(cam, self.ren, prev_zoom, renderWindow, right_hand_pos, prev_right_hand_pos)
						#check if the user made a vert sweep with the left right hand				
						checkSetElevation(cam, self.ren, prev_zoom, renderWindow, left_hand_pos, prev_left_hand_pos)
						#check if the users hands are over buttons
						checkButtonPress(self.ren, left_hand_pos, right_hand_pos, lhpx_vtk, lhpy_vtk, rhpx_vtk, rhpy_vtk, vtkScreenX, vtkScreenY, prev_zoom, txtLeftHand, txtRightHand, renderWindow, combinedHands)
				else:
					#the hands are together
					updateCombinedHandPos(lhpx_vtk, lhpy_vtk, rhpx_vtk, rhpy_vtk, self.ren, prev_zoom, renderWindow, right_hand_pos, left_hand_pos, txtLeftHand, txtRightHand, combinedHands, )
					checkSetZoom(cam, self.ren, renderWindow, right_hand_pos, prev_right_hand_pos)
			else:
				pass


		cam = self.ren.GetActiveCamera()
		cam.SetFocalPoint(scalpMapper.GetCenter())
		orig_pos = cam.GetPosition()
		cam.SetPosition(-800,640,320)
		cam.SetViewUp(0,0,1)
		cam.SetViewAngle(30)
		cam.Elevation(15)
		#cam.SetPosition(orig_pos[0]+act_center[0], orig_pos[1]+act_center[1], orig_pos[2])
		#
		#cam.Azimuth(180)
		#\
		#cam.Roll(180)
		#cam.Azimuth(30)
		#cam.Elevation(30)

		cam.Modified()
		iren.Render()
		
		iren.AddObserver("TimerEvent", checkGestures)
		#iren.AddObserver("MouseMoveEvent", mouseMovingCutter)

		iren.CreateRepeatingTimer(100)
 
		iren.Start()
		
	 


#===============================================================================
# Main
#===============================================================================

app = QtGui.QApplication(sys.argv)
window = SimpleView()
window.resize(800, 640)
window.show()
window.raise_()

#still can't figure this ou w othout threading as the glutMainLoop is a problem
t = threading.Thread(target=runSkeleton, kwargs={})
t.start()

sys.exit(app.exec_())
