import vtk
 
# create a rendering window and renderer
ren = vtk.vtkRenderer()
renWin = vtk.vtkRenderWindow()
renWin.AddRenderer(ren)
 
# create a renderwindowinteractor
iren = vtk.vtkRenderWindowInteractor()
iren.SetRenderWindow(renWin)
 
# create cone
cone = vtk.vtkConeSource()
cone.SetResolution(60)
cone.SetCenter(-2,0,0)
 
# mapper
coneMapper = vtk.vtkPolyDataMapper()
coneMapper.SetInput(cone.GetOutput())
 
# actor
coneActor = vtk.vtkActor()
coneActor.SetMapper(coneMapper)
 
# assign actor to the renderer
ren.AddActor(coneActor)
 
# enable user interface interactor
iren.Initialize()
iren.On()

cam = ren.GetActiveCamera()

t = 0

while True:
    renWin.Render()
    cam.Azimuth(1)
    if t == 0:
        coneActor.VisibilityOn()
	t = 1
    else:
	t = 0
	coneActor.VisibilityOff()

    

