import vtk

def CreateVTKPolyDataSurface(vertex_file):
    try_me = vtk.vtkPolyDataReader()
    try_me.SetFileName(vertex_file)    

    mn_PolyData = try_me.GetOutput()
    mn_PolyData.Update()

    t = vtk.vtkSmoothPolyDataFilter()
    t.SetNumberOfIterations(10)
    t.SetInput(mn_PolyData)
    t.Update()

    mn_PolyData = t.GetOutput()
    mn_PolyData.Update()
    
    mn_Mapper = vtk.vtkPolyDataMapper()
    mn_Mapper.ImmediateModeRenderingOn()
    mn_Mapper.SetInput(mn_PolyData)
    mn_Mapper.ScalarVisibilityOff()
    
    mn_Mapper.Update()
    my_mnorm_brain = vtk.vtkLODActor()
    my_mnorm_brain.SetMapper(mn_Mapper)

        
    my_mnorm_brain.GetProperty().SetColor(1.0,0.2,0.2)
    return my_mnorm_brain, mn_Mapper


def doTheVTKStuff():
    global renderer, prev_zoom, renderWindowInteractor
    #Create a sphere
    sphereSource = vtk.vtkSphereSource()
    sphereSource.SetCenter(0.0, 0.0, 0.0)
    sphereSource.SetRadius(5)

    #Create a mapper and actor
    mapper = vtk.vtkPolyDataMapper()
    mapper.SetInputConnection(sphereSource.GetOutputPort())
    actor = vtk.vtkActor()

    my_mnorm_brain, mn_Mapper = CreateVTKPolyDataSurface('../mni_surface_5500_3mm.vtk')
    actor.SetMapper(mn_Mapper)
    mn_Mapper.Update()

    propertyBack = vtk.vtkProperty()
    propertyBack.SetDiffuseColor(1.0, 0.5, 0.4)
    propertyBack.SetOpacity(0.05)
    actor.GetProperty().SetColor(1.0,1.0,1.0)
    actor.GetProperty().SetOpacity(0.05)
    actor.SetBackfaceProperty(propertyBack)
    actor.GetProperty().SetRepresentationToWireframe()

    # Setup a renderer, render window, and interactor
    renderer = vtk.vtkRenderer()
    renderWindow = vtk.vtkRenderWindow()
    #renderWindow.SetWindowName("Test")

    renderWindow.AddRenderer(renderer);
    renderWindowInteractor = vtk.vtkRenderWindowInteractor()
    renderWindowInteractor.SetRenderWindow(renderWindow)
    renderWindowInteractor.SetInteractorStyle(vtk.vtkInteractorStyleTrackballCamera()) 


    #Add the actor to the scene
    renderer.AddActor(actor)
    renderer.SetBackground(1,1,1) # Background color white

    #Render and interact
    renderWindow.Render()

    # Initialize must be called prior to creating timer events.
    renderWindowInteractor.Initialize()

    # Sign up to receive TimerEvent
    timerId = renderWindowInteractor.CreateRepeatingTimer(1);
    ##renderWindowInteractor.AddObserver('TimerEvent', checkTheZoomer)
    renderWindowInteractor.AddObserver('TimerEvent', getKinectInfo)

    rw = renderWindowInteractor.GetRenderWindow()
    rw.SetSize(600,600)

    #start the interaction and timer
    renderWindowInteractor.Start()


if __name__ == '__main__':
    #thread.start_new_thread(myfunction,("Thread No:1",0.01))
    main(
