import vtk

def addButtons(renderer, vtkScreenX, vtkScreenY):
    
    button_list = [["./icons/scissors_on-icon.jpg", "./icons/scissors_off-icon.jpg", [100,100]]]
    
    renderer.buttons = [];
    
    for i in button_list:
        on_reader = vtk.vtkJPEGReader()
        on_reader.SetFileName(i[0])
        on_reader.Update()

        onMapper = vtk.vtkImageMapper()
        onMapper.SetInput(on_reader.GetOutput())
        onMapper.SetColorWindow(255)
        onMapper.SetColorLevel(127.5)
        onMapper.Update()

        button_on_actor = vtk.vtkActor2D()
        button_on_actor.SetMapper(onMapper)
        button_on_actor.SetPosition(vtkScreenX-i[2][0], vtkScreenY-i[2][1])
        button_on_actor.VisibilityOff()
        #img.SetPosition2(vtkScreenX, vtkScreenY)

        off_reader = vtk.vtkJPEGReader()
        off_reader.SetFileName(i[1])
        off_reader.Update()

        offMapper = vtk.vtkImageMapper()
        offMapper.SetInput(off_reader.GetOutput())
        offMapper.SetColorWindow(255)
        offMapper.SetColorLevel(127.5)
        offMapper.Update()

        button_off_actor = vtk.vtkActor2D()
        button_off_actor.SetMapper(offMapper)
        button_off_actor.SetPosition(vtkScreenX-i[2][0], vtkScreenY-i[2][1])
        #img.SetPosition2(vtkScreenX, vtkScreenY)

        renderer.buttons.append([button_off_actor, button_on_actor, 1])
        renderer.AddActor2D(renderer.buttons[-1][0])
        renderer.AddActor2D(renderer.buttons[-1][1])


def addButtons2(renderer):

    reader = vtk.vtkJPEGReader()
    reader.SetFileName("/tmp/tst2.jpg")
    reader.Update()
    
    LUT = vtk.vtkLookupTable();
    LUT.SetTableRange(0,12255)
    LUT.SetNumberOfColors(256);
    LUT.SetTableValue(0, (0.0,0.0,0.0,0.0))
    LUT.Build();

    mapToRGBA = vtk.vtkImageMapToColors();
    mapToRGBA.SetInput(reader.GetOutput());
    mapToRGBA.SetOutputFormatToRGBA();
    mapToRGBA.SetLookupTable(LUT);

    ColorActor = vtk.vtkImageActor();
    ColorActor.SetInput(mapToRGBA.GetOutput());
    #ColorActor.SetPosition(0, 0, 1);
    
    renderer.AddActor(ColorActor)
    