/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.CapabilityBase;
import org.OpenNI.Generator;
import org.OpenNI.IStateChangedObservable;
import org.OpenNI.NativeMethods;
import org.OpenNI.OutArg;
import org.OpenNI.ProductionNode;
import org.OpenNI.StateChangedObservable;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class FrameSyncCapability
extends CapabilityBase {
    private StateChangedObservable frameSyncChanged = new StateChangedObservable(){

        @Override
        protected int registerNative(String string, OutArg<Long> outArg) {
            return NativeMethods.xnRegisterToFrameSyncChange(FrameSyncCapability.this.toNative(), this, string, outArg);
        }

        @Override
        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterFromFrameSyncChange(FrameSyncCapability.this.toNative(), l);
        }
    };

    public FrameSyncCapability(ProductionNode productionNode) throws StatusException {
        super(productionNode);
    }

    public boolean canFrameSyncWith(Generator generator) {
        return NativeMethods.xnCanFrameSyncWith(this.toNative(), generator.toNative());
    }

    public void frameSyncWith(Generator generator) throws StatusException {
        int n = NativeMethods.xnFrameSyncWith(this.toNative(), generator.toNative());
        WrapperUtils.throwOnError(n);
    }

    public void stopFrameSyncWith(Generator generator) throws StatusException {
        int n = NativeMethods.xnStopFrameSyncWith(this.toNative(), generator.toNative());
        WrapperUtils.throwOnError(n);
    }

    public boolean isFrameSyncedWith(Generator generator) {
        return NativeMethods.xnIsFrameSyncedWith(this.toNative(), generator.toNative());
    }

    public IStateChangedObservable getFrameSyncChangedEvent() {
        return this.frameSyncChanged;
    }
}

