/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.Context;
import org.OpenNI.DepthMap;
import org.OpenNI.DepthMetaData;
import org.OpenNI.EnumerationErrors;
import org.OpenNI.FieldOfView;
import org.OpenNI.GeneralException;
import org.OpenNI.IStateChangedObservable;
import org.OpenNI.MapGenerator;
import org.OpenNI.MapOutputMode;
import org.OpenNI.NativeMethods;
import org.OpenNI.NodeType;
import org.OpenNI.OutArg;
import org.OpenNI.Point3D;
import org.OpenNI.Query;
import org.OpenNI.StateChangedObservable;
import org.OpenNI.StatusException;
import org.OpenNI.UserPositionCapability;
import org.OpenNI.WrapperUtils;

public class DepthGenerator
extends MapGenerator {
    private StateChangedObservable fovChanged = new StateChangedObservable(){

        @Override
        protected int registerNative(String string, OutArg<Long> outArg) {
            return NativeMethods.xnRegisterToDepthFieldOfViewChange(DepthGenerator.this.toNative(), this, string, outArg);
        }

        @Override
        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterFromDepthFieldOfViewChange(DepthGenerator.this.toNative(), l);
        }
    };
    private DepthMap currDepthMap;
    private int currDepthMapFrameID;

    DepthGenerator(Context context, long l, boolean bl) throws GeneralException {
        super(context, l, bl);
    }

    public static DepthGenerator create(Context context, Query query, EnumerationErrors enumerationErrors) throws GeneralException {
        OutArg<Long> outArg = new OutArg<Long>();
        int n = NativeMethods.xnCreateDepthGenerator(context.toNative(), outArg, query == null ? 0L : query.toNative(), enumerationErrors == null ? 0L : enumerationErrors.toNative());
        WrapperUtils.throwOnError(n);
        DepthGenerator depthGenerator = (DepthGenerator)context.createProductionNodeObject((Long)outArg.value, NodeType.DEPTH);
        NativeMethods.xnProductionNodeRelease((Long)outArg.value);
        return depthGenerator;
    }

    public static DepthGenerator create(Context context, Query query) throws GeneralException {
        return DepthGenerator.create(context, query, null);
    }

    public static DepthGenerator create(Context context) throws GeneralException {
        return DepthGenerator.create(context, null, null);
    }

    public DepthMap getDepthMap() throws GeneralException {
        int n = this.getFrameID();
        if (this.currDepthMap == null || this.currDepthMapFrameID != n) {
            long l = NativeMethods.xnGetDepthMap(this.toNative());
            MapOutputMode mapOutputMode = this.getMapOutputMode();
            this.currDepthMap = new DepthMap(l, mapOutputMode.getXRes(), mapOutputMode.getYRes());
            this.currDepthMapFrameID = n;
        }
        return this.currDepthMap;
    }

    public int getDeviceMaxDepth() {
        return NativeMethods.xnGetDeviceMaxDepth(this.toNative());
    }

    public FieldOfView getFieldOfView() throws StatusException {
        OutArg<Double> outArg = new OutArg<Double>();
        OutArg<Double> outArg2 = new OutArg<Double>();
        int n = NativeMethods.xnGetDepthFieldOfView(this.toNative(), outArg, outArg2);
        WrapperUtils.throwOnError(n);
        return new FieldOfView((Double)outArg.value, (Double)outArg2.value);
    }

    public IStateChangedObservable getFieldOfViewChangedEvent() {
        return this.fovChanged;
    }

    public Point3D[] convertProjectiveToRealWorld(Point3D[] point3DArray) throws StatusException {
        Point3D[] point3DArray2 = new Point3D[point3DArray.length];
        int n = NativeMethods.xnConvertProjectiveToRealWorld(this.toNative(), point3DArray, point3DArray2);
        WrapperUtils.throwOnError(n);
        return point3DArray2;
    }

    public Point3D convertProjectiveToRealWorld(Point3D point3D) throws StatusException {
        Point3D[] point3DArray = new Point3D[]{point3D};
        return this.convertProjectiveToRealWorld(point3DArray)[0];
    }

    public Point3D[] convertRealWorldToProjective(Point3D[] point3DArray) throws StatusException {
        Point3D[] point3DArray2 = new Point3D[point3DArray.length];
        int n = NativeMethods.xnConvertRealWorldToProjective(this.toNative(), point3DArray, point3DArray2);
        WrapperUtils.throwOnError(n);
        return point3DArray2;
    }

    public Point3D convertRealWorldToProjective(Point3D point3D) throws StatusException {
        Point3D[] point3DArray = new Point3D[]{point3D};
        return this.convertRealWorldToProjective(point3DArray)[0];
    }

    public UserPositionCapability getUserPositionCapability() throws StatusException {
        return new UserPositionCapability(this);
    }

    public void getMetaData(DepthMetaData depthMetaData) {
        NativeMethods.xnGetDepthMetaData(this.toNative(), depthMetaData);
    }

    public DepthMetaData getMetaData() {
        DepthMetaData depthMetaData = new DepthMetaData();
        this.getMetaData(depthMetaData);
        return depthMetaData;
    }
}

