/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.AntiFlickerCapability;
import org.OpenNI.Capability;
import org.OpenNI.Context;
import org.OpenNI.CroppingCapability;
import org.OpenNI.GeneralException;
import org.OpenNI.GeneralIntCapability;
import org.OpenNI.Generator;
import org.OpenNI.IStateChangedObservable;
import org.OpenNI.MapOutputMode;
import org.OpenNI.NativeMethods;
import org.OpenNI.OutArg;
import org.OpenNI.StateChangedObservable;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class MapGenerator
extends Generator {
    private StateChangedObservable mapOutputModeChanged = new StateChangedObservable(){

        @Override
        protected int registerNative(String string, OutArg<Long> outArg) {
            return NativeMethods.xnRegisterToMapOutputModeChange(MapGenerator.this.toNative(), this, string, outArg);
        }

        @Override
        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterFromMapOutputModeChange(MapGenerator.this.toNative(), l);
        }
    };

    MapGenerator(Context context, long l, boolean bl) throws GeneralException {
        super(context, l, bl);
    }

    public MapOutputMode[] getSupportedMapOutputModes() throws StatusException {
        int n = NativeMethods.xnGetSupportedMapOutputModesCount(this.toNative());
        MapOutputMode[] mapOutputModeArray = new MapOutputMode[n];
        int n2 = NativeMethods.xnGetSupportedMapOutputModes(this.toNative(), mapOutputModeArray);
        WrapperUtils.throwOnError(n2);
        return mapOutputModeArray;
    }

    public MapOutputMode getMapOutputMode() throws StatusException {
        OutArg<Integer> outArg = new OutArg<Integer>();
        OutArg<Integer> outArg2 = new OutArg<Integer>();
        OutArg<Integer> outArg3 = new OutArg<Integer>();
        int n = NativeMethods.xnGetMapOutputMode(this.toNative(), outArg, outArg2, outArg3);
        WrapperUtils.throwOnError(n);
        return new MapOutputMode((Integer)outArg.value, (Integer)outArg2.value, (Integer)outArg3.value);
    }

    public void setMapOutputMode(MapOutputMode mapOutputMode) throws StatusException {
        int n = NativeMethods.xnSetMapOutputMode(this.toNative(), mapOutputMode.getXRes(), mapOutputMode.getYRes(), mapOutputMode.getFPS());
        WrapperUtils.throwOnError(n);
    }

    public IStateChangedObservable getMapOutputModeChangedEvent() {
        return this.mapOutputModeChanged;
    }

    public CroppingCapability getCroppingCapability() throws StatusException {
        return new CroppingCapability(this);
    }

    public GeneralIntCapability getBrightnessCapability() throws StatusException {
        return new GeneralIntCapability(this, Capability.Brightness);
    }

    public GeneralIntCapability getContrastCapability() throws StatusException {
        return new GeneralIntCapability(this, Capability.Contrast);
    }

    public GeneralIntCapability getSaturationCapability() throws StatusException {
        return new GeneralIntCapability(this, Capability.Saturation);
    }

    public GeneralIntCapability getHueCapability() throws StatusException {
        return new GeneralIntCapability(this, Capability.Hue);
    }

    public GeneralIntCapability getSharpnessCapability() throws StatusException {
        return new GeneralIntCapability(this, Capability.Sharpness);
    }

    public GeneralIntCapability getGammaCapability() throws StatusException {
        return new GeneralIntCapability(this, Capability.Gamma);
    }

    public GeneralIntCapability getWhiteBalanceCapability() throws StatusException {
        return new GeneralIntCapability(this, Capability.WhiteBalance);
    }

    public GeneralIntCapability getBacklightCompensationCapability() throws StatusException {
        return new GeneralIntCapability(this, Capability.BacklightCompensation);
    }

    public GeneralIntCapability getGainCapability() throws StatusException {
        return new GeneralIntCapability(this, Capability.Gain);
    }

    public GeneralIntCapability getPanCapability() throws StatusException {
        return new GeneralIntCapability(this, Capability.Pan);
    }

    public GeneralIntCapability getTiltCapability() throws StatusException {
        return new GeneralIntCapability(this, Capability.Tilt);
    }

    public GeneralIntCapability getRollCapability() throws StatusException {
        return new GeneralIntCapability(this, Capability.Roll);
    }

    public GeneralIntCapability getZoomCapability() throws StatusException {
        return new GeneralIntCapability(this, Capability.Zoom);
    }

    public GeneralIntCapability getExposureCapability() throws StatusException {
        return new GeneralIntCapability(this, Capability.Exposure);
    }

    public GeneralIntCapability getIrisCapability() throws StatusException {
        return new GeneralIntCapability(this, Capability.Iris);
    }

    public GeneralIntCapability getFocusCapability() throws StatusException {
        return new GeneralIntCapability(this, Capability.Focus);
    }

    public GeneralIntCapability getLowLightCompensationCapability() throws StatusException {
        return new GeneralIntCapability(this, Capability.LowLightCompensation);
    }

    public AntiFlickerCapability getAntiFlickerCapability() throws StatusException {
        return new AntiFlickerCapability(this);
    }
}

