/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import org.OpenNI.BoundingBox3D;
import org.OpenNI.Context;
import org.OpenNI.EnumerationErrors;
import org.OpenNI.GeneralException;
import org.OpenNI.Generator;
import org.OpenNI.GesturePositionEventArgs;
import org.OpenNI.GestureProgressEventArgs;
import org.OpenNI.GestureRecognizedEventArgs;
import org.OpenNI.IObservable;
import org.OpenNI.IStateChangedObservable;
import org.OpenNI.NativeMethods;
import org.OpenNI.NodeType;
import org.OpenNI.Observable;
import org.OpenNI.OutArg;
import org.OpenNI.Point3D;
import org.OpenNI.Query;
import org.OpenNI.StateChangedObservable;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class GestureGenerator
extends Generator {
    private Observable<GestureRecognizedEventArgs> gestureRecognizedEvent = new Observable<GestureRecognizedEventArgs>(){

        @Override
        protected int registerNative(OutArg<Long> outArg) throws StatusException {
            return NativeMethods.xnRegisterGestureCallbacks(GestureGenerator.this.toNative(), this, "callback", null, outArg);
        }

        @Override
        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterHandCallbacks(GestureGenerator.this.toNative(), l);
        }

        public void callback(String string, Point3D point3D, Point3D point3D2) {
            this.notify(new GestureRecognizedEventArgs(string, point3D, point3D2));
        }
    };
    private Observable<GestureProgressEventArgs> gestureProgressEvent = new Observable<GestureProgressEventArgs>(){

        @Override
        protected int registerNative(OutArg<Long> outArg) throws StatusException {
            return NativeMethods.xnRegisterGestureCallbacks(GestureGenerator.this.toNative(), this, null, "callback", outArg);
        }

        @Override
        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterHandCallbacks(GestureGenerator.this.toNative(), l);
        }

        public void callback(String string, Point3D point3D, float f) {
            this.notify(new GestureProgressEventArgs(string, point3D, f));
        }
    };
    private Observable<GesturePositionEventArgs> gestureIntermediateStageCompletedEvent = new Observable<GesturePositionEventArgs>(){

        @Override
        protected int registerNative(OutArg<Long> outArg) throws StatusException {
            return NativeMethods.xnRegisterToGestureIntermediateStageCompleted(GestureGenerator.this.toNative(), this, "callback", outArg);
        }

        @Override
        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterFromGestureIntermediateStageCompleted(GestureGenerator.this.toNative(), l);
        }

        public void callback(String string, Point3D point3D) {
            this.notify(new GesturePositionEventArgs(string, point3D));
        }
    };
    private Observable<GesturePositionEventArgs> gestureReadyForNextIntermediateStageEvent = new Observable<GesturePositionEventArgs>(){

        @Override
        protected int registerNative(OutArg<Long> outArg) throws StatusException {
            return NativeMethods.xnRegisterToGestureReadyForNextIntermediateStage(GestureGenerator.this.toNative(), this, "callback", outArg);
        }

        @Override
        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterFromGestureReadyForNextIntermediateStage(GestureGenerator.this.toNative(), l);
        }

        public void callback(String string, Point3D point3D) {
            this.notify(new GesturePositionEventArgs(string, point3D));
        }
    };
    private StateChangedObservable gestureChangedEvent = new StateChangedObservable(){

        @Override
        protected int registerNative(String string, OutArg<Long> outArg) {
            return NativeMethods.xnRegisterToGestureChange(GestureGenerator.this.toNative(), this, string, outArg);
        }

        @Override
        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterFromGestureChange(GestureGenerator.this.toNative(), l);
        }
    };

    GestureGenerator(Context context, long l, boolean bl) throws GeneralException {
        super(context, l, bl);
    }

    public static GestureGenerator create(Context context, Query query, EnumerationErrors enumerationErrors) throws GeneralException {
        OutArg<Long> outArg = new OutArg<Long>();
        int n = NativeMethods.xnCreateGestureGenerator(context.toNative(), outArg, query == null ? 0L : query.toNative(), enumerationErrors == null ? 0L : enumerationErrors.toNative());
        WrapperUtils.throwOnError(n);
        GestureGenerator gestureGenerator = (GestureGenerator)context.createProductionNodeObject((Long)outArg.value, NodeType.GESTURE);
        NativeMethods.xnProductionNodeRelease((Long)outArg.value);
        return gestureGenerator;
    }

    public static GestureGenerator create(Context context, Query query) throws GeneralException {
        return GestureGenerator.create(context, query, null);
    }

    public static GestureGenerator create(Context context) throws GeneralException {
        return GestureGenerator.create(context, null, null);
    }

    public void addGesture(String string) throws StatusException {
        int n = NativeMethods.xnAddGesture(this.toNative(), string);
        WrapperUtils.throwOnError(n);
    }

    public void addGesture(String string, BoundingBox3D boundingBox3D) throws StatusException {
        if (boundingBox3D == null) {
            this.addGesture(string);
            return;
        }
        int n = NativeMethods.xnAddGesture(this.toNative(), string, boundingBox3D.getMins().getX(), boundingBox3D.getMins().getY(), boundingBox3D.getMins().getZ(), boundingBox3D.getMaxs().getX(), boundingBox3D.getMaxs().getY(), boundingBox3D.getMaxs().getZ());
        WrapperUtils.throwOnError(n);
    }

    public void removeGesture(String string) throws StatusException {
        int n = NativeMethods.xnRemoveGesture(this.toNative(), string);
        WrapperUtils.throwOnError(n);
    }

    public int getNumberOfAvailableGestures() {
        return NativeMethods.xnGetNumberOfAvailableGestures(this.toNative());
    }

    public boolean isGestureAvailable(String string) {
        return NativeMethods.xnIsGestureAvailable(this.toNative(), string);
    }

    public boolean isGestureProgressSupported(String string) {
        return NativeMethods.xnIsGestureProgressSupported(this.toNative(), string);
    }

    public String[] enumerateAllGestures() throws StatusException {
        OutArg<String[]> outArg = new OutArg<String[]>();
        int n = NativeMethods.xnEnumerateAllGestures(this.toNative(), outArg);
        WrapperUtils.throwOnError(n);
        return (String[])outArg.value;
    }

    public String[] getAllActiveGestures() throws StatusException {
        OutArg<String[]> outArg = new OutArg<String[]>();
        int n = NativeMethods.xnGetAllActiveGestures(this.toNative(), outArg);
        WrapperUtils.throwOnError(n);
        return (String[])outArg.value;
    }

    public IObservable<GestureRecognizedEventArgs> getGestureRecognizedEvent() {
        return this.gestureRecognizedEvent;
    }

    public IObservable<GestureProgressEventArgs> getGestureProgressEvent() {
        return this.gestureProgressEvent;
    }

    public IObservable<GesturePositionEventArgs> getGestureIntermediateStageCompletedEvent() {
        return this.gestureIntermediateStageCompletedEvent;
    }

    public IObservable<GesturePositionEventArgs> getGestureReadyForNextIntermediateStageEvent() {
        return this.gestureReadyForNextIntermediateStageEvent;
    }

    public IStateChangedObservable getGestureChangedEvent() {
        return this.gestureChangedEvent;
    }
}

