/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI.Samples.SimpleRead;

import org.OpenNI.Context;
import org.OpenNI.DepthGenerator;
import org.OpenNI.DepthMetaData;
import org.OpenNI.ErrorStateEventArgs;
import org.OpenNI.IObservable;
import org.OpenNI.IObserver;
import org.OpenNI.NodeType;
import org.OpenNI.OutArg;

public class SimpleRead
implements IObserver<ErrorStateEventArgs> {
    public static final String SAMPLES_XML = "../../Config/SamplesConfig.xml";

    public static void main(String[] stringArray) {
        try {
            OutArg outArg = new OutArg();
            Context context = Context.createFromXmlFile((String)SAMPLES_XML, (OutArg)outArg);
            SimpleRead simpleRead = new SimpleRead();
            context.getErrorStateChangedEvent().addObserver((IObserver)simpleRead);
            DepthGenerator depthGenerator = (DepthGenerator)context.findExistingNode(NodeType.DEPTH);
            DepthMetaData depthMetaData = new DepthMetaData();
            while (true) {
                context.waitAnyUpdateAll();
                depthGenerator.getMetaData(depthMetaData);
                System.out.printf("Frame %d Middle point is: %d.\n", depthMetaData.getFrameID(), depthMetaData.getData().readPixel(depthMetaData.getXRes() / 2, depthMetaData.getYRes() / 2));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public void update(IObservable<ErrorStateEventArgs> iObservable, ErrorStateEventArgs errorStateEventArgs) {
        System.out.printf("Global error state has changed: %s", errorStateEventArgs.getCurrentError());
        System.exit(1);
    }
}

