/*
 * Decompiled with CFR 0.152.
 */
package org.OpenNI;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.OpenNI.AlternativeViewpointCapability;
import org.OpenNI.Context;
import org.OpenNI.FrameSyncCapability;
import org.OpenNI.GeneralException;
import org.OpenNI.IStateChangedObservable;
import org.OpenNI.MirrorCapability;
import org.OpenNI.NativeMethods;
import org.OpenNI.OutArg;
import org.OpenNI.ProductionNode;
import org.OpenNI.StateChangedObservable;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class Generator
extends ProductionNode {
    private StateChangedObservable generationRunningChanged = new StateChangedObservable(){

        @Override
        protected int registerNative(String string, OutArg<Long> outArg) {
            return NativeMethods.xnRegisterToGenerationRunningChange(Generator.this.toNative(), this, string, outArg);
        }

        @Override
        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterFromGenerationRunningChange(Generator.this.toNative(), l);
        }
    };
    private StateChangedObservable newDataAvailable = new StateChangedObservable(){

        @Override
        protected int registerNative(String string, OutArg<Long> outArg) {
            return NativeMethods.xnRegisterToNewDataAvailable(Generator.this.toNative(), this, string, outArg);
        }

        @Override
        protected void unregisterNative(long l) {
            NativeMethods.xnUnregisterFromNewDataAvailable(Generator.this.toNative(), l);
        }
    };

    Generator(Context context, long l, boolean bl) throws GeneralException {
        super(context, l, bl);
    }

    public void startGenerating() throws StatusException {
        int n = NativeMethods.xnStartGenerating(this.toNative());
        WrapperUtils.throwOnError(n);
    }

    public boolean isGenerating() {
        return NativeMethods.xnIsGenerating(this.toNative());
    }

    public void stopGenerating() throws StatusException {
        int n = NativeMethods.xnStopGenerating(this.toNative());
        WrapperUtils.throwOnError(n);
    }

    public IStateChangedObservable getGenerationRunningChangedEvent() {
        return this.generationRunningChanged;
    }

    public boolean isNewDataAvailable() {
        OutArg<Long> outArg = new OutArg<Long>();
        return NativeMethods.xnIsNewDataAvailable(this.toNative(), outArg);
    }

    public long getAvailableTimestamp() {
        OutArg<Long> outArg = new OutArg<Long>();
        NativeMethods.xnIsNewDataAvailable(this.toNative(), outArg);
        return (Long)outArg.value;
    }

    public IStateChangedObservable getNewDataAvailableEvent() {
        return this.newDataAvailable;
    }

    public void waitAndUpdateData() throws StatusException {
        int n = NativeMethods.xnWaitAndUpdateData(this.toNative());
        WrapperUtils.throwOnError(n);
    }

    public boolean isDataNew() {
        return NativeMethods.xnIsDataNew(this.toNative());
    }

    public int getDataSize() {
        return NativeMethods.xnGetDataSize(this.toNative());
    }

    public long getDataPtr() {
        return NativeMethods.xnGetData(this.toNative());
    }

    public ByteBuffer createDataByteBuffer() {
        int n = this.getDataSize();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        NativeMethods.copyToBuffer(byteBuffer, this.getDataPtr(), n);
        return byteBuffer;
    }

    public void copyDataToBuffer(ByteBuffer byteBuffer, int n) {
        NativeMethods.copyToBuffer(byteBuffer, this.getDataPtr(), n);
    }

    public long getTimestamp() {
        return NativeMethods.xnGetTimestamp(this.toNative());
    }

    public int getFrameID() {
        return NativeMethods.xnGetFrameID(this.toNative());
    }

    public MirrorCapability getMirrorCapability() throws StatusException {
        return new MirrorCapability(this);
    }

    public AlternativeViewpointCapability getAlternativeViewpointCapability() throws StatusException {
        return new AlternativeViewpointCapability(this);
    }

    public FrameSyncCapability getFrameSyncCapability() throws StatusException {
        return new FrameSyncCapability(this);
    }
}

