/*
 * Decompiled with CFR 0.152.
 */
package com.primesense.NITE.Samples.Boxes;

import com.primesense.NITE.Broadcaster;
import com.primesense.NITE.DirectionVelocityAngleEventArgs;
import com.primesense.NITE.FlowRouter;
import com.primesense.NITE.HandPointEventArgs;
import com.primesense.NITE.IdEventArgs;
import com.primesense.NITE.IdValueEventArgs;
import com.primesense.NITE.MessageListener;
import com.primesense.NITE.PointControl;
import com.primesense.NITE.PointerEventArgs;
import com.primesense.NITE.PushDetector;
import com.primesense.NITE.Samples.Boxes.LeaveEvent;
import com.primesense.NITE.SteadyDetector;
import com.primesense.NITE.SwipeDetector;
import com.primesense.NITE.VelocityAngleEventArgs;
import java.awt.Color;
import java.awt.Component;
import java.util.Observable;
import org.OpenNI.GeneralException;
import org.OpenNI.IObservable;
import org.OpenNI.IObserver;
import org.OpenNI.StatusException;

public class MyBox
extends PointControl {
    private PushDetector pushDetector;
    private SwipeDetector swipeDetector;
    private SteadyDetector steadyDetector;
    private FlowRouter flowRouter;
    private Broadcaster broadcaster;
    private final String _name;
    private Component _panel;
    private LeaveEvent leaveEvent;

    public MyBox(String string, Component component) throws GeneralException {
        this._name = string;
        this._panel = component;
        this.pushDetector = new PushDetector();
        this.swipeDetector = new SwipeDetector();
        this.steadyDetector = new SteadyDetector();
        this.flowRouter = new FlowRouter();
        this.broadcaster = new Broadcaster();
        this.broadcaster.addListener((MessageListener)this.pushDetector);
        this.broadcaster.addListener((MessageListener)this.flowRouter);
        this.pushDetector.getPushEvent().addObserver((IObserver)new IObserver<VelocityAngleEventArgs>(){

            public void update(IObservable<VelocityAngleEventArgs> iObservable, VelocityAngleEventArgs velocityAngleEventArgs) {
                MyBox.this.leaveEvent.raise();
            }
        });
        this.steadyDetector.getSteadyEvent().addObserver((IObserver)new IObserver<IdValueEventArgs>(){

            public void update(IObservable<IdValueEventArgs> iObservable, IdValueEventArgs idValueEventArgs) {
                block4: {
                    System.out.println("Box " + MyBox.this._name + ": Steady");
                    try {
                        if (idValueEventArgs.getId() != MyBox.this.getPrimaryID()) break block4;
                        try {
                            MyBox.this.flowRouter.setActive((MessageListener)MyBox.this.swipeDetector);
                        }
                        catch (StatusException statusException) {
                            statusException.printStackTrace();
                        }
                        MyBox.this.ChangeColor(Color.WHITE);
                    }
                    catch (StatusException statusException) {
                        statusException.printStackTrace();
                    }
                }
            }
        });
        this.swipeDetector.getGeneralSwipeEvent().addObserver((IObserver)new IObserver<DirectionVelocityAngleEventArgs>(){

            public void update(IObservable<DirectionVelocityAngleEventArgs> iObservable, DirectionVelocityAngleEventArgs directionVelocityAngleEventArgs) {
                System.out.println("Box " + MyBox.this._name + ": Swipe " + directionVelocityAngleEventArgs.getDirection());
                try {
                    MyBox.this.flowRouter.setActive((MessageListener)MyBox.this.steadyDetector);
                }
                catch (StatusException statusException) {
                    statusException.printStackTrace();
                }
                MyBox.this.ChangeColor(Color.RED);
            }
        });
        this.getPrimaryPointCreateEvent().addObserver((IObserver)new IObserver<HandPointEventArgs>(){

            public void update(IObservable<HandPointEventArgs> iObservable, HandPointEventArgs handPointEventArgs) {
                try {
                    MyBox.this.flowRouter.setActive((MessageListener)MyBox.this.steadyDetector);
                }
                catch (StatusException statusException) {
                    statusException.printStackTrace();
                }
            }
        });
        this.getPrimaryPointDestroyEvent().addObserver((IObserver)new IObserver<IdEventArgs>(){

            public void update(IObservable<IdEventArgs> iObservable, IdEventArgs idEventArgs) {
                MyBox.this.ChangeColor(Color.CYAN);
            }
        });
        this.getMessageUpdateEvent().addObserver((IObserver)new IObserver<PointerEventArgs>(){

            public void update(IObservable<PointerEventArgs> iObservable, PointerEventArgs pointerEventArgs) {
                try {
                    MyBox.this.broadcaster.updateMessage(pointerEventArgs.getPointer());
                }
                catch (StatusException statusException) {
                    statusException.printStackTrace();
                }
            }
        });
        this.leaveEvent = new LeaveEvent();
    }

    public void ChangeColor(Color color) {
        this._panel.setBackground(color);
    }

    public Observable getLeaveEvent() {
        return this.leaveEvent;
    }
}

