/*
 * Decompiled with CFR 0.152.
 */
package com.primesense.NITE;

import com.primesense.NITE.Direction;
import com.primesense.NITE.DirectionVelocityAngleEventArgs;
import com.primesense.NITE.NativeMethods;
import com.primesense.NITE.PointControl;
import com.primesense.NITE.VelocityAngleEventArgs;
import org.OpenNI.GeneralException;
import org.OpenNI.IObservable;
import org.OpenNI.Observable;
import org.OpenNI.OutArg;
import org.OpenNI.StatusException;
import org.OpenNI.WrapperUtils;

public class SwipeDetector
extends PointControl {
    private Observable<DirectionVelocityAngleEventArgs> swipeEvent = new Observable<DirectionVelocityAngleEventArgs>(){

        protected int registerNative(OutArg<Long> outArg) {
            return NativeMethods.xnvSwipeDetector_RegisterGeneralSwipe(SwipeDetector.this.toNative(), (Object)this, "callback", outArg);
        }

        protected void unregisterNative(long l) {
            NativeMethods.xnvSwipeDetector_UnregisterGeneralSwipe(SwipeDetector.this.toNative(), l);
        }

        public void callback(int n, float f, float f2) {
            this.notify((Object)new DirectionVelocityAngleEventArgs(Direction.fromNative(n), f, f2));
        }
    };
    private Observable<VelocityAngleEventArgs> swipeUpEvent = new Observable<VelocityAngleEventArgs>(){

        protected int registerNative(OutArg<Long> outArg) {
            return NativeMethods.xnvSwipeDetector_RegisterSwipeUp(SwipeDetector.this.toNative(), (Object)this, "callback", outArg);
        }

        protected void unregisterNative(long l) {
            NativeMethods.xnvSwipeDetector_UnregisterSwipeUp(SwipeDetector.this.toNative(), l);
        }

        public void callback(float f, float f2) {
            this.notify((Object)new VelocityAngleEventArgs(f, f2));
        }
    };
    private Observable<VelocityAngleEventArgs> swipeDownEvent = new Observable<VelocityAngleEventArgs>(){

        protected int registerNative(OutArg<Long> outArg) {
            return NativeMethods.xnvSwipeDetector_RegisterSwipeDown(SwipeDetector.this.toNative(), (Object)this, "callback", outArg);
        }

        protected void unregisterNative(long l) {
            NativeMethods.xnvSwipeDetector_UnregisterSwipeDown(SwipeDetector.this.toNative(), l);
        }

        public void callback(float f, float f2) {
            this.notify((Object)new VelocityAngleEventArgs(f, f2));
        }
    };
    private Observable<VelocityAngleEventArgs> swipeLeftEvent = new Observable<VelocityAngleEventArgs>(){

        protected int registerNative(OutArg<Long> outArg) {
            return NativeMethods.xnvSwipeDetector_RegisterSwipeLeft(SwipeDetector.this.toNative(), (Object)this, "callback", outArg);
        }

        protected void unregisterNative(long l) {
            NativeMethods.xnvSwipeDetector_UnregisterSwipeLeft(SwipeDetector.this.toNative(), l);
        }

        public void callback(float f, float f2) {
            this.notify((Object)new VelocityAngleEventArgs(f, f2));
        }
    };
    private Observable<VelocityAngleEventArgs> swipeRightEvent = new Observable<VelocityAngleEventArgs>(){

        protected int registerNative(OutArg<Long> outArg) {
            return NativeMethods.xnvSwipeDetector_RegisterSwipeRight(SwipeDetector.this.toNative(), (Object)this, "callback", outArg);
        }

        protected void unregisterNative(long l) {
            NativeMethods.xnvSwipeDetector_UnregisterSwipeRight(SwipeDetector.this.toNative(), l);
        }

        public void callback(float f, float f2) {
            this.notify((Object)new VelocityAngleEventArgs(f, f2));
        }
    };

    public SwipeDetector(String string) throws GeneralException {
        super(NativeMethods.xnvSwipeDetector_Create(true, string));
    }

    public SwipeDetector() throws GeneralException {
        this("SwipeDetector");
    }

    @Override
    protected void freeObject() {
        super.freeObject();
        NativeMethods.xnvSwipeDetector_Destroy(this.toNative());
    }

    public void setMotionSpeedThreshold(float f) throws StatusException {
        int n = NativeMethods.xnvSwipeDetector_SetMotionSpeedThreshold(this.toNative(), f);
        WrapperUtils.throwOnError((int)n);
    }

    public void setMotionTime(int n) throws StatusException {
        int n2 = NativeMethods.xnvSwipeDetector_SetMotionTime(this.toNative(), n);
        WrapperUtils.throwOnError((int)n2);
    }

    public void setXAngleThreshold(float f) throws StatusException {
        int n = NativeMethods.xnvSwipeDetector_SetXAngleThreshold(this.toNative(), f);
        WrapperUtils.throwOnError((int)n);
    }

    public void setYAngleThreshold(float f) throws StatusException {
        int n = NativeMethods.xnvSwipeDetector_SetYAngleThreshold(this.toNative(), f);
        WrapperUtils.throwOnError((int)n);
    }

    public void setSteadyMaxDeviation(float f) throws StatusException {
        int n = NativeMethods.xnvSwipeDetector_SetSteadyMaxStdDev(this.toNative(), f);
        WrapperUtils.throwOnError((int)n);
    }

    public void setSteadyDuration(int n) throws StatusException {
        int n2 = NativeMethods.xnvSwipeDetector_SetSteadyDuration(this.toNative(), n);
        WrapperUtils.throwOnError((int)n2);
    }

    public void setUseSteady(boolean bl) throws StatusException {
        int n = NativeMethods.xnvSwipeDetector_SetUseSteady(this.toNative(), bl);
        WrapperUtils.throwOnError((int)n);
    }

    public float getMotionSpeedThreshold() throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvSwipeDetector_GetMotionSpeedThreshold(this.toNative(), (OutArg<Float>)outArg);
        WrapperUtils.throwOnError((int)n);
        return ((Float)outArg.value).floatValue();
    }

    public int getMotionTime() throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvSwipeDetector_GetMotionTime(this.toNative(), (OutArg<Integer>)outArg);
        WrapperUtils.throwOnError((int)n);
        return (Integer)outArg.value;
    }

    public float getXAngleThreshold() throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvSwipeDetector_GetXAngleThreshold(this.toNative(), (OutArg<Float>)outArg);
        WrapperUtils.throwOnError((int)n);
        return ((Float)outArg.value).floatValue();
    }

    public float getYAngleThreshold() throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvSwipeDetector_GetYAngleThreshold(this.toNative(), (OutArg<Float>)outArg);
        WrapperUtils.throwOnError((int)n);
        return ((Float)outArg.value).floatValue();
    }

    public float getSteadyMaxDeviation() throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvSwipeDetector_GetSteadyMaxStdDev(this.toNative(), (OutArg<Float>)outArg);
        WrapperUtils.throwOnError((int)n);
        return ((Float)outArg.value).floatValue();
    }

    public int getSteadyDuration() throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvSwipeDetector_GetSteadyDuration(this.toNative(), (OutArg<Integer>)outArg);
        WrapperUtils.throwOnError((int)n);
        return (Integer)outArg.value;
    }

    public boolean getUseSteady() throws StatusException {
        OutArg outArg = new OutArg();
        int n = NativeMethods.xnvSwipeDetector_GetUseSteady(this.toNative(), (OutArg<Boolean>)outArg);
        WrapperUtils.throwOnError((int)n);
        return (Boolean)outArg.value;
    }

    public IObservable<DirectionVelocityAngleEventArgs> getGeneralSwipeEvent() {
        return this.swipeEvent;
    }

    public IObservable<VelocityAngleEventArgs> getSwipeUpEvent() {
        return this.swipeUpEvent;
    }

    public IObservable<VelocityAngleEventArgs> getSwipeDownEvent() {
        return this.swipeDownEvent;
    }

    public IObservable<VelocityAngleEventArgs> getSwipeLeftEvent() {
        return this.swipeLeftEvent;
    }

    public IObservable<VelocityAngleEventArgs> getSwipeRightEvent() {
        return this.swipeRightEvent;
    }
}

